/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.Shell;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.InputAbstract;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionProtocol;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.qpid.jms.JmsConnectionFactory;
import picocli.CommandLine;

public class ConnectionAbstract
extends InputAbstract {
    @CommandLine.Option(names={"--url"}, description={"Connection URL. Default: build URL from the 'artemis' acceptor defined in the broker.xml or tcp://localhost:61616 if the acceptor cannot be parsed."})
    protected String brokerURL = "tcp://localhost:61616";
    @CommandLine.Option(names={"--acceptor"}, description={"Name used to find the default connection URL on the acceptor list. If an acceptor with that name cannot be found the CLI will look for a connector with the same name."})
    protected String acceptor;
    @CommandLine.Option(names={"--user"}, description={"User used to connect."})
    protected String user;
    @CommandLine.Option(names={"--password"}, description={"Password used to connect."})
    protected String password;
    @CommandLine.Option(names={"--clientID"}, description={"ClientID set on the connection."})
    protected String clientID;
    @CommandLine.Option(names={"--protocol"}, description={"Protocol used. Valid values are ${COMPLETION-CANDIDATES}"}, converter={ConnectionProtocol.ProtocolConverter.class})
    protected ConnectionProtocol protocol = ConnectionProtocol.CORE;
    protected static ThreadLocal<ConnectionInformation> CONNECTION_INFORMATION = new ThreadLocal();

    public String getBrokerURL() {
        return this.brokerURL;
    }

    public void setBrokerURL(String brokerURL) {
        this.brokerURL = brokerURL;
    }

    public String getAcceptor() {
        return this.acceptor;
    }

    public ConnectionAbstract setAcceptor(String acceptor) {
        this.acceptor = acceptor;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public ConnectionAbstract setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ConnectionAbstract setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getClientID() {
        return this.clientID;
    }

    public ConnectionAbstract setClientID(String clientID) {
        this.clientID = clientID;
        return this;
    }

    public ConnectionProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ConnectionProtocol protocol) {
        this.protocol = protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = ConnectionProtocol.fromString(protocol);
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        String brokerURLInstance;
        super.execute(context);
        this.recoverConnectionInformation();
        if (this.brokerURL == "tcp://localhost:61616" && (brokerURLInstance = this.getBrokerURLInstance(this.acceptor)) != null) {
            this.brokerURL = brokerURLInstance;
        }
        context.out.println("Connection brokerURL = " + this.brokerURL);
        return null;
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        this.recoverConnectionInformation();
        return this.createConnectionFactory(this.brokerURL, this.user, this.password, this.clientID, this.protocol);
    }

    protected ConnectionFactory createConnectionFactory(String brokerURL, String user, String password, String clientID, ConnectionProtocol protocol) throws Exception {
        if (protocol == ConnectionProtocol.CORE) {
            return this.createCoreConnectionFactory(brokerURL, user, password, clientID);
        }
        if (protocol == ConnectionProtocol.AMQP) {
            return this.createAMQPConnectionFactory(brokerURL, user, password, clientID);
        }
        throw new IllegalStateException("protocol " + protocol + " not supported");
    }

    private ConnectionFactory createAMQPConnectionFactory(String brokerURL, String user, String password, String clientID) {
        if (((String)brokerURL).startsWith("tcp://")) {
            brokerURL = "amqp" + ((String)brokerURL).substring(3);
        }
        JmsConnectionFactory cf = new JmsConnectionFactory(user, password, (String)brokerURL);
        if (clientID != null) {
            cf.setClientID(clientID);
        }
        try {
            this.tryConnect((String)brokerURL, user, password, (ConnectionFactory)cf);
            return cf;
        }
        catch (JMSSecurityException e) {
            this.getActionContext().err.println("Connection failed::" + e.getMessage());
            user = this.inputUser(user);
            password = this.inputPassword(password);
            cf = new JmsConnectionFactory(user, password, (String)brokerURL);
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            try {
                this.tryConnect((String)brokerURL, user, password, (ConnectionFactory)cf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return cf;
        }
        catch (JMSException e) {
            this.getActionContext().err.println("Connection failed::" + e.getMessage());
            brokerURL = this.inputBrokerURL((String)brokerURL);
            user = this.inputUser(user);
            password = this.inputPassword(password);
            cf = new JmsConnectionFactory(user, password, (String)brokerURL);
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            try {
                this.tryConnect((String)brokerURL, user, password, (ConnectionFactory)cf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return cf;
        }
    }

    protected ActiveMQConnectionFactory createCoreConnectionFactory() {
        this.recoverConnectionInformation();
        return this.createCoreConnectionFactory(this.brokerURL, this.user, this.password, this.clientID);
    }

    protected void recoverConnectionInformation() {
        if (CONNECTION_INFORMATION.get() != null) {
            ConnectionInformation connectionInfo = CONNECTION_INFORMATION.get();
            if (this.user == null) {
                this.user = connectionInfo.user;
            }
            if (this.password == null) {
                this.password = connectionInfo.password;
            }
            if (this.brokerURL == null || this.brokerURL == "tcp://localhost:61616") {
                this.brokerURL = connectionInfo.uri;
            }
        }
    }

    void saveConnectionInfo(String brokerURL, String user, String password) {
        if (Shell.inShell() && CONNECTION_INFORMATION.get() == null) {
            CONNECTION_INFORMATION.set(new ConnectionInformation(brokerURL, user, password));
            System.out.println("CLI connected to broker " + brokerURL + ", user:" + user);
            this.brokerURL = brokerURL;
            this.user = user;
            this.password = password;
        }
    }

    protected ActiveMQConnectionFactory createCoreConnectionFactory(String brokerURL, String user, String password, String clientID) {
        if (((String)brokerURL).startsWith("amqp://")) {
            brokerURL = "tcp" + ((String)brokerURL).substring(4);
        }
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory((String)brokerURL, user, password);
        if (clientID != null) {
            this.getActionContext().out.println("Consumer:: clientID = " + clientID);
            cf.setClientID(clientID);
        }
        try {
            this.tryConnect((String)brokerURL, user, password, (ConnectionFactory)cf);
            return cf;
        }
        catch (JMSSecurityException e) {
            if (this.getActionContext() != null) {
                this.getActionContext().err.println("Connection failed::" + e.getMessage());
            }
            user = this.inputUser(user);
            password = this.inputPassword(password);
            cf = new ActiveMQConnectionFactory((String)brokerURL, user, password);
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            try {
                this.tryConnect((String)brokerURL, user, password, (ConnectionFactory)cf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return cf;
        }
        catch (JMSException e) {
            if (this.getActionContext() != null) {
                this.getActionContext().err.println("Connection failed::" + e.getMessage());
            }
            brokerURL = this.inputBrokerURL((String)brokerURL);
            user = this.inputUser(user);
            password = this.inputPassword(password);
            cf = new ActiveMQConnectionFactory((String)brokerURL, user, password);
            if (clientID != null) {
                cf.setClientID(clientID);
            }
            try {
                this.tryConnect((String)brokerURL, user, password, (ConnectionFactory)cf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return cf;
        }
    }

    private void tryConnect(String brokerURL, String user, String password, ConnectionFactory cf) throws JMSException {
        Connection connection = cf.createConnection();
        connection.close();
        this.saveConnectionInfo(brokerURL, user, password);
    }

    private String inputBrokerURL(String defaultValue) {
        return this.input("--url", "Type in the connection URL for a retry (e.g. tcp://localhost:61616)", defaultValue);
    }

    private String inputUser(String user) {
        if (user == null) {
            this.user = this.input("--user", "Type the username for a retry", null);
            return this.user;
        }
        return user;
    }

    private String inputPassword(String password) {
        if (password == null) {
            this.password = this.inputPassword("--password", "Type the password for a retry", null);
            return this.password;
        }
        return password;
    }

    protected void performCoreManagement(ManagementHelper.MessageAcceptor setup, ManagementHelper.MessageAcceptor ok, ManagementHelper.MessageAcceptor failed) throws Exception {
        try (ActiveMQConnectionFactory factory = this.createCoreConnectionFactory();){
            ManagementHelper.doManagement((ServerLocator)factory.getServerLocator(), (String)this.user, (String)this.password, (ManagementHelper.MessageAcceptor)setup, (ManagementHelper.MessageAcceptor)ok, (ManagementHelper.MessageAcceptor)failed);
        }
    }

    protected void performCoreManagement(String uri, String user, String password, ManagementHelper.MessageAcceptor setup, ManagementHelper.MessageAcceptor ok, ManagementHelper.MessageAcceptor failed) throws Exception {
        try (ActiveMQConnectionFactory factory = this.createCoreConnectionFactory(uri, user, password, null);){
            ManagementHelper.doManagement((ServerLocator)factory.getServerLocator(), (String)user, (String)password, (ManagementHelper.MessageAcceptor)setup, (ManagementHelper.MessageAcceptor)ok, (ManagementHelper.MessageAcceptor)failed);
        }
    }

    static class ConnectionInformation {
        String uri;
        String user;
        String password;

        private ConnectionInformation(String uri, String user, String password) {
            this.uri = uri;
            this.user = user;
            this.password = password;
        }
    }
}

