/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.io.Serializable;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ServiceConfigurationError;
import java.util.Set;
import org.hibernate.search.engine.cfg.spi.ConfigurationProvider;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.spi.BeanNotFoundException;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.common.RewriteMethod;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.engine.search.projection.definition.ProjectionDefinition;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter;
import org.hibernate.search.util.common.logging.impl.SimpleNameClassFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void startingExecutor(String name) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingExecutor$str(), (Object)name);
    }

    protected String startingExecutor$str() {
        return "HSEARCH000230: Starting executor '%1$s'";
    }

    @Override
    public final void stoppingExecutor(String indexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.stoppingExecutor$str(), (Object)indexName);
    }

    protected String stoppingExecutor$str() {
        return "HSEARCH000231: Stopping executor '%1$s'";
    }

    protected String rangePredicateCannotMatchNullValue$str() {
        return "HSEARCH000237: Invalid range: at least one bound in range predicates must be non-null.";
    }

    @Override
    public final SearchException rangePredicateCannotMatchNullValue(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.rangePredicateCannotMatchNullValue$str(), new Object[0]), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String noPublicNoArgConstructor$str() {
        return "HSEARCH000242: Invalid type '%1$s': missing constructor. The type must expose a public, no-arguments constructor.";
    }

    @Override
    public final SearchException noPublicNoArgConstructor(Class<?> clazz) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noPublicNoArgConstructor$str(), new ClassFormatter(clazz)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToConvertConfigurationProperty$str() {
        return "HSEARCH000501: Invalid value for configuration property '%1$s': '%2$s'. %3$s";
    }

    @Override
    public final SearchException unableToConvertConfigurationProperty(String key, Object rawValue, String errorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToConvertConfigurationProperty$str(), key, rawValue, errorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPropertyValue$str() {
        return "HSEARCH000502: Invalid value: expected either an instance of '%1$s' or a String that can be parsed into that type. %2$s";
    }

    @Override
    public final SearchException invalidPropertyValue(Class<?> expectedType, String errorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidPropertyValue$str(), new ClassFormatter(expectedType), errorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidBooleanPropertyValue$str() {
        return "HSEARCH000503: Invalid Boolean value: expected either a Boolean, the String 'true' or the String 'false'. %1$s";
    }

    @Override
    public final SearchException invalidBooleanPropertyValue(String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidBooleanPropertyValue$str(), nestedErrorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIntegerPropertyValue$str() {
        return "HSEARCH000504: Invalid Integer value: expected either a Number or a String that can be parsed into an Integer. %1$s";
    }

    @Override
    public final SearchException invalidIntegerPropertyValue(String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIntegerPropertyValue$str(), nestedErrorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidLongPropertyValue$str() {
        return "HSEARCH000505: Invalid Long value: expected either a Number or a String that can be parsed into a Long. %1$s";
    }

    @Override
    public final SearchException invalidLongPropertyValue(String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidLongPropertyValue$str(), nestedErrorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMultiPropertyValue$str() {
        return "HSEARCH000506: Invalid multi value: expected either a single value of the correct type, a Collection, or a String, and interpreting as a single value failed with the following exception. %1$s";
    }

    @Override
    public final SearchException invalidMultiPropertyValue(String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidMultiPropertyValue$str(), nestedErrorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String relativeFieldNameCannotBeNullOrEmpty$str() {
        return "HSEARCH000514: Invalid index field name '%1$s': field names cannot be null or empty.";
    }

    @Override
    public final SearchException relativeFieldNameCannotBeNullOrEmpty(String relativeFieldName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.relativeFieldNameCannotBeNullOrEmpty$str(), relativeFieldName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String relativeFieldNameCannotContainDot$str() {
        return "HSEARCH000515: Invalid index field name '%1$s': field names cannot contain a dot ('.'). Remove the dot from your field name, or if you are declaring the field in a bridge and want a tree of fields, declare an object field using the objectField() method.";
    }

    @Override
    public final SearchException relativeFieldNameCannotContainDot(String relativeFieldName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.relativeFieldNameCannotContainDot$str(), relativeFieldName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str() {
        return "HSEARCH000516: Invalid polygon: the first point '%1$s' should be identical to the last point '%2$s' to properly close the polygon.";
    }

    @Override
    public final IllegalArgumentException invalidGeoPolygonFirstPointNotIdenticalToLastPoint(GeoPoint firstPoint, GeoPoint lastPoint) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str(), firstPoint, lastPoint));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String collectedFailureLimitReached$str() {
        return "HSEARCH000519: Hibernate Search encountered %3$s failures during %1$s. Only the first %2$s failures are displayed here. See the TRACE logs for extra failures.";
    }

    @Override
    public final String collectedFailureLimitReached(String process, int failureLimit, int failureCount) {
        return String.format(this.getLoggingLocale(), this.collectedFailureLimitReached$str(), process, failureLimit, failureCount);
    }

    protected String collectedFailures$str() {
        return "HSEARCH000520: Hibernate Search encountered failures during %1$s. Failures:\n%2$s";
    }

    @Override
    public final SearchException collectedFailures(String process, String renderedFailures, Collection<Throwable> failures) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.collectedFailures$str(), process, renderedFailures));
        Log_$logger._copyStackTraceMinusOne(result);
        failures.forEach($failuresVar -> result.addSuppressed($failuresVar));
        return result;
    }

    @Override
    public final void newCollectedFailure(String process, EventContextProvider contextProvider, Throwable failure) {
        this.log.logf(FQCN, Logger.Level.TRACE, failure, this.newCollectedFailure$str(), (Object)process, (Object)new EventContextFormatter(contextProvider));
    }

    protected String newCollectedFailure$str() {
        return "HSEARCH000521: Hibernate Search encountered a failure during %1$s; continuing for now to list all problems, but the process will ultimately be aborted.\n%2$s\nFailure:";
    }

    @Override
    public final void exceptionWhileCollectingFailure(String causeMessage, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.exceptionWhileCollectingFailure$str(), (Object)causeMessage);
    }

    protected String exceptionWhileCollectingFailure$str() {
        return "HSEARCH000522: Exception while collecting a failure -- this may indicate a bug or a missing test in Hibernate Search. Please report it: https://hibernate.org/community/ Nested exception: %1$s";
    }

    protected String cannotCallDslExtensionIfSupportedAfterOrElse$str() {
        return "HSEARCH000525: Invalid call of ifSupported(...) after orElse(...). Use a separate extension() context, or move the orElse(...) call last.";
    }

    @Override
    public final SearchException cannotCallDslExtensionIfSupportedAfterOrElse() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCallDslExtensionIfSupportedAfterOrElse$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String dslExtensionNoMatch$str() {
        return "HSEARCH000526: None of the provided extensions can be applied to the current context.  Attempted extensions: %1$s. If you want to ignore this, use .extension().ifSupported(...).orElse(ignored -> { }).";
    }

    @Override
    public final SearchException dslExtensionNoMatch(List<?> attemptedExtensions) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.dslExtensionNoMatch$str(), attemptedExtensions));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String securityManagerLoadingError$str() {
        return "HSEARCH000528: Security manager does not allow access to the constructor of type '%1$s': %2$s";
    }

    @Override
    public final SearchException securityManagerLoadingError(Class<?> classToLoad, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.securityManagerLoadingError$str(), new ClassFormatter(classToLoad), causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToLoadTheClass$str() {
        return "HSEARCH000530: Unable to load class '%1$s': %2$s";
    }

    @Override
    public final ClassLoadingException unableToLoadTheClass(String className, String causeMessage, Throwable cause) {
        ClassLoadingException result = new ClassLoadingException(String.format(this.getLoggingLocale(), this.unableToLoadTheClass$str(), className, causeMessage), cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String unknownNameForBackend$str() {
        return "HSEARCH000533: No backend with name '%1$s'. Check that at least one entity is configured to target that backend. The following backends can be retrieved by name: %2$s. %3$s";
    }

    @Override
    public final SearchException unknownNameForBackend(String backendName, Collection<String> validBackendNames, String defaultBackendMessage) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownNameForBackend$str(), backendName, validBackendNames, defaultBackendMessage));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String defaultBackendAvailable$str() {
        return "The default backend can be retrieved";
    }

    @Override
    public final String defaultBackendAvailable() {
        return String.format(this.getLoggingLocale(), this.defaultBackendAvailable$str(), new Object[0]);
    }

    protected String defaultBackendUnavailable$str() {
        return "The default backend cannot be retrieved, because no entity is mapped to that backend";
    }

    @Override
    public final String defaultBackendUnavailable() {
        return String.format(this.getLoggingLocale(), this.defaultBackendUnavailable$str(), new Object[0]);
    }

    protected String unknownNameForIndexManager$str() {
        return "HSEARCH000534: No index manager with name '%1$s'. Check that at least one entity is configured to target that index. The following indexes can be retrieved by name: %2$s.";
    }

    @Override
    public final SearchException unknownNameForIndexManager(String indexManagerName, Collection<String> validIndexNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownNameForIndexManager$str(), indexManagerName, validIndexNames));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToInstantiateClass$str() {
        return "HSEARCH000540: Unable to instantiate class '%1$s': %2$s";
    }

    @Override
    public final SearchException unableToInstantiateClass(String className, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToInstantiateClass$str(), className, causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String subtypeExpected$str() {
        return "HSEARCH000542: Invalid type '%1$s': this type cannot be assigned to type '%2$s'.";
    }

    @Override
    public final SearchException subtypeExpected(Class<?> classToLoad, Class<?> superType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.subtypeExpected$str(), new ClassFormatter(classToLoad), new ClassFormatter(superType)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String implementationRequired$str() {
        return "HSEARCH000543: Invalid type '%1$s': this type is an interface. An implementation class is required.";
    }

    @Override
    public final SearchException implementationRequired(Class<?> classToLoad) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.implementationRequired$str(), new ClassFormatter(classToLoad)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noPublicMapArgConstructor$str() {
        return "HSEARCH000544: Invalid type '%1$s': missing constructor. The type must expose a public constructor with a single parameter of type Map.";
    }

    @Override
    public final SearchException noPublicMapArgConstructor(Class<?> classToLoad) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noPublicMapArgConstructor$str(), new ClassFormatter(classToLoad)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexedEmbeddedCyclicRecursion$str() {
        return "HSEARCH000546: Cyclic recursion starting from '%1$s' on %2$s. Index field path starting from that location and ending with a cycle: '%3$s'. A type cannot declare an unrestricted @IndexedEmbedded to itself, even indirectly. To break the cycle, you should consider adding filters to your @IndexedEmbedded: includePaths, includeDepth, excludePaths, ...";
    }

    @Override
    public final SearchException indexedEmbeddedCyclicRecursion(MappingElement indexedEmbedded, EventContext indexedEmbeddedLocation, String cyclicRecursionPath) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexedEmbeddedCyclicRecursion$str(), indexedEmbedded, new EventContextNoPrefixFormatter(indexedEmbeddedLocation), cyclicRecursionPath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidBeanReferencePropertyValue$str() {
        return "HSEARCH000547: Invalid BeanReference value: expected an instance of '%1$s', BeanReference, String or Class. %2$s";
    }

    @Override
    public final SearchException invalidBeanReferencePropertyValue(Class<?> expectedType, String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidBeanReferencePropertyValue$str(), new ClassFormatter(expectedType), nestedErrorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String perFieldBoostWithConstantScore$str() {
        return "HSEARCH000551: Invalid use of per-field boost: the predicate score is constant. Cannot assign a different boost to each field when the predicate score is constant.";
    }

    @Override
    public final SearchException perFieldBoostWithConstantScore() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.perFieldBoostWithConstantScore$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPhrasePredicateSlop$str() {
        return "HSEARCH000553: Invalid slop: %1$d. The slop must be positive or zero.";
    }

    @Override
    public final SearchException invalidPhrasePredicateSlop(int slop) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidPhrasePredicateSlop$str(), slop));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidFuzzyMaximumEditDistance$str() {
        return "HSEARCH000554: Invalid maximum edit distance: %1$d. The value must be 0, 1 or 2.";
    }

    @Override
    public final SearchException invalidFuzzyMaximumEditDistance(int maximumEditDistance) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFuzzyMaximumEditDistance$str(), maximumEditDistance));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidExactPrefixLength$str() {
        return "HSEARCH000555: Invalid exact prefix length: %1$d. The value must be positive or zero.";
    }

    @Override
    public final SearchException invalidExactPrefixLength(int exactPrefixLength) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidExactPrefixLength$str(), exactPrefixLength));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToParseTemporal$str() {
        return "HSEARCH000557: Invalid value for type '%1$s': '%2$s'. The expected format is '%3$s'.";
    }

    @Override
    public final SearchException unableToParseTemporal(Class<? extends TemporalAccessor> type, String value, DateTimeFormatter formatter, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToParseTemporal$str(), new SimpleNameClassFormatter(type), value, formatter), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidNumberPropertyValue$str() {
        return "HSEARCH000558: Invalid %1$s value: expected either a Number or a String that can be parsed into a %1$s. %2$s";
    }

    @Override
    public final SearchException invalidNumberPropertyValue(Class<? extends Number> type, String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidNumberPropertyValue$str(), new SimpleNameClassFormatter(type), nestedErrorMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidStringForType$str() {
        return "HSEARCH000559: Invalid string for type '%2$s': '%1$s'. %3$s";
    }

    @Override
    public final SearchException invalidStringForType(String value, Class<?> type, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidStringForType$str(), value, new ClassFormatter(type), causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidStringForEnum$str() {
        return "HSEARCH000560: Invalid value for enum '%2$s': '%1$s'.";
    }

    @Override
    public final SearchException invalidStringForEnum(String value, Class<? extends Enum<?>> enumType, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidStringForEnum$str(), value, new ClassFormatter(enumType)), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonSingleHit$str() {
        return "HSEARCH000561: Multiple hits when a single hit was expected.";
    }

    @Override
    public final SearchException nonSingleHit() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonSingleHit$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String threadInterruptedWhileSubmittingWork$str() {
        return "HSEARCH000562: Unable to submit work to '%1$s': thread received interrupt signal. The work has been discarded.";
    }

    @Override
    public final SearchException threadInterruptedWhileSubmittingWork(String orchestratorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.threadInterruptedWhileSubmittingWork$str(), orchestratorName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String submittedWorkToStoppedOrchestrator$str() {
        return "HSEARCH000563: Unable to submit work to '%1$s': this orchestrator is stopped. The work has been discarded.";
    }

    @Override
    public final SearchException submittedWorkToStoppedOrchestrator(String orchestratorName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.submittedWorkToStoppedOrchestrator$str(), orchestratorName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToParseGeoPoint$str() {
        return "HSEARCH000564: Invalid geo-point value: '%1$s'. The expected format is '<latitude as double>, <longitude as double>'.";
    }

    @Override
    public final SearchException unableToParseGeoPoint(String value) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToParseGeoPoint$str(), value));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownAggregationKey$str() {
        return "HSEARCH000565: Unknown aggregation key '%1$s'. This key was not used when building the search query.";
    }

    @Override
    public final SearchException unknownAggregationKey(AggregationKey<?> key) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownAggregationKey$str(), key));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidConfigurationPropertyCheckingStrategyName$str() {
        return "HSEARCH000566: Invalid configuration property checking strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidConfigurationPropertyCheckingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidConfigurationPropertyCheckingStrategyName$str(), invalidRepresentation, validRepresentations));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void configurationPropertyTrackingDisabled() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.configurationPropertyTrackingDisabled$str(), new Object[0]);
    }

    protected String configurationPropertyTrackingDisabled$str() {
        return "HSEARCH000567: Configuration property tracking is disabled; unused properties will not be logged.";
    }

    @Override
    public final void configurationPropertyTrackingUnusedProperties(Set<String> propertyKeys, String disableWarningKey, String disableWarningValue) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.configurationPropertyTrackingUnusedProperties$str(), propertyKeys, (Object)disableWarningKey, (Object)disableWarningValue);
    }

    protected String configurationPropertyTrackingUnusedProperties$str() {
        return "HSEARCH000568: Invalid configuration passed to Hibernate Search: some properties in the given configuration are not used. There might be misspelled property keys in your configuration. Unused properties: %1$s. To disable this warning, set the property '%2$s' to '%3$s'.";
    }

    @Override
    public final void failureInFailureHandler(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failureInFailureHandler$str(), new Object[0]);
    }

    protected String failureInFailureHandler$str() {
        return "HSEARCH000569: The background failure handler threw an exception while handling a previous failure. The failure may not have been reported.";
    }

    protected String fieldTemplateNameCannotBeNullOrEmpty$str() {
        return "HSEARCH000570: Invalid index field template name '%1$s': field template names cannot be null or empty.";
    }

    @Override
    public final SearchException fieldTemplateNameCannotBeNullOrEmpty(String templateName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fieldTemplateNameCannotBeNullOrEmpty$str(), templateName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fieldTemplateNameCannotContainDot$str() {
        return "HSEARCH000571: Invalid index field template name '%1$s': field template names cannot contain a dot ('.').";
    }

    @Override
    public final SearchException fieldTemplateNameCannotContainDot(String relativeFieldName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.fieldTemplateNameCannotContainDot$str(), relativeFieldName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedMultiValuedField$str() {
        return "HSEARCH000572: Inconsistent index data: a supposedly single-valued field returned multiple values. Values: [%1$s, %2$s].";
    }

    @Override
    public final SearchException unexpectedMultiValuedField(Object value1, Object value2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedMultiValuedField$str(), value1, value2));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String obsoleteConfigurationPropertiesFromSearch5$str() {
        return "HSEARCH000573: Invalid configuration passed to Hibernate Search: some properties in the given configuration are obsolete.Configuration properties changed between Hibernate Search 5 and Hibernate Search 6 Check out the reference documentation and upgrade your configuration. Obsolete properties: %1$s.";
    }

    @Override
    public final SearchException obsoleteConfigurationPropertiesFromSearch5(Set<String> propertyKeys) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.obsoleteConfigurationPropertiesFromSearch5$str(), propertyKeys));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDefaultBackendRegistered$str() {
        return "HSEARCH000575: No default backend. Check that at least one entity is configured to target the default backend. The following backends can be retrieved by name: %1$s.";
    }

    @Override
    public final SearchException noDefaultBackendRegistered(Collection<String> validBackendNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noDefaultBackendRegistered$str(), validBackendNames));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleConfiguredBeanReferencesForType$str() {
        return "HSEARCH000576: Ambiguous bean reference to type '%1$s': multiple beans are explicitly defined for this type in Hibernate Search's internal registry. Explicitly defined beans: %2$s.";
    }

    @Override
    public final BeanNotFoundException multipleConfiguredBeanReferencesForType(Class<?> exposedType, List<? extends BeanReference<?>> references) {
        BeanNotFoundException result = new BeanNotFoundException(String.format(this.getLoggingLocale(), this.multipleConfiguredBeanReferencesForType$str(), new ClassFormatter(exposedType), references));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String noConfiguredBeanReferenceForType$str() {
        return "HSEARCH000577: No beans defined for type '%1$s' in Hibernate Search's internal registry.";
    }

    @Override
    public final BeanNotFoundException noConfiguredBeanReferenceForType(Class<?> exposedType) {
        BeanNotFoundException result = new BeanNotFoundException(String.format(this.getLoggingLocale(), this.noConfiguredBeanReferenceForType$str(), new ClassFormatter(exposedType)));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String noConfiguredBeanReferenceForTypeAndName$str() {
        return "HSEARCH000578: No beans defined for type '%1$s' and name '%2$s' in Hibernate Search's internal registry.";
    }

    @Override
    public final BeanNotFoundException noConfiguredBeanReferenceForTypeAndName(Class<?> exposedType, String nameReference) {
        BeanNotFoundException result = new BeanNotFoundException(String.format(this.getLoggingLocale(), this.noConfiguredBeanReferenceForTypeAndName$str(), new ClassFormatter(exposedType), nameReference));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String cannotResolveBeanReference3$str() {
        return "HSEARCH000579: Unable to resolve bean reference to type '%1$s' and name '%2$s'. %3$s";
    }

    @Override
    public final BeanNotFoundException cannotResolveBeanReference(Class<?> typeReference, String nameReference, String failureMessages, RuntimeException mainFailure, Collection<? extends RuntimeException> otherFailures) {
        BeanNotFoundException result = new BeanNotFoundException(String.format(this.getLoggingLocale(), this.cannotResolveBeanReference3$str(), new ClassFormatter(typeReference), nameReference, failureMessages), mainFailure);
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        otherFailures.forEach($otherFailuresVar -> result.addSuppressed((Throwable)$otherFailuresVar));
        return result;
    }

    protected String cannotResolveBeanReference2$str() {
        return "HSEARCH000580: Unable to resolve bean reference to type '%1$s'. %2$s";
    }

    @Override
    public final BeanNotFoundException cannotResolveBeanReference(Class<?> typeReference, String failureMessages, RuntimeException beanProviderFailure, Collection<? extends RuntimeException> otherFailures) {
        BeanNotFoundException result = new BeanNotFoundException(String.format(this.getLoggingLocale(), this.cannotResolveBeanReference2$str(), new ClassFormatter(typeReference), failureMessages), beanProviderFailure);
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        otherFailures.forEach($otherFailuresVar -> result.addSuppressed((Throwable)$otherFailuresVar));
        return result;
    }

    protected String failedToResolveBeanUsingInternalRegistry$str() {
        return "Failed to resolve bean from Hibernate Search's internal registry with exception: %1$s";
    }

    @Override
    public final String failedToResolveBeanUsingInternalRegistry(String exceptionMessage) {
        return String.format(this.getLoggingLocale(), this.failedToResolveBeanUsingInternalRegistry$str(), exceptionMessage);
    }

    protected String failedToResolveBeanUsingBeanManager$str() {
        return "Failed to resolve bean from bean manager with exception: %1$s";
    }

    @Override
    public final String failedToResolveBeanUsingBeanManager(String exceptionMessage) {
        return String.format(this.getLoggingLocale(), this.failedToResolveBeanUsingBeanManager$str(), exceptionMessage);
    }

    protected String failedToResolveBeanUsingReflection$str() {
        return "Failed to resolve bean using reflection with exception: %1$s";
    }

    @Override
    public final String failedToResolveBeanUsingReflection(String exceptionMessage) {
        return String.format(this.getLoggingLocale(), this.failedToResolveBeanUsingReflection$str(), exceptionMessage);
    }

    protected String noBackendFactoryRegistered$str() {
        return "HSEARCH000581: Unable to resolve backend type: configuration property '%1$s' is not set, and there isn't any backend in the classpath. Check that you added the desired backend to your project's dependencies.";
    }

    @Override
    public final SearchException noBackendFactoryRegistered(String propertyKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noBackendFactoryRegistered$str(), propertyKey));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleBackendFactoriesRegistered$str() {
        return "HSEARCH000582: Ambiguous backend type: configuration property '%1$s' is not set, and multiple backend types are present in the classpath. Set property '%1$s' to one of the following to select the backend type: %2$s";
    }

    @Override
    public final SearchException multipleBackendFactoriesRegistered(String propertyKey, Collection<String> backendTypeNames) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleBackendFactoriesRegistered$str(), propertyKey, backendTypeNames));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidDslArgumentType$str() {
        return "HSEARCH000583: Invalid type for DSL arguments: '%1$s'. Expected '%2$s' or a subtype.";
    }

    @Override
    public final SearchException invalidDslArgumentType(Class<?> type, Class<?> correctType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidDslArgumentType$str(), new ClassFormatter(type), new ClassFormatter(correctType)), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidReturnType$str() {
        return "HSEARCH000584: Invalid type for returned values: '%1$s'. Expected '%2$s' or a supertype.";
    }

    @Override
    public final SearchException invalidReturnType(Class<?> type, Class<?> correctType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidReturnType$str(), new ClassFormatter(type), new ClassFormatter(correctType)), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timedOut$str() {
        return "HSEARCH000586: Operation exceeded the timeout of %1$s.";
    }

    @Override
    public final SearchTimeoutException timedOut(Duration timeout, Exception cause) {
        SearchTimeoutException result = new SearchTimeoutException(String.format(this.getLoggingLocale(), this.timedOut$str(), new DurationInSecondsAndFractionsFormatter(timeout)), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String notExactTotalHitCount$str() {
        return "HSEARCH000587: Unable to provide the exact total hit count: only a lower-bound approximation is available. This is generally the result of setting query options such as a timeout or the total hit count threshold. Either unset these options, or retrieve the lower-bound hit count approximation through '.total().hitCountLowerBound()'.";
    }

    @Override
    public final SearchException notExactTotalHitCount() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.notExactTotalHitCount$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String twoTypesTargetSameIndex$str() {
        return "HSEARCH000588: Multiple entity types mapped to index '%1$s': '%2$s', '%3$s'. Each indexed type must be mapped to its own, dedicated index.";
    }

    @Override
    public final SearchException twoTypesTargetSameIndex(String indexName, String mappedTypeName, String anotherMappedTypeName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.twoTypesTargetSameIndex$str(), indexName, mappedTypeName, anotherMappedTypeName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCreateBeanUsingReflection$str() {
        return "HSEARCH000589: Unable to create bean using reflection: %1$s";
    }

    @Override
    public final BeanNotFoundException unableToCreateBeanUsingReflection(String causeMessage, Exception e) {
        BeanNotFoundException result = new BeanNotFoundException(String.format(this.getLoggingLocale(), this.unableToCreateBeanUsingReflection$str(), causeMessage), e);
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String noConfiguredBeanManager$str() {
        return "HSEARCH000590: No configured bean manager.";
    }

    @Override
    public final BeanNotFoundException noConfiguredBeanManager() {
        BeanNotFoundException result = new BeanNotFoundException(String.format(this.getLoggingLocale(), this.noConfiguredBeanManager$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String unableToResolveToClassName$str() {
        return "HSEARCH000591: Unable to resolve '%2$s' to a class extending '%1$s': %3$s";
    }

    @Override
    public final BeanNotFoundException unableToResolveToClassName(Class<?> typReference, String nameReference, String causeMessage, Exception e) {
        BeanNotFoundException result = new BeanNotFoundException(String.format(this.getLoggingLocale(), this.unableToResolveToClassName$str(), new ClassFormatter(typReference), nameReference, causeMessage), e);
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String invalidBeanRetrieval$str() {
        return "HSEARCH000592: Invalid bean reference: '%1$s'. The reference is prefixed with '%2$s', which is not a valid bean retrieval prefix. If you want to reference a bean by name, and the name contains a colon, use 'bean:%1$s'. Otherwise, use a valid bean retrieval prefix among the following: %3$s.";
    }

    @Override
    public final BeanNotFoundException invalidBeanRetrieval(String beanReference, String invalidPrefix, List<String> validPrefixes, Exception e) {
        BeanNotFoundException result = new BeanNotFoundException(String.format(this.getLoggingLocale(), this.invalidBeanRetrieval$str(), beanReference, invalidPrefix, validPrefixes), e);
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String relativeNamedPredicateNameCannotBeNullOrEmpty$str() {
        return "HSEARCH000593: Named predicate name '%1$s' is invalid: field names cannot be null or empty.";
    }

    @Override
    public final SearchException relativeNamedPredicateNameCannotBeNullOrEmpty(String relativeNamedPredicateName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.relativeNamedPredicateNameCannotBeNullOrEmpty$str(), relativeNamedPredicateName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String relativeNamedPredicateNameCannotContainDot$str() {
        return "HSEARCH000594: Named predicate name '%1$s' is invalid: field names cannot contain a dot ('.'). Remove the dot from your named predicate name.";
    }

    @Override
    public final SearchException relativeNamedPredicateNameCannotContainDot(String relativeNamedPredicateName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.relativeNamedPredicateNameCannotContainDot$str(), relativeNamedPredicateName), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String differentMultiTenancyNamedBackend$str() {
        return "HSEARCH000596: Different mappings trying to define two backends with the same name '%1$s' but having different expectations on multi-tenancy.";
    }

    @Override
    public final SearchException differentMultiTenancyNamedBackend(String backendName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentMultiTenancyNamedBackend$str(), backendName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String differentMultiTenancyDefaultBackend$str() {
        return "HSEARCH000597: Different mappings trying to define default backends having different expectations on multi-tenancy.";
    }

    @Override
    public final SearchException differentMultiTenancyDefaultBackend() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentMultiTenancyDefaultBackend$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexNodeTypeNotComposite$str() {
        return "HSEARCH000598: Invalid type: %1$s is not composite.";
    }

    @Override
    public final SearchException invalidIndexNodeTypeNotComposite(EventContext elementContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexNodeTypeNotComposite$str(), new EventContextNoPrefixFormatter(elementContext)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexNodeTypeNotObjectField$str() {
        return "HSEARCH000599: Invalid type: %1$s is not an object field.";
    }

    @Override
    public final SearchException invalidIndexNodeTypeNotObjectField(EventContext elementContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexNodeTypeNotObjectField$str(), new EventContextNoPrefixFormatter(elementContext)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidIndexNodeTypeNotValueField$str() {
        return "HSEARCH000600: Invalid type: %1$s is not a value field.";
    }

    @Override
    public final SearchException invalidIndexNodeTypeNotValueField(EventContext elementContext) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexNodeTypeNotValueField$str(), new EventContextNoPrefixFormatter(elementContext)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String inconsistentConfigurationInContextForSearch$str() {
        return "HSEARCH000601: Inconsistent configuration for %1$s in a search query across multiple indexes: %2$s";
    }

    @Override
    public final SearchException inconsistentConfigurationInContextForSearch(EventContext elementContext, String causeMessage, EventContext elementContextAsParam, SearchException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.inconsistentConfigurationInContextForSearch$str(), new EventContextNoPrefixFormatter(elementContext), causeMessage), (Throwable)cause, elementContextAsParam);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String inconsistentSupportForQueryElement$str() {
        return "HSEARCH000602: Inconsistent support for '%1$s': %2$s";
    }

    @Override
    public final SearchException inconsistentSupportForQueryElement(SearchQueryElementTypeKey<?> key, String causeMessage, SearchException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.inconsistentSupportForQueryElement$str(), key, causeMessage), (Throwable)cause);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String differentAttribute$str() {
        return "HSEARCH000603: Attribute '%1$s' differs: '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException differentAttribute(String attributeName, Object component1, Object component2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentAttribute$str(), attributeName, component1, component2));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotUseQueryElementForIndexNode$str() {
        return "HSEARCH000604: Cannot use '%2$s' on %1$s: %3$s";
    }

    @Override
    public final SearchException cannotUseQueryElementForIndexNode(EventContext elementContext, SearchQueryElementTypeKey<?> key, String hint, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseQueryElementForIndexNode$str(), new EventContextNoPrefixFormatter(elementContext), key, hint), (Throwable)cause, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingSupportHintForValueField$str() {
        return "Make sure the field is marked as searchable/sortable/projectable/aggregable/highlightable (whichever is relevant). If it already is, then '%1$s' is not available for fields of this type.";
    }

    @Override
    public final String missingSupportHintForValueField(SearchQueryElementTypeKey<?> key) {
        return String.format(this.getLoggingLocale(), this.missingSupportHintForValueField$str(), key);
    }

    protected String missingSupportHintForCompositeNode$str() {
        return "Some object field features require a nested structure; try setting the field structure to 'NESTED' and reindexing all your data. If you are trying to use another feature, it probably isn't available for this field.";
    }

    @Override
    public final String missingSupportHintForCompositeNode() {
        return String.format(this.getLoggingLocale(), this.missingSupportHintForCompositeNode$str(), new Object[0]);
    }

    protected String partialSupportForQueryElement$str() {
        return "HSEARCH000606: '%1$s' can be used in some of the targeted indexes, but not all of them. %2$s";
    }

    @Override
    public final SearchException partialSupportForQueryElement(SearchQueryElementTypeKey<?> key, String hint) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.partialSupportForQueryElement$str(), key, hint));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String partialSupportHintForValueField$str() {
        return "Make sure the field is marked as searchable/sortable/projectable/aggregable/highlightable (whichever is relevant) in all indexes, and that the field has the same type in all indexes.";
    }

    @Override
    public final String partialSupportHintForValueField() {
        return String.format(this.getLoggingLocale(), this.partialSupportHintForValueField$str(), new Object[0]);
    }

    protected String partialSupportHintForCompositeNode$str() {
        return "If you are trying to use the 'nested' predicate, set the field structure is to 'NESTED' in all indexes, then reindex all your data.";
    }

    @Override
    public final String partialSupportHintForCompositeNode() {
        return String.format(this.getLoggingLocale(), this.partialSupportHintForCompositeNode$str(), new Object[0]);
    }

    protected String conflictingFieldModel$str() {
        return "HSEARCH000609: This field is a value field in some indexes, but an object field in other indexes.";
    }

    @Override
    public final SearchException conflictingFieldModel() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldModel$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownFieldForSearch$str() {
        return "HSEARCH000610: Unknown field '%1$s'.";
    }

    @Override
    public final SearchException unknownFieldForSearch(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFieldForSearch$str(), absoluteFieldPath), context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String targetFieldsSpanningMultipleNestedPaths$str() {
        return "HSEARCH000611: Invalid target fields: fields [%1$s, %3$s] are in different nested documents (%2$s vs. %4$s). All target fields must be in the same document.";
    }

    @Override
    public final SearchException targetFieldsSpanningMultipleNestedPaths(String fieldPath1, EventContext nestedPath1, String fieldPath2, EventContext nestedPath2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.targetFieldsSpanningMultipleNestedPaths$str(), fieldPath1, new EventContextNoPrefixFormatter(nestedPath1), fieldPath2, new EventContextNoPrefixFormatter(nestedPath2)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCloseSavedValue$str() {
        return "HSEARCH000612: Unable to close saved value for key %1$s: %2$s";
    }

    @Override
    public final SearchException unableToCloseSavedValue(String keyName, String message, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToCloseSavedValue$str(), keyName, message), (Throwable)e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noIntegrationBecauseInitializationNotComplete$str() {
        return "HSEARCH000613: Unable to access the Search integration: initialization hasn't completed yet.";
    }

    @Override
    public final SearchException noIntegrationBecauseInitializationNotComplete() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noIntegrationBecauseInitializationNotComplete$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateEntityProjection$str() {
        return "HSEARCH000614: Cannot project on entity type '%1$s': this type cannot be loaded from an external datasource, and the documents from the index cannot be projected to its Java class '%2$s'. %3$s";
    }

    @Override
    public final SearchException cannotCreateEntityProjection(String name, Class<?> javaClass, String hint) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCreateEntityProjection$str(), name, new ClassFormatter(javaClass), hint));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToResolveField$str() {
        return "HSEARCH000615: Unable to resolve field '%1$s': %2$s";
    }

    @Override
    public final SearchException unableToResolveField(String absolutePath, String causeMessage, SearchException e, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToResolveField$str(), absolutePath, causeMessage), (Throwable)e, context);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void ignoringServiceConfigurationError(Class<?> serviceContract, ServiceConfigurationError error) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)error, this.ignoringServiceConfigurationError$str(), serviceContract);
    }

    protected String ignoringServiceConfigurationError$str() {
        return "HSEARCH000616: Ignoring ServiceConfigurationError caught while trying to instantiate service '%s'.";
    }

    protected String paramNotDefined$str() {
        return "HSEARCH000617: Parameter with name '%1$s' was not defined on projection definition '%2$s'.";
    }

    @Override
    public final SearchException paramNotDefined(String paramName, ProjectionDefinition<?> definition) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.paramNotDefined$str(), paramName, definition));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTypeForEntityProjection$str() {
        return "HSEARCH000618: Invalid type for entity projection on type '%1$s': the entity type's Java class '%2$s' does not extend the requested projection type '%3$s'.";
    }

    @Override
    public final SearchException invalidTypeForEntityProjection(String name, Class<?> entityType, Class<?> requestedEntityType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidTypeForEntityProjection$str(), name, new ClassFormatter(entityType), new ClassFormatter(requestedEntityType)));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotIncludeAndExcludePathsWithinSameFilter$str() {
        return "HSEARCH000619: 'includePaths' and 'excludePaths' cannot be used together in the same filter. Use either `includePaths` or `excludePaths` leaving the other one empty. Included paths are: '%1$s', excluded paths are: '%2$s'.";
    }

    @Override
    public final SearchException cannotIncludeAndExcludePathsWithinSameFilter(Set<String> includePaths, Set<String> excludePaths) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotIncludeAndExcludePathsWithinSameFilter$str(), includePaths, excludePaths));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void multipleConfigurationProvidersAvailable(String scope, List<ConfigurationProvider> configurationProviders) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.multipleConfigurationProvidersAvailable$str(), (Object)scope, configurationProviders);
    }

    protected String multipleConfigurationProvidersAvailable$str() {
        return "HSEARCH000620: Multiple configuration providers are available for scope '%1$s'. They will be taken under consideration in the following order: '%2$s'.";
    }

    protected String parameterizedRewriteMethodWithoutParameter$str() {
        return "HSEARCH000621: Cannot use rewrite method '%1$s': this method requires parameter 'n', which was not specified. Use another version of the rewrite(...) method that accepts parameter 'n'.";
    }

    @Override
    public final SearchException parameterizedRewriteMethodWithoutParameter(RewriteMethod rewriteMethod) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.parameterizedRewriteMethodWithoutParameter$str(), new Object[]{rewriteMethod}));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonParameterizedRewriteMethodWithParameter$str() {
        return "HSEARCH000622: Cannot use rewrite method '%1$s': this method does not accept parameter 'n', but it was specified. Use another version of the rewrite(...) method that does not accept parameter 'n'.";
    }

    @Override
    public final SearchException nonParameterizedRewriteMethodWithParameter(RewriteMethod rewriteMethod) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonParameterizedRewriteMethodWithParameter$str(), new Object[]{rewriteMethod}));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

