/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.mapping.impl;

import jakarta.persistence.AccessType;
import jakarta.persistence.EnumType;
import java.util.Locale;
import org.hibernate.annotations.UuidGenerator;
import org.hibernate.boot.jaxb.mapping.JaxbAttributes;
import org.hibernate.boot.jaxb.mapping.JaxbBasic;
import org.hibernate.boot.jaxb.mapping.JaxbColumn;
import org.hibernate.boot.jaxb.mapping.JaxbEntity;
import org.hibernate.boot.jaxb.mapping.JaxbEntityMappings;
import org.hibernate.boot.jaxb.mapping.JaxbId;
import org.hibernate.boot.jaxb.mapping.JaxbIndex;
import org.hibernate.boot.jaxb.mapping.JaxbTable;
import org.hibernate.boot.jaxb.mapping.JaxbTenantId;
import org.hibernate.boot.jaxb.mapping.JaxbUuidGenerator;

public class AdditionalMappingBuilder {
    private final JaxbEntity entity = new JaxbEntity();

    public AdditionalMappingBuilder(Class<?> type, String name) {
        this.entity.setAccess(AccessType.FIELD);
        this.entity.setClazz(type.getName());
        this.entity.setName(name);
        JaxbTable table = new JaxbTable();
        this.entity.setTable(table);
        this.entity.setAttributes(new JaxbAttributes());
    }

    public AdditionalMappingBuilder table(String schema, String catalog, String table) {
        this.entity.getTable().setSchema(schema);
        this.entity.getTable().setCatalog(catalog);
        this.entity.getTable().setName(table);
        return this;
    }

    public AdditionalMappingBuilder index(String name) {
        return this.index(name, name);
    }

    public AdditionalMappingBuilder index(String name, String columns) {
        JaxbIndex index = new JaxbIndex();
        index.setName(name);
        index.setColumnList(columns);
        this.entity.getTable().getIndex().add(index);
        return this;
    }

    public AdditionalMappingBuilder attribute(String name, Integer length, Boolean nullable) {
        return this.attribute(name, length, nullable, null);
    }

    public AdditionalMappingBuilder attribute(String name, Integer length, Boolean nullable, Integer type) {
        this.entity.getAttributes().getBasicAttributes().add(this.createAttribute(name, length, nullable, type));
        return this;
    }

    public AdditionalMappingBuilder tenantId(String name) {
        this.entity.setTenantId(new JaxbTenantId());
        this.entity.getTenantId().setName(name);
        return this;
    }

    public AdditionalMappingBuilder enumAttribute(String name, Integer length, Boolean nullable) {
        JaxbBasic attribute = this.createAttribute(name, length, nullable);
        attribute.setEnumerated(EnumType.STRING);
        this.entity.getAttributes().getBasicAttributes().add(attribute);
        return this;
    }

    public AdditionalMappingBuilder id(Integer type, String strategy) {
        JaxbId id = new JaxbId();
        id.setName("id");
        if (type != null) {
            id.setJdbcTypeCode(type);
        }
        id.setUuidGenerator(new JaxbUuidGenerator());
        id.getUuidGenerator().setStyle(UuidGenerator.Style.valueOf((String)strategy.toUpperCase(Locale.ROOT)));
        this.entity.getAttributes().getId().add(id);
        return this;
    }

    public JaxbEntityMappings build() {
        JaxbEntityMappings mappings = new JaxbEntityMappings();
        mappings.getEntities().add(this.entity);
        return mappings;
    }

    private JaxbBasic createAttribute(String name, Integer size, boolean nullable) {
        return this.createAttribute(name, size, nullable, null);
    }

    private JaxbBasic createAttribute(String name, Integer size, boolean nullable, Integer type) {
        JaxbBasic attribute = new JaxbBasic();
        attribute.setName(name);
        JaxbColumn column = new JaxbColumn();
        attribute.setColumn(column);
        column.setName(name);
        column.setNullable(Boolean.valueOf(nullable));
        column.setLength(size);
        if (type != null) {
            attribute.setJdbcTypeCode(type);
        }
        return attribute;
    }
}

