/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchCompositeSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchIndexOrderSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchScoreSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchUserProvidedJsonSort;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.spi.CompositeSortBuilder;
import org.hibernate.search.engine.search.sort.spi.ScoreSortBuilder;
import org.hibernate.search.engine.search.sort.spi.SearchSortBuilderFactory;

public class ElasticsearchSearchSortBuilderFactory
implements SearchSortBuilderFactory {
    private final ElasticsearchSearchIndexScope<?> scope;

    public ElasticsearchSearchSortBuilderFactory(ElasticsearchSearchIndexScope<?> scope) {
        this.scope = scope;
    }

    public ScoreSortBuilder score() {
        return new ElasticsearchScoreSort.Builder(this.scope);
    }

    public SearchSort indexOrder() {
        return new ElasticsearchIndexOrderSort(this.scope);
    }

    public CompositeSortBuilder composite() {
        return new ElasticsearchCompositeSort.Builder(this.scope);
    }

    public ElasticsearchSearchSort fromJson(JsonObject jsonObject) {
        return new ElasticsearchUserProvidedJsonSort(this.scope, jsonObject);
    }

    public ElasticsearchSearchSort fromJson(String jsonString) {
        return this.fromJson((JsonObject)this.scope.userFacingGson().fromJson(jsonString, JsonObject.class));
    }
}

