/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalFileImpl
implements JournalFile {
    private final SequentialFile file;
    private final long fileID;
    private final int recordID;
    private long offset;
    boolean reclaimable = true;
    private static final AtomicIntegerFieldUpdater<JournalFileImpl> replaceableCountUpdater = AtomicIntegerFieldUpdater.newUpdater(JournalFileImpl.class, "replaceableCountField");
    private static final AtomicIntegerFieldUpdater<JournalFileImpl> posCountUpdater = AtomicIntegerFieldUpdater.newUpdater(JournalFileImpl.class, "posCountField");
    private static final AtomicIntegerFieldUpdater<JournalFileImpl> addRecordUpdate = AtomicIntegerFieldUpdater.newUpdater(JournalFileImpl.class, "addRecordField");
    private static final AtomicIntegerFieldUpdater<JournalFileImpl> liveBytesUpdater = AtomicIntegerFieldUpdater.newUpdater(JournalFileImpl.class, "liveBytesField");
    private volatile int replaceableCountField = 0;
    private volatile int posCountField = 0;
    private volatile int addRecordField = 0;
    private volatile int liveBytesField = 0;
    private boolean posReclaimCriteria = false;
    private boolean negReclaimCriteria = false;
    private final AtomicInteger totalNegativeToOthers = new AtomicInteger(0);
    private final int version;
    private final ConcurrentMap<JournalFile, AtomicInteger> negCounts = new ConcurrentHashMap<JournalFile, AtomicInteger>();
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void setReclaimable(boolean reclaimable) {
        this.reclaimable = reclaimable;
    }

    public JournalFileImpl(SequentialFile file, long fileID, int version) {
        Preconditions.checkNotNull((Object)file);
        this.file = file;
        this.fileID = fileID;
        this.version = version;
        this.recordID = (int)(fileID & Integer.MAX_VALUE);
    }

    @Override
    public int getPosCount() {
        return posCountUpdater.get(this);
    }

    @Override
    public int getReplaceableCount() {
        return replaceableCountUpdater.get(this);
    }

    @Override
    public void incReplaceableCount() {
        replaceableCountUpdater.incrementAndGet(this);
    }

    @Override
    public boolean isPosReclaimCriteria() {
        return this.posReclaimCriteria;
    }

    @Override
    public void setPosReclaimCriteria() {
        this.posReclaimCriteria = true;
    }

    @Override
    public boolean isNegReclaimCriteria() {
        return this.negReclaimCriteria;
    }

    @Override
    public void setNegReclaimCriteria() {
        this.negReclaimCriteria = true;
    }

    @Override
    public boolean isCanReclaim() {
        return this.reclaimable && this.posReclaimCriteria && this.negReclaimCriteria;
    }

    @Override
    public void incNegCount(JournalFile file) {
        this.incNegCount(file, 1);
    }

    @Override
    public void incNegCount(JournalFile file, int delta) {
        AtomicInteger previous;
        if (delta <= 0) {
            throw new IllegalArgumentException("delta must be > 0");
        }
        if (file != this) {
            this.totalNegativeToOthers.addAndGet(delta);
        }
        if ((previous = (AtomicInteger)this.negCounts.get(file)) != null) {
            previous.addAndGet(delta);
            return;
        }
        previous = this.negCounts.putIfAbsent(file, new AtomicInteger(delta));
        if (previous != null) {
            previous.addAndGet(delta);
        }
    }

    @Override
    public int getNegCount(JournalFile file) {
        AtomicInteger count = (AtomicInteger)this.negCounts.get(file);
        if (count == null) {
            return 0;
        }
        return count.intValue();
    }

    @Override
    public int getJournalVersion() {
        return this.version;
    }

    @Override
    public void incPosCount() {
        posCountUpdater.incrementAndGet(this);
    }

    @Override
    public void incAddRecord() {
        addRecordUpdate.incrementAndGet(this);
    }

    @Override
    public int getAddRecord() {
        return addRecordUpdate.get(this);
    }

    @Override
    public void decPosCount() {
        posCountUpdater.decrementAndGet(this);
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getFileID() {
        return this.fileID;
    }

    @Override
    public int getRecordID() {
        return this.recordID;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public SequentialFile getFile() {
        return this.file;
    }

    public String toString() {
        try {
            return "JournalFileImpl: (" + this.file.getFileName() + " id = " + this.fileID + ", recordID = " + this.recordID + ")";
        }
        catch (Exception e) {
            logger.warn("Error during method invocation", (Object)e.getMessage(), (Object)e);
            return "Error:" + e.toString();
        }
    }

    public String debug() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : this.negCounts.entrySet()) {
            builder.append(" file = " + entry.getKey() + " negcount value = " + entry.getValue() + "\n");
        }
        return builder.toString();
    }

    @Override
    public void addSize(int bytes) {
        liveBytesUpdater.addAndGet(this, bytes);
    }

    @Override
    public void decSize(int bytes) {
        liveBytesUpdater.addAndGet(this, -bytes);
    }

    @Override
    public int getLiveSize() {
        return liveBytesUpdater.get(this);
    }

    @Override
    public int getTotalNegativeToOthers() {
        return this.totalNegativeToOthers.get();
    }

    @Override
    public void fileRemoved(JournalFile fileRemoved) {
        this.negCounts.remove(fileRemoved);
    }
}

