/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.subsystem;

import jakarta.persistence.spi.PersistenceProviderResolver;
import jakarta.persistence.spi.PersistenceProviderResolverHolder;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.jpa.config.ExtendedPersistenceInheritance;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderResolverImpl;
import org.jboss.as.jpa.platform.PlatformImpl;
import org.jboss.as.jpa.processor.HibernateSearchProcessor;
import org.jboss.as.jpa.processor.JPAAnnotationProcessor;
import org.jboss.as.jpa.processor.JPAClassFileTransformerProcessor;
import org.jboss.as.jpa.processor.JPADependencyProcessor;
import org.jboss.as.jpa.processor.JPAInterceptorProcessor;
import org.jboss.as.jpa.processor.JPAJarJBossAllParser;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.processor.PersistenceBeginInstallProcessor;
import org.jboss.as.jpa.processor.PersistenceCompleteInstallProcessor;
import org.jboss.as.jpa.processor.PersistenceRefProcessor;
import org.jboss.as.jpa.processor.PersistenceUnitParseProcessor;
import org.jboss.as.jpa.service.JPAService;
import org.jboss.as.jpa.service.JPAUserTransactionListenerService;
import org.jboss.as.jpa.subsystem.JPADefinition;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.jipijapa.cache.spi.Classification;

class JPASubSystemAdd
extends AbstractBoottimeAddStepHandler {
    public static final JPASubSystemAdd INSTANCE = new JPASubSystemAdd();

    private JPASubSystemAdd() {
        super(new AttributeDefinition[]{JPADefinition.DEFAULT_DATASOURCE, JPADefinition.DEFAULT_EXTENDEDPERSISTENCE_INHERITANCE});
    }

    protected void performBoottime(final OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                PersistenceProviderResolverHolder.setPersistenceProviderResolver((PersistenceProviderResolver)PersistenceProviderResolverImpl.getInstance());
                boolean appclient = context.getProcessType() == ProcessType.APPLICATION_CLIENT;
                PlatformImpl platform = appclient ? new PlatformImpl(Classification.NONE, new Classification[0]) : new PlatformImpl(Classification.INFINISPAN, Classification.INFINISPAN);
                processorTarget.addDeploymentProcessor("jpa", Phase.STRUCTURE, 2579, (DeploymentUnitProcessor)new JBossAllXmlParserRegisteringProcessor(JPAJarJBossAllParser.ROOT_ELEMENT, JpaAttachments.DEPLOYMENT_SETTINGS_KEY, (JBossAllXMLParser)new JPAJarJBossAllParser()));
                processorTarget.addDeploymentProcessor("jpa", Phase.PARSE, 12032, (DeploymentUnitProcessor)new PersistenceUnitParseProcessor());
                processorTarget.addDeploymentProcessor("jpa", Phase.DEPENDENCIES, 3840, (DeploymentUnitProcessor)new JPAAnnotationProcessor());
                processorTarget.addDeploymentProcessor("jpa", Phase.DEPENDENCIES, 4096, (DeploymentUnitProcessor)new JPADependencyProcessor());
                processorTarget.addDeploymentProcessor("jpa", Phase.DEPENDENCIES, 4097, (DeploymentUnitProcessor)new HibernateSearchProcessor());
                processorTarget.addDeploymentProcessor("jpa", Phase.FIRST_MODULE_USE, 256, (DeploymentUnitProcessor)new JPAClassFileTransformerProcessor());
                CapabilityServiceSupport capabilities = context.getCapabilityServiceSupport();
                if (capabilities.hasCapability("org.wildfly.ejb3")) {
                    processorTarget.addDeploymentProcessor("jpa", Phase.FIRST_MODULE_USE, 512, (DeploymentUnitProcessor)new JPAInterceptorProcessor());
                }
                processorTarget.addDeploymentProcessor("jpa", Phase.FIRST_MODULE_USE, 768, (DeploymentUnitProcessor)new PersistenceBeginInstallProcessor(platform));
                processorTarget.addDeploymentProcessor("jpa", Phase.POST_MODULE, 5632, (DeploymentUnitProcessor)new PersistenceRefProcessor());
                processorTarget.addDeploymentProcessor("jpa", Phase.INSTALL, 4640, (DeploymentUnitProcessor)new PersistenceCompleteInstallProcessor(platform));
            }
        }, OperationContext.Stage.RUNTIME);
        String dataSourceName = JPADefinition.DEFAULT_DATASOURCE.resolveModelAttribute(context, model).asStringOrNull();
        ExtendedPersistenceInheritance defaultExtendedPersistenceInheritance = ExtendedPersistenceInheritance.valueOf(JPADefinition.DEFAULT_EXTENDEDPERSISTENCE_INHERITANCE.resolveModelAttribute(context, model).asString());
        ServiceTarget target = context.getServiceTarget();
        JPAService.addService(target, dataSourceName, defaultExtendedPersistenceInheritance);
        JPAUserTransactionListenerService.addService(target);
    }
}

