/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ManagementSecurityIdentitySupplier;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.auth.server.SecurityDomain;

public class AccessIdentityResourceDefinition
extends SimpleResourceDefinition {
    private static final String SECURITY_DOMAIN_CAPABILITY = "org.wildfly.security.security-domain";
    private static final String MANAGEMENT_IDENTITY_CAPABILITY = "org.wildfly.management.identity";
    private static final RuntimeCapability<Void> MANAGEMENT_IDENTITY_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.management.identity", Void.class).build();
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"access", (String)"identity");
    public static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, false).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.management.identity")).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.ELYTRON_SECURITY_DOMAIN_REF})).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{SECURITY_DOMAIN};

    private AccessIdentityResourceDefinition(AbstractAddStepHandler add) {
        super(new SimpleResourceDefinition.Parameters(PATH_ELEMENT, DomainManagementResolver.getResolver("core.identity")).setAddHandler((OperationStepHandler)add).setRemoveHandler((OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE).setAddRestartLevel(OperationEntry.Flag.RESTART_NONE).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{MANAGEMENT_IDENTITY_RUNTIME_CAPABILITY}).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.ACCESS_CONTROL}));
    }

    public static ResourceDefinition newInstance(ManagementSecurityIdentitySupplier securityIdentitySupplier) {
        return new AccessIdentityResourceDefinition(new AccessIdentityAddHandler(securityIdentitySupplier));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        WriteAttributeHandler write = new WriteAttributeHandler();
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)write);
        }
    }

    static class WriteAttributeHandler
    extends ReloadRequiredWriteAttributeHandler {
        WriteAttributeHandler() {
        }

        protected boolean requiresRuntime(OperationContext context) {
            return !context.isBooting();
        }
    }

    private static final class IdentityService
    implements Service {
        private final Supplier<SecurityDomain> securityDomainSupplier;
        private final ManagementSecurityIdentitySupplier securityIdentitySupplier;

        private IdentityService(Supplier<SecurityDomain> securityDomainSupplier, ManagementSecurityIdentitySupplier securityIdentitySupplier) {
            this.securityDomainSupplier = securityDomainSupplier;
            this.securityIdentitySupplier = securityIdentitySupplier;
        }

        public void start(StartContext context) {
            this.securityIdentitySupplier.setConfiguredSecurityDomainSupplier(this.securityDomainSupplier::get);
        }

        public void stop(StopContext context) {
            this.securityIdentitySupplier.setConfiguredSecurityDomainSupplier(null);
        }
    }

    static class AccessIdentityAddHandler
    extends AbstractAddStepHandler {
        private final ManagementSecurityIdentitySupplier securityIdentitySupplier;

        AccessIdentityAddHandler(ManagementSecurityIdentitySupplier securityIdentitySupplier) {
            this.securityIdentitySupplier = securityIdentitySupplier;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String securityDomain = SECURITY_DOMAIN.resolveModelAttribute(context, model).asString();
            ServiceBuilder sb = context.getServiceTarget().addService(MANAGEMENT_IDENTITY_RUNTIME_CAPABILITY.getCapabilityServiceName());
            Supplier sdSupplier = sb.requires(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)AccessIdentityResourceDefinition.SECURITY_DOMAIN_CAPABILITY, (String)securityDomain), SecurityDomain.class));
            sb.setInstance((Service)new IdentityService(sdSupplier, this.securityIdentitySupplier));
            sb.install();
            context.addStep((context1, operation1) -> {
                try {
                    ServiceController controller = context1.getServiceRegistry(false).getRequiredService(MANAGEMENT_IDENTITY_RUNTIME_CAPABILITY.getCapabilityServiceName());
                    if (controller == null || ServiceController.State.UP != controller.getState()) {
                        context.setRollbackOnly();
                    }
                }
                catch (ServiceNotFoundException ex) {
                    context.setRollbackOnly();
                }
            }, OperationContext.Stage.VERIFY);
        }

        protected boolean requiresRuntime(OperationContext context) {
            return (context.getProcessType() != ProcessType.EMBEDDED_SERVER || context.getRunningMode() != RunningMode.ADMIN_ONLY) && context.getProcessType() != ProcessType.EMBEDDED_HOST_CONTROLLER;
        }
    }
}

