/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import org.hibernate.Hibernate;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PropertyBasedMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptorSide;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.OneToManyTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnknownTableReferenceException;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaType;

public class SimpleForeignKeyDescriptor
implements ForeignKeyDescriptor,
BasicValuedModelPart,
FetchOptions {
    private final SimpleForeignKeyDescriptorSide keySide;
    private final SimpleForeignKeyDescriptorSide targetSide;
    private final boolean refersToPrimaryKey;
    private final boolean hasConstraint;
    private AssociationKey associationKey;

    public SimpleForeignKeyDescriptor(ManagedMappingType keyDeclaringType, BasicValuedModelPart keyModelPart, PropertyAccess keyPropertyAccess, SelectableMapping keySelectableMapping, BasicValuedModelPart targetModelPart, boolean insertable, boolean updateable, boolean refersToPrimaryKey, boolean hasConstraint) {
        this(BasicAttributeMapping.withSelectableMapping(keyDeclaringType, keyModelPart, keyPropertyAccess, insertable, updateable, keySelectableMapping), targetModelPart, refersToPrimaryKey, hasConstraint, false);
    }

    public SimpleForeignKeyDescriptor(BasicValuedModelPart keyModelPart, BasicValuedModelPart targetModelPart, boolean refersToPrimaryKey, boolean hasConstraint, boolean swapDirection) {
        assert (targetModelPart != null);
        if (swapDirection) {
            this.keySide = new SimpleForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.KEY, targetModelPart);
            this.targetSide = new SimpleForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.TARGET, keyModelPart);
        } else {
            this.keySide = new SimpleForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.KEY, keyModelPart);
            this.targetSide = new SimpleForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.TARGET, targetModelPart);
        }
        this.refersToPrimaryKey = refersToPrimaryKey;
        this.hasConstraint = hasConstraint;
    }

    public SimpleForeignKeyDescriptor(ManagedMappingType keyDeclaringType, SelectableMapping keySelectableMapping, BasicValuedModelPart targetModelPart, boolean refersToPrimaryKey, boolean hasConstraint) {
        this(keyDeclaringType, keySelectableMapping, ((PropertyBasedMapping)((Object)targetModelPart)).getPropertyAccess(), targetModelPart, refersToPrimaryKey, hasConstraint, false);
    }

    public SimpleForeignKeyDescriptor(ManagedMappingType keyDeclaringType, SelectableMapping keySelectableMapping, PropertyAccess valueAccess, BasicValuedModelPart targetModelPart, boolean refersToPrimaryKey, boolean hasConstraint, boolean swapDirection) {
        this(BasicAttributeMapping.withSelectableMapping(keyDeclaringType, targetModelPart, valueAccess, keySelectableMapping.isInsertable(), keySelectableMapping.isUpdateable(), keySelectableMapping), targetModelPart, refersToPrimaryKey, hasConstraint, swapDirection);
    }

    protected SimpleForeignKeyDescriptor(SimpleForeignKeyDescriptor original) {
        this.keySide = original.keySide;
        this.targetSide = original.targetSide;
        this.refersToPrimaryKey = original.refersToPrimaryKey;
        this.hasConstraint = original.hasConstraint;
        this.associationKey = original.associationKey;
    }

    @Override
    public String getKeyTable() {
        return this.keySide.getModelPart().getContainingTableExpression();
    }

    @Override
    public String getTargetTable() {
        return this.targetSide.getModelPart().getContainingTableExpression();
    }

    @Override
    public BasicValuedModelPart getKeyPart() {
        return this.keySide.getModelPart();
    }

    @Override
    public BasicValuedModelPart getTargetPart() {
        return this.targetSide.getModelPart();
    }

    @Override
    public boolean isKeyPart(ValuedModelPart modelPart) {
        return this == modelPart || this.keySide.getModelPart() == modelPart;
    }

    @Override
    public ForeignKeyDescriptor.Side getKeySide() {
        return this.keySide;
    }

    @Override
    public ForeignKeyDescriptor.Side getTargetSide() {
        return this.targetSide;
    }

    @Override
    public int compare(Object key1, Object key2) {
        return this.keySide.getModelPart().getJavaType().getComparator().compare(key1, key2);
    }

    @Override
    public ForeignKeyDescriptor withKeySelectionMapping(ManagedMappingType declaringType, TableGroupProducer declaringTableGroupProducer, IntFunction<SelectableMapping> selectableMappingAccess, MappingModelCreationProcess creationProcess) {
        SelectableMapping selectableMapping = selectableMappingAccess.apply(0);
        return new SimpleForeignKeyDescriptor(declaringType, this.keySide.getModelPart(), ((PropertyBasedMapping)((Object)this.keySide.getModelPart())).getPropertyAccess(), selectableMapping, this.targetSide.getModelPart(), selectableMapping.isInsertable(), selectableMapping.isUpdateable(), this.refersToPrimaryKey, this.hasConstraint);
    }

    @Override
    public ForeignKeyDescriptor withTargetPart(ValuedModelPart targetPart) {
        return new SimpleForeignKeyDescriptor(this.keySide.getModelPart(), targetPart.asBasicValuedModelPart(), this.refersToPrimaryKey, this.hasConstraint, false);
    }

    @Override
    public DomainResult<?> createKeyDomainResult(NavigablePath navigablePath, TableGroup targetTableGroup, FetchParent fetchParent, DomainResultCreationState creationState) {
        assert (this.isTargetTableGroup(targetTableGroup));
        return this.createDomainResult(navigablePath.append("{fk}"), targetTableGroup, this.keySide.getModelPart(), fetchParent, creationState);
    }

    @Override
    public DomainResult<?> createKeyDomainResult(NavigablePath navigablePath, TableGroup targetTableGroup, ForeignKeyDescriptor.Nature fromSide, FetchParent fetchParent, DomainResultCreationState creationState) {
        assert (fromSide != ForeignKeyDescriptor.Nature.TARGET ? this.isTargetTableGroup(targetTableGroup) : targetTableGroup.getTableReference(navigablePath, this.associationKey.getTable(), false) != null);
        return this.createDomainResult(navigablePath.append("{fk}"), targetTableGroup, this.keySide.getModelPart(), fetchParent, creationState);
    }

    @Override
    public DomainResult<?> createTargetDomainResult(NavigablePath navigablePath, TableGroup targetTableGroup, FetchParent fetchParent, DomainResultCreationState creationState) {
        assert (this.isTargetTableGroup(targetTableGroup));
        return this.createDomainResult(navigablePath.append("{fk-target}"), targetTableGroup, this.targetSide.getModelPart(), fetchParent, creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup targetTableGroup, String resultVariable, DomainResultCreationState creationState) {
        assert (this.isTargetTableGroup(targetTableGroup));
        return this.createDomainResult(navigablePath.append("{fk}"), targetTableGroup, this.keySide.getModelPart(), null, creationState);
    }

    private boolean isTargetTableGroup(TableGroup tableGroup) {
        TableGroupProducer tableGroupProducer = (tableGroup = SimpleForeignKeyDescriptor.getUnderlyingTableGroup(tableGroup)) instanceof OneToManyTableGroup ? (TableGroupProducer)((OneToManyTableGroup)tableGroup).getElementTableGroup().getModelPart() : (TableGroupProducer)tableGroup.getModelPart();
        return tableGroupProducer.containsTableReference(this.targetSide.getModelPart().getContainingTableExpression());
    }

    private static TableGroup getUnderlyingTableGroup(TableGroup tableGroup) {
        if (tableGroup.isVirtual()) {
            tableGroup = SimpleForeignKeyDescriptor.getUnderlyingTableGroup(((VirtualTableGroup)tableGroup).getUnderlyingTableGroup());
        }
        return tableGroup;
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        throw new UnsupportedOperationException();
    }

    private <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, BasicValuedModelPart selectableMapping, FetchParent fetchParent, DomainResultCreationState creationState) {
        TableReference tableReference;
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        try {
            tableReference = tableGroup.resolveTableReference(navigablePath, selectableMapping, selectableMapping.getContainingTableExpression());
        }
        catch (IllegalStateException tableNotFoundException) {
            throw new UnknownTableReferenceException(selectableMapping.getContainingTableExpression(), String.format(Locale.ROOT, "Unable to determine TableReference (`%s`) for `%s`", selectableMapping.getContainingTableExpression(), this.getNavigableRole().getFullPath()));
        }
        JavaType<?> javaType = selectableMapping.getJdbcMapping().getJdbcJavaType();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(tableReference, selectableMapping), javaType, fetchParent, sqlAstCreationState.getCreationContext().getSessionFactory().getTypeConfiguration());
        JdbcMappingContainer selectionType = sqlSelection.getExpressionType();
        return new BasicResult(sqlSelection.getValuesArrayPosition(), null, selectableMapping.getJdbcMapping(), navigablePath, selectionType != null && selectionType.getSingleJdbcMapping().getJdbcJavaType() != javaType, !sqlSelection.isVirtual());
    }

    @Override
    public Predicate generateJoinPredicate(TableReference targetSideReference, TableReference keySideReference, SqlAstCreationState creationState) {
        return new ComparisonPredicate(new ColumnReference(targetSideReference, (SelectableMapping)this.targetSide.getModelPart()), ComparisonOperator.EQUAL, new ColumnReference(keySideReference, (SelectableMapping)this.keySide.getModelPart()));
    }

    @Override
    public Predicate generateJoinPredicate(TableGroup targetSideTableGroup, TableGroup keySideTableGroup, SqlAstCreationState creationState) {
        TableReference lhsTableReference = targetSideTableGroup.resolveTableReference(targetSideTableGroup.getNavigablePath(), this.targetSide.getModelPart().getContainingTableExpression());
        TableReference rhsTableKeyReference = keySideTableGroup.resolveTableReference(null, this.keySide.getModelPart().getContainingTableExpression());
        return this.generateJoinPredicate(lhsTableReference, rhsTableKeyReference, creationState);
    }

    @Override
    public boolean isSimpleJoinPredicate(Predicate predicate) {
        if (!(predicate instanceof ComparisonPredicate)) {
            return false;
        }
        ComparisonPredicate comparisonPredicate = (ComparisonPredicate)predicate;
        if (comparisonPredicate.getOperator() != ComparisonOperator.EQUAL) {
            return false;
        }
        Expression lhsExpr = comparisonPredicate.getLeftHandExpression();
        Expression rhsExpr = comparisonPredicate.getRightHandExpression();
        if (!(lhsExpr instanceof ColumnReference) || !(rhsExpr instanceof ColumnReference)) {
            return false;
        }
        String lhs = ((ColumnReference)lhsExpr).getColumnExpression();
        String rhs = ((ColumnReference)rhsExpr).getColumnExpression();
        String keyExpression = this.keySide.getModelPart().getSelectionExpression();
        String targetExpression = this.targetSide.getModelPart().getSelectionExpression();
        return lhs.equals(keyExpression) && rhs.equals(targetExpression) || lhs.equals(targetExpression) && rhs.equals(keyExpression);
    }

    @Override
    public MappingType getPartMappingType() {
        return this.targetSide.getModelPart().getMappedType();
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this);
        return 1;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.targetSide.getModelPart().getJdbcMapping().getJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.targetSide.getModelPart().getNavigableRole();
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.targetSide.getModelPart().findContainingEntityMapping();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.getJdbcMapping().convertToRelationalValue(value);
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        CacheHelper.addBasicValueToCacheKey(cacheKey, value, this.getJdbcMapping(), session);
    }

    @Override
    public Object getAssociationKeyFromSide(Object targetObject, ForeignKeyDescriptor.Side side, SharedSessionContractImplementor session) {
        PersistentAttributeInterceptor interceptor;
        ValuedModelPart modelPart;
        if (targetObject == null) {
            return null;
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(targetObject);
        if (lazyInitializer != null) {
            if (this.refersToPrimaryKey) {
                return lazyInitializer.getIdentifier();
            }
            targetObject = lazyInitializer.getImplementation();
        }
        if ((modelPart = side.getModelPart()).isEntityIdentifierMapping()) {
            return ((EntityIdentifierMapping)modelPart).getIdentifierIfNotUnsaved(targetObject, session);
        }
        if (lazyInitializer == null && ManagedTypeHelper.isPersistentAttributeInterceptable(targetObject) && (interceptor = ManagedTypeHelper.asPersistentAttributeInterceptable(targetObject).$$_hibernate_getInterceptor()) instanceof EnhancementAsProxyLazinessInterceptor && !((EnhancementAsProxyLazinessInterceptor)interceptor).isInitialized()) {
            Hibernate.initialize(targetObject);
        }
        return ((PropertyBasedMapping)((Object)modelPart)).getPropertyAccess().getGetter().get(targetObject);
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, value, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(offset, x, y, this.disassemble(domainValue, session), this.keySide.getModelPart());
        return this.getJdbcTypeCount();
    }

    @Override
    public int visitKeySelectables(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this.keySide.getModelPart());
        return this.getJdbcTypeCount();
    }

    @Override
    public int visitTargetSelectables(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this.targetSide.getModelPart());
        return this.getJdbcTypeCount();
    }

    @Override
    public boolean hasConstraint() {
        return this.hasConstraint;
    }

    @Override
    public AssociationKey getAssociationKey() {
        if (this.associationKey == null) {
            List<String> associationKeyColumns = Collections.singletonList(this.keySide.getModelPart().getSelectionExpression());
            this.associationKey = new AssociationKey(this.keySide.getModelPart().getContainingTableExpression(), associationKeyColumns);
        }
        return this.associationKey;
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.targetSide.getModelPart().getJdbcMapping();
    }

    @Override
    public JdbcMapping getSingleJdbcMapping() {
        return this.targetSide.getModelPart().getJdbcMapping();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.targetSide.getModelPart().getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, this.disassemble(value, session), this.targetSide.getModelPart().getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public String getContainingTableExpression() {
        return this.keySide.getModelPart().getContainingTableExpression();
    }

    @Override
    public String getSelectionExpression() {
        return this.keySide.getModelPart().getSelectionExpression();
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        return this.keySide.getModelPart();
    }

    @Override
    public boolean isFormula() {
        return this.keySide.getModelPart().isFormula();
    }

    @Override
    public boolean isNullable() {
        return this.keySide.getModelPart().isNullable();
    }

    @Override
    public boolean isInsertable() {
        return this.keySide.getModelPart().isInsertable();
    }

    @Override
    public boolean isUpdateable() {
        return this.keySide.getModelPart().isUpdateable();
    }

    @Override
    public boolean isPartitioned() {
        return this.keySide.getModelPart().isPartitioned();
    }

    @Override
    public String getCustomReadExpression() {
        return this.keySide.getModelPart().getCustomReadExpression();
    }

    @Override
    public String getCustomWriteExpression() {
        return this.keySide.getModelPart().getCustomWriteExpression();
    }

    @Override
    public String getColumnDefinition() {
        return this.keySide.getModelPart().getColumnDefinition();
    }

    @Override
    public Long getLength() {
        return this.keySide.getModelPart().getLength();
    }

    @Override
    public Integer getPrecision() {
        return this.keySide.getModelPart().getPrecision();
    }

    @Override
    public Integer getScale() {
        return this.keySide.getModelPart().getScale();
    }

    @Override
    public Integer getTemporalPrecision() {
        return this.keySide.getModelPart().getTemporalPrecision();
    }

    @Override
    public String getFetchableName() {
        return "{fk}";
    }

    @Override
    public int getFetchableKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        return null;
    }

    @Override
    public MappingType getMappedType() {
        return null;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.keySide.getModelPart().getJdbcMapping();
    }

    public String toString() {
        return String.format("SimpleForeignKeyDescriptor : %s.%s -> %s.%s", this.keySide.getModelPart().getContainingTableExpression(), this.keySide.getModelPart().getSelectionExpression(), this.targetSide.getModelPart().getContainingTableExpression(), this.targetSide.getModelPart().getSelectionExpression());
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }
}

