/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.dynamic;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.dynamic.DynamicFetchBuilder;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderContainer;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderStandard;

public abstract class AbstractFetchBuilderContainer<T extends AbstractFetchBuilderContainer<T>>
implements DynamicFetchBuilderContainer {
    private Map<String, FetchBuilder> fetchBuilderMap;

    protected AbstractFetchBuilderContainer() {
    }

    protected AbstractFetchBuilderContainer(AbstractFetchBuilderContainer<T> original) {
        if (original.fetchBuilderMap != null) {
            HashMap<String, FetchBuilder> fetchBuilderMap = new HashMap<String, FetchBuilder>(original.fetchBuilderMap.size());
            for (Map.Entry<String, FetchBuilder> entry : original.fetchBuilderMap.entrySet()) {
                FetchBuilder fetchBuilder = entry.getValue() instanceof DynamicFetchBuilderStandard ? ((DynamicFetchBuilderStandard)entry.getValue()).cacheKeyInstance(this) : entry.getValue().cacheKeyInstance();
                fetchBuilderMap.put(entry.getKey(), fetchBuilder);
            }
            this.fetchBuilderMap = fetchBuilderMap;
        }
    }

    protected abstract String getPropertyBase();

    @Override
    public FetchBuilder findFetchBuilder(String fetchableName) {
        return this.fetchBuilderMap == null ? null : this.fetchBuilderMap.get(fetchableName);
    }

    public T addProperty(String propertyName, String columnAlias) {
        DynamicFetchBuilder fetchBuilder = this.addProperty(propertyName);
        fetchBuilder.addColumnAlias(columnAlias);
        return (T)this;
    }

    public T addProperty(String propertyName, String ... columnAliases) {
        DynamicFetchBuilder fetchBuilder = this.addProperty(propertyName);
        ArrayHelper.forEach(columnAliases, fetchBuilder::addColumnAlias);
        return (T)this;
    }

    @Override
    public DynamicFetchBuilder addProperty(String propertyName) {
        if (this.fetchBuilderMap == null) {
            this.fetchBuilderMap = new HashMap<String, FetchBuilder>();
        } else {
            FetchBuilder existing = this.fetchBuilderMap.get(propertyName);
            if (existing != null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Fetch was already defined for %s.%s : %s", this.getPropertyBase(), propertyName, existing));
            }
        }
        DynamicFetchBuilderStandard fetchBuilder = new DynamicFetchBuilderStandard(propertyName);
        this.fetchBuilderMap.put(propertyName, fetchBuilder);
        return fetchBuilder;
    }

    @Override
    public void addFetchBuilder(String propertyName, FetchBuilder fetchBuilder) {
        if (this.fetchBuilderMap == null) {
            this.fetchBuilderMap = new HashMap<String, FetchBuilder>();
        }
        this.fetchBuilderMap.put(propertyName, fetchBuilder);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFetchBuilderContainer that = (AbstractFetchBuilderContainer)o;
        return Objects.equals(this.fetchBuilderMap, that.fetchBuilderMap);
    }

    public int hashCode() {
        return this.fetchBuilderMap != null ? this.fetchBuilderMap.hashCode() : 0;
    }
}

