/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.util.Collection;
import java.util.function.Function;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.SerializabilityChecker;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.ejb.bean.BeanDeploymentMarshallingContext;
import org.wildfly.clustering.ejb.client.EJBProxyObjectTable;
import org.wildfly.clustering.ejb.client.EJBProxyResolver;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.IdentitySerializabilityChecker;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationBuilder;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;

public enum BeanMarshallerFactory implements Function<BeanDeploymentMarshallingContext, ByteBufferMarshaller>
{
    JBOSS{

        @Override
        public ByteBufferMarshaller apply(BeanDeploymentMarshallingContext context) {
            MarshallingConfigurationRepository repository = MarshallingConfigurationRepository.from((Enum)MarshallingVersion.CURRENT, (Object)context);
            return new JBossByteBufferMarshaller(repository, (ClassLoader)context.getModule().getClassLoader());
        }
    };


    static enum MarshallingVersion implements Function<BeanDeploymentMarshallingContext, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(BeanDeploymentMarshallingContext context) {
                Module module = context.getModule();
                MarshallingConfiguration config = (MarshallingConfiguration)((MarshallingConfigurationBuilder)MarshallingConfigurationBuilder.newInstance((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader())).load((ClassLoader)module.getClassLoader())).build();
                config.setSerializabilityChecker((SerializabilityChecker)new IdentitySerializabilityChecker((Collection)context.getBeanClasses()));
                config.setObjectTable((ObjectTable)new EJBProxyObjectTable());
                return config;
            }
        }
        ,
        VERSION_2{

            @Override
            public MarshallingConfiguration apply(BeanDeploymentMarshallingContext context) {
                Module module = context.getModule();
                MarshallingConfiguration config = (MarshallingConfiguration)((MarshallingConfigurationBuilder)MarshallingConfigurationBuilder.newInstance((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader())).load((ClassLoader)module.getClassLoader())).build();
                config.setSerializabilityChecker((SerializabilityChecker)new IdentitySerializabilityChecker((Collection)context.getBeanClasses()));
                config.setObjectResolver((ObjectResolver)new EJBProxyResolver());
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_2;
        }
    }
}

