/*
 * Decompiled with CFR 0.152.
 */
package org.jipijapa.hibernate.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.hibernate.search.engine.cfg.spi.ConvertUtils;
import org.jboss.jandex.Index;
import org.jipijapa.hibernate.search.JpaHibernateSearchLogger;
import org.jipijapa.hibernate.search.WildFlyHibernateOrmSearchMappingConfigurer;
import org.jipijapa.plugin.spi.PersistenceProviderIntegratorAdaptor;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class HibernateSearchIntegratorAdaptor
implements PersistenceProviderIntegratorAdaptor {
    private static final Pattern MULTI_VALUE_SEPARATOR_PATTERN = Pattern.compile(",");
    private Collection<Index> indexes;
    private final List<WildFlyHibernateOrmSearchMappingConfigurer> configurers = new ArrayList<WildFlyHibernateOrmSearchMappingConfigurer>();

    public void injectIndexes(Collection<Index> indexes) {
        this.indexes = indexes;
    }

    public void addIntegratorProperties(Map<String, Object> properties, PersistenceUnitMetadata pu) {
        this.addMappingConfigurer(properties, pu);
    }

    private void addMappingConfigurer(Map<String, Object> properties, PersistenceUnitMetadata pu) {
        Properties puProperties = pu.getProperties();
        ArrayList<WildFlyHibernateOrmSearchMappingConfigurer> mappingConfigurerRefs = new ArrayList<WildFlyHibernateOrmSearchMappingConfigurer>();
        Object customMappingConfigurerRefs = puProperties.get("hibernate.search.mapping.configurer");
        if (customMappingConfigurerRefs != null) {
            try {
                mappingConfigurerRefs.addAll(ConvertUtils.convertMultiValue((Pattern)MULTI_VALUE_SEPARATOR_PATTERN, Function.identity(), (Object)customMappingConfigurerRefs));
            }
            catch (RuntimeException e) {
                throw JpaHibernateSearchLogger.JPA_HIBERNATE_SEARCH_LOGGER.failOnPropertyParsingForIntegration(pu.getPersistenceUnitName(), "hibernate.search.mapping.configurer", e);
            }
        }
        WildFlyHibernateOrmSearchMappingConfigurer configurer = new WildFlyHibernateOrmSearchMappingConfigurer(this.indexes);
        this.configurers.add(configurer);
        mappingConfigurerRefs.add(0, configurer);
        properties.put("hibernate.search.mapping.configurer", mappingConfigurerRefs);
    }

    public void afterCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        this.indexes = null;
        for (WildFlyHibernateOrmSearchMappingConfigurer configurer : this.configurers) {
            configurer.clearIndexReferences();
        }
        this.configurers.clear();
    }
}

