/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.JndiHandler;
import com.sun.faces.application.annotation.RuntimeAnnotationHandler;
import jakarta.faces.context.FacesContext;
import jakarta.persistence.PersistenceContext;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class PersistenceContextHandler
extends JndiHandler
implements RuntimeAnnotationHandler {
    private final Method[] methods;
    private final PersistenceContext[] methodAnnotations;
    private final Field[] fields;
    private final PersistenceContext[] fieldAnnotations;

    public PersistenceContextHandler(Method[] methods, PersistenceContext[] methodAnnotations, Field[] fields, PersistenceContext[] fieldAnnotations) {
        this.methods = methods;
        this.methodAnnotations = methodAnnotations;
        this.fields = fields;
        this.fieldAnnotations = fieldAnnotations;
    }

    @Override
    public void apply(FacesContext ctx, Object ... params) {
        int i;
        Object object = params[0];
        for (i = 0; i < this.fields.length; ++i) {
            this.applyToField(ctx, this.fields[i], this.fieldAnnotations[i], object);
        }
        for (i = 0; i < this.methods.length; ++i) {
            this.applyToMethod(ctx, this.methods[i], this.methodAnnotations[i], object);
        }
    }

    private void applyToMethod(FacesContext facesContext, Method method, PersistenceContext unit, Object instance) {
        if (method.getName().startsWith("set")) {
            Object value = null;
            if (unit.name() != null && !"".equals(unit.name().trim())) {
                value = this.lookup(facesContext, "java:comp/env/" + unit.name());
            }
            this.invokeMethod(facesContext, method, instance, value);
        }
    }

    private void applyToField(FacesContext facesContext, Field field, PersistenceContext unit, Object instance) {
        Object value = unit.name() != null && !"".equals(unit.name().trim()) ? this.lookup(facesContext, "java:comp/env/" + unit.name()) : this.lookup(facesContext, field.getType().getSimpleName());
        this.setField(facesContext, field, instance, value);
    }
}

