/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.event;

import jakarta.faces.FacesException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PhaseId
implements Comparable {
    private final int ordinal = nextOrdinal++;
    private final String phaseName;
    private static int nextOrdinal = 0;
    private static final String ANY_PHASE_NAME = "ANY";
    public static final PhaseId ANY_PHASE = new PhaseId("ANY");
    private static final String RESTORE_VIEW_NAME = "RESTORE_VIEW";
    public static final PhaseId RESTORE_VIEW = new PhaseId("RESTORE_VIEW");
    private static final String APPLY_REQUEST_VALUES_NAME = "APPLY_REQUEST_VALUES";
    public static final PhaseId APPLY_REQUEST_VALUES = new PhaseId("APPLY_REQUEST_VALUES");
    private static final String PROCESS_VALIDATIONS_NAME = "PROCESS_VALIDATIONS";
    public static final PhaseId PROCESS_VALIDATIONS = new PhaseId("PROCESS_VALIDATIONS");
    private static final String UPDATE_MODEL_VALUES_NAME = "UPDATE_MODEL_VALUES";
    public static final PhaseId UPDATE_MODEL_VALUES = new PhaseId("UPDATE_MODEL_VALUES");
    private static final String INVOKE_APPLICATION_NAME = "INVOKE_APPLICATION";
    public static final PhaseId INVOKE_APPLICATION = new PhaseId("INVOKE_APPLICATION");
    private static final String RENDER_RESPONSE_NAME = "RENDER_RESPONSE";
    public static final PhaseId RENDER_RESPONSE = new PhaseId("RENDER_RESPONSE");
    private static final PhaseId[] values = new PhaseId[]{ANY_PHASE, RESTORE_VIEW, APPLY_REQUEST_VALUES, PROCESS_VALIDATIONS, UPDATE_MODEL_VALUES, INVOKE_APPLICATION, RENDER_RESPONSE};
    public static final List<PhaseId> VALUES = List.of(values);
    private static final Map<String, PhaseId> VALUES_BY_NAME = Collections.unmodifiableMap(Stream.of(values).collect(Collectors.toMap(phase -> phase.getName().toUpperCase(), Function.identity())));

    private PhaseId(String newPhaseName) {
        this.phaseName = newPhaseName;
    }

    public int compareTo(Object phaseId) {
        return this.ordinal - ((PhaseId)phaseId).ordinal;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.phaseName + " " + this.ordinal;
    }

    public String getName() {
        return this.phaseName;
    }

    public static PhaseId phaseIdValueOf(String phase) {
        Objects.requireNonNull(phase);
        PhaseId result = VALUES_BY_NAME.get(phase.toUpperCase());
        if (result == null) {
            throw new FacesException("Not a valid phase [" + phase + "]");
        }
        return result;
    }
}

