/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneDocumentContent;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;

public abstract class AbstractLuceneNumericFieldCodec<F, E extends Number>
implements LuceneFieldCodec<F, E> {
    private final Indexing indexing;
    private final DocValues docValues;
    private final Storage storage;
    private final F indexNullAsValue;

    public AbstractLuceneNumericFieldCodec(Indexing indexing, DocValues docValues, Storage storage, F indexNullAsValue) {
        this.indexing = indexing;
        this.docValues = docValues;
        this.storage = storage;
        this.indexNullAsValue = indexNullAsValue;
    }

    @Override
    public final void addToDocument(LuceneDocumentContent documentBuilder, String absoluteFieldPath, F value) {
        if (value == null && this.indexNullAsValue != null) {
            value = this.indexNullAsValue;
        }
        if (value == null) {
            return;
        }
        Number encodedValue = (Number)this.encode(value);
        LuceneNumericDomain<Number> domain = this.getDomain();
        if (Indexing.ENABLED == this.indexing) {
            documentBuilder.addField(domain.createIndexField(absoluteFieldPath, encodedValue));
        }
        if (DocValues.ENABLED == this.docValues) {
            documentBuilder.addField(domain.createSortedDocValuesField(absoluteFieldPath, encodedValue));
        } else {
            documentBuilder.addFieldName(absoluteFieldPath);
        }
        if (Storage.ENABLED == this.storage) {
            this.addStoredToDocument(documentBuilder, absoluteFieldPath, value, encodedValue);
        }
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?, ?> obj) {
        if (this == obj) {
            return true;
        }
        return this.getClass() == obj.getClass();
    }

    public abstract LuceneNumericDomain<E> getDomain();

    abstract void addStoredToDocument(LuceneDocumentContent var1, String var2, F var3, E var4);
}

