/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.backend.lucene.work.impl.AbstractSingleDocumentIndexingWork;
import org.hibernate.search.backend.lucene.work.impl.IndexingWorkExecutionContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class DeleteEntryWork
extends AbstractSingleDocumentIndexingWork {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Query filter;

    DeleteEntryWork(String tenantId, String entityTypeName, Object entityIdentifier, String documentIdentifier, Query filter) {
        super("deleteEntry", tenantId, entityTypeName, entityIdentifier, documentIdentifier);
        this.filter = filter;
    }

    @Override
    public Long execute(IndexingWorkExecutionContext context) {
        try {
            IndexWriterDelegator indexWriterDelegator = context.getIndexWriterDelegator();
            Term idTerm = new Term(MetadataFields.idFieldName(), this.documentIdentifier);
            if (this.filter == null) {
                return indexWriterDelegator.deleteDocuments(idTerm);
            }
            return indexWriterDelegator.deleteDocuments(Queries.boolFilter((Query)new TermQuery(idTerm), this.filter));
        }
        catch (IOException e) {
            throw log.unableToDeleteEntryFromIndex(this.tenantId, this.entityTypeName, this.entityIdentifier, e.getMessage(), context.getEventContext(), e);
        }
    }
}

