/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.security;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.evidence.Evidence;

public class ServerVerificationService
implements Service {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "server", "verification"});
    public static final ServiceName REGISTRATION_NAME = SERVICE_NAME.append(new String[]{"registration"});
    private final Consumer<Predicate<Evidence>> evidencePredicate;
    private Consumer<Consumer<Predicate<Evidence>>> predicateInjectionPoint;
    private volatile Predicate<Evidence> currentPredicate;

    private ServerVerificationService(Consumer<Predicate<Evidence>> evidencePredicate, Consumer<Consumer<Predicate<Evidence>>> predicateInjectionPoint) {
        this.evidencePredicate = evidencePredicate;
        this.predicateInjectionPoint = predicateInjectionPoint;
    }

    public void start(StartContext context) throws StartException {
        this.predicateInjectionPoint.accept(this::register);
        this.evidencePredicate.accept(this::verify);
    }

    private boolean verify(Evidence evidence) {
        Predicate<Evidence> currentPredicate = this.currentPredicate;
        return currentPredicate != null ? currentPredicate.test(evidence) : false;
    }

    private void register(Predicate<Evidence> evidencePredicate) {
        this.currentPredicate = evidencePredicate;
    }

    public void stop(StopContext context) {
        this.currentPredicate = null;
    }

    public static void install(ServiceTarget target) {
        ServiceBuilder sb = target.addService(SERVICE_NAME);
        Consumer evidencePredicate = sb.provides(new ServiceName[]{SERVICE_NAME});
        Consumer predicateInjectionPoint = sb.provides(new ServiceName[]{REGISTRATION_NAME});
        sb.setInstance((Service)new ServerVerificationService(evidencePredicate, predicateInjectionPoint)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }
}

