/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.function.Functions;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheEntryComputer;
import org.wildfly.clustering.ejb.cache.timer.DefaultImmutableTimerMetaData;
import org.wildfly.clustering.ejb.cache.timer.DefaultTimerMetaData;
import org.wildfly.clustering.ejb.cache.timer.ImmutableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.MutableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.RemappableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimerIndex;
import org.wildfly.clustering.ejb.cache.timer.TimerIndexKey;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataConfiguration;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataEntryFunction;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataFactory;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataKey;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerIndexKey;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerMetaDataConfiguration;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerMetaDataKey;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.TimerMetaData;
import org.wildfly.clustering.server.offset.OffsetValue;

public class InfinispanTimerMetaDataFactory<I, C>
implements TimerMetaDataFactory<I, RemappableTimerMetaDataEntry<C>> {
    private final Cache<TimerIndexKey, I> indexCache;
    private final Cache<TimerMetaDataKey<I>, RemappableTimerMetaDataEntry<C>> readCache;
    private final Cache<TimerMetaDataKey<I>, RemappableTimerMetaDataEntry<C>> writeCache;
    private final Cache<TimerMetaDataKey<I>, RemappableTimerMetaDataEntry<C>> removeCache;
    private final TimerMetaDataConfiguration<C> config;

    public InfinispanTimerMetaDataFactory(InfinispanTimerMetaDataConfiguration<C> config) {
        this.config = config;
        this.indexCache = config.getCache().getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK);
        this.readCache = config.getReadForUpdateCache();
        this.writeCache = config.getSilentWriteCache();
        this.removeCache = config.getCache();
    }

    public CompletionStage<RemappableTimerMetaDataEntry<C>> createValueAsync(I id, Map.Entry<RemappableTimerMetaDataEntry<C>, TimerIndex> entry) {
        RemappableTimerMetaDataEntry<C> metaData = entry.getKey();
        TimerIndex index = entry.getValue();
        CompletableFuture existingIndex = index != null ? this.indexCache.putIfAbsentAsync((Object)new InfinispanTimerIndexKey(index), id) : CompletableFuture.completedStage(null);
        return existingIndex.thenCompose(indexId -> indexId == null ? this.writeCache.putAsync(new InfinispanTimerMetaDataKey<Object>(id), (Object)metaData).thenApply(Functions.constantFunction((Object)metaData)) : CompletableFuture.completedStage(null));
    }

    public CompletionStage<RemappableTimerMetaDataEntry<C>> findValueAsync(I id) {
        return this.readCache.getAsync(new InfinispanTimerMetaDataKey<I>(id));
    }

    public CompletionStage<Void> removeAsync(I id) {
        return this.removeCache.removeAsync(new InfinispanTimerMetaDataKey<I>(id)).thenAccept(org.wildfly.common.function.Functions.discardingConsumer());
    }

    public TimerMetaData createTimerMetaData(I id, RemappableTimerMetaDataEntry<C> entry) {
        Duration lastTimeout = entry.getLastTimeout();
        OffsetValue lastTimeoutOffset = OffsetValue.from((Duration)Optional.ofNullable(lastTimeout).orElse(Duration.ZERO));
        EmbeddedCacheEntryComputer mutator = new EmbeddedCacheEntryComputer(this.writeCache, new InfinispanTimerMetaDataKey<I>(id), (BiFunction)new TimerMetaDataEntryFunction(lastTimeoutOffset));
        return new DefaultTimerMetaData(this.config, (TimerMetaDataEntry)(lastTimeout != null ? new MutableTimerMetaDataEntry((ImmutableTimerMetaDataEntry)entry, lastTimeoutOffset) : entry), (CacheEntryMutator)mutator);
    }

    public ImmutableTimerMetaData createImmutableTimerMetaData(RemappableTimerMetaDataEntry<C> entry) {
        return new DefaultImmutableTimerMetaData(this.config, entry);
    }
}

