/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.rest.integration.api;

import org.jboss.jbossts.star.util.TxStatus;

public enum HeuristicType {
    HEURISTIC_ROLLBACK,
    HEURISTIC_COMMIT,
    HEURISTIC_HAZARD,
    HEURISTIC_MIXED;


    public static HeuristicType fromTxStatus(String status) {
        if (status.equals(TxStatus.TransactionHeuristicCommit.name())) {
            return HEURISTIC_COMMIT;
        }
        if (status.equals(TxStatus.TransactionHeuristicHazard.name())) {
            return HEURISTIC_HAZARD;
        }
        if (status.equals(TxStatus.TransactionHeuristicMixed.name())) {
            return HEURISTIC_MIXED;
        }
        if (status.equals(TxStatus.TransactionHeuristicRollback.name())) {
            return HEURISTIC_ROLLBACK;
        }
        throw new IllegalArgumentException("TxStatus is not heuristic.");
    }

    public String toTxStatus() {
        switch (this.ordinal()) {
            case 1: {
                return TxStatus.TransactionHeuristicCommit.name();
            }
            case 2: {
                return TxStatus.TransactionHeuristicHazard.name();
            }
            case 3: {
                return TxStatus.TransactionHeuristicMixed.name();
            }
            case 0: {
                return TxStatus.TransactionHeuristicRollback.name();
            }
        }
        return null;
    }
}

