/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.security.SecurityMetaData;
import org.jboss.as.server.security.VirtualDomainMarkerUtility;
import org.jboss.as.server.security.VirtualDomainUtil;
import org.jboss.msc.service.ServiceName;

public class VirtualSecurityDomainNameProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        SecurityMetaData securityMetaData = (SecurityMetaData)deploymentUnit.getAttachment(SecurityMetaData.ATTACHMENT_KEY);
        if (securityMetaData != null && VirtualDomainMarkerUtility.isVirtualDomainRequired((DeploymentUnit)deploymentUnit)) {
            ServiceName virtualDomainName = VirtualDomainMarkerUtility.virtualDomainName((DeploymentUnit)deploymentUnit);
            securityMetaData.setSecurityDomain(virtualDomainName);
            VirtualDomainUtil.setTopLevelDeploymentSecurityMetaData((DeploymentUnit)deploymentUnit, (ServiceName)virtualDomainName);
        }
    }
}

