/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueMaxConsumerLimitReached;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.ServerConsumerImpl;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.ConversionException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPResourceLimitExceededException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolLogger;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.DefaultSenderController;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonDeliveryHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.activemq.artemis.protocol.amqp.proton.SenderController;
import org.apache.activemq.artemis.protocol.amqp.proton.transaction.ProtonTransactionImpl;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtonServerSenderContext
extends ProtonInitializable
implements ProtonDeliveryHandler {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final byte[] EMPTY_DELIVERY_TAG = new byte[0];
    private final ConnectionFlushIOCallback connectionFlusher = new ConnectionFlushIOCallback();
    protected final AMQPSessionContext protonSession;
    protected final Sender sender;
    protected final AMQPConnectionContext connection;
    protected final AMQPSessionCallback sessionSPI;
    private final Object creditsLock = new Object();
    private final boolean amqpTreatRejectAsUnmodifiedDeliveryFailed;
    private final AtomicBoolean draining = new AtomicBoolean(false);
    private SenderController controller;
    private ServerConsumer brokerConsumer;
    private ReadyListener onflowControlReady;
    private boolean closed = false;
    private boolean preSettle;
    private int credits = 0;
    private AtomicInteger pending = new AtomicInteger(0);
    private Consumer<? super MessageReference> beforeDelivery;
    protected volatile Runnable afterDelivery;
    protected volatile MessageWriter messageWriter = SenderController.REJECTING_MESSAGE_WRITER;

    public ProtonServerSenderContext(AMQPConnectionContext connection, Sender sender, AMQPSessionContext protonSession, AMQPSessionCallback server) {
        this(connection, sender, protonSession, server, null);
    }

    public ProtonServerSenderContext(AMQPConnectionContext connection, Sender sender, AMQPSessionContext protonSession, AMQPSessionCallback server, SenderController senderController) {
        this.controller = senderController;
        this.connection = connection;
        this.sender = sender;
        this.protonSession = protonSession;
        this.sessionSPI = server;
        this.amqpTreatRejectAsUnmodifiedDeliveryFailed = this.connection.getProtocolManager().isAmqpTreatRejectAsUnmodifiedDeliveryFailed();
    }

    public ProtonServerSenderContext setBeforeDelivery(Consumer<? super MessageReference> beforeDelivery) {
        this.beforeDelivery = beforeDelivery;
        return this;
    }

    public ServerConsumer getBrokerConsumer() {
        return this.brokerConsumer;
    }

    protected String getClientId() {
        return this.connection.getRemoteContainer();
    }

    public AMQPSessionContext getSessionContext() {
        return this.protonSession;
    }

    public Sender getSender() {
        return this.sender;
    }

    @Override
    public void onFlow(int currentCredits, boolean drain) {
        if (logger.isDebugEnabled()) {
            logger.debug("flow {}, draing={}", (Object)currentCredits, (Object)drain);
        }
        this.connection.requireInHandler();
        this.setupCredit();
        ServerConsumerImpl serverConsumer = (ServerConsumerImpl)this.brokerConsumer;
        if (drain) {
            if (this.draining.compareAndSet(false, true)) {
                this.flushDrain(serverConsumer);
            }
        } else {
            serverConsumer.receiveCredits(-1);
        }
    }

    private void flushDrain(ServerConsumerImpl serverConsumer) {
        serverConsumer.forceDelivery(1L, () -> {
            try {
                this.connection.runNow(() -> {
                    if (this.messageWriter.isWriting()) {
                        this.afterDelivery = () -> this.flushDrain(serverConsumer);
                    } else {
                        this.drained();
                    }
                });
            }
            finally {
                this.draining.set(false);
            }
        });
    }

    private void drained() {
        this.connection.requireInHandler();
        this.sender.drained();
        this.connection.instantFlush();
        this.setupCredit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCredits() {
        if (this.messageWriter.isWriting() || !this.connection.flowControl(this.onflowControlReady)) {
            return false;
        }
        Object object = this.creditsLock;
        synchronized (object) {
            return this.credits > 0 && this.sender.getLocalState() != EndpointState.CLOSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupCredit() {
        Object object = this.creditsLock;
        synchronized (object) {
            this.credits = this.sender.getCredit() - this.pending.get();
            if (this.credits < 0) {
                this.credits = 0;
            }
        }
    }

    public void start() throws ActiveMQAMQPException {
        this.sessionSPI.start();
        try {
            if (this.brokerConsumer != null) {
                this.sessionSPI.startSender(this.brokerConsumer);
            }
        }
        catch (Exception e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorStartingConsumer(e.getMessage());
        }
    }

    @Override
    public void initialize() throws Exception {
        this.initialized = true;
        if (this.controller == null) {
            this.controller = new DefaultSenderController(this.protonSession, this.sender, this.getClientId());
        }
        try {
            this.brokerConsumer = (ServerConsumer)this.controller.init(this);
            this.preSettle = this.sender.getSenderSettleMode() == SenderSettleMode.SETTLED;
            this.onflowControlReady = () -> ((ServerConsumer)this.brokerConsumer).promptDelivery();
        }
        catch (ActiveMQAMQPResourceLimitExceededException e1) {
            throw e1;
        }
        catch (ActiveMQSecurityException e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingConsumer(e.getMessage());
        }
        catch (ActiveMQQueueMaxConsumerLimitReached e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingConsumer(e.getMessage());
        }
        catch (ActiveMQException e) {
            throw e;
        }
        catch (Exception e) {
            ActiveMQAMQPInternalErrorException internalErrorException = ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingConsumer(e.getMessage());
            internalErrorException.initCause(e);
            throw internalErrorException;
        }
    }

    @Override
    public void close(ErrorCondition condition) throws ActiveMQAMQPException {
        if (!this.closed) {
            this.closed = true;
            if (condition != null) {
                this.sender.setCondition(condition);
            }
            this.protonSession.removeSender(this.sender);
            this.connection.runNow(() -> {
                this.sender.close();
                this.controller.close(condition);
                try {
                    this.sessionSPI.closeSender(this.brokerConsumer);
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
                finally {
                    this.messageWriter.close();
                }
                this.connection.flush();
            });
        }
    }

    @Override
    public void close(boolean remoteLinkClose) throws ActiveMQAMQPException {
        if (!this.closed) {
            this.closed = true;
            this.connection.runLater(() -> {
                try {
                    this.protonSession.removeSender(this.sender);
                    this.sessionSPI.closeSender(this.brokerConsumer);
                    if (remoteLinkClose) {
                        this.controller.close();
                    }
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
                finally {
                    this.messageWriter.close();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Delivery delivery) throws ActiveMQAMQPException {
        if (this.closed) {
            return;
        }
        OperationContext oldContext = this.sessionSPI.recoverContext();
        try {
            MessageReference reference = (MessageReference)delivery.getContext();
            Message message = reference != null ? reference.getMessage() : null;
            DeliveryState remoteState = delivery.getRemoteState();
            if (remoteState != null && remoteState.getType() == DeliveryState.DeliveryStateType.Accepted) {
                if (!delivery.isSettled()) {
                    this.doAck(message);
                    delivery.settle();
                }
            } else {
                this.handleExtendedDeliveryOutcomes(message, delivery, remoteState);
            }
            if (!this.preSettle) {
                this.protonSession.replaceTag(delivery.getTag());
            }
        }
        finally {
            this.sessionSPI.afterIO(this.connectionFlusher);
            this.sessionSPI.resetContext(oldContext);
        }
    }

    protected void doAck(Message message) throws ActiveMQAMQPIllegalStateException {
        try {
            this.sessionSPI.ack(null, this.brokerConsumer, message);
        }
        catch (Exception e) {
            logger.warn(e.toString(), (Throwable)e);
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorAcknowledgingMessage(message.toString(), e.getMessage());
        }
    }

    private boolean handleExtendedDeliveryOutcomes(Message message, Delivery delivery, DeliveryState remoteState) throws ActiveMQAMQPException {
        boolean settleImmediate = true;
        boolean handled = true;
        if (remoteState == null) {
            logger.debug("Received null disposition for delivery update: {}", (Object)remoteState);
            return true;
        }
        switch (remoteState.getType()) {
            case Transactional: {
                TransactionalState txState = (TransactionalState)remoteState;
                ProtonTransactionImpl tx = (ProtonTransactionImpl)this.sessionSPI.getTransaction(txState.getTxnId(), false);
                if (txState.getOutcome() == null) break;
                settleImmediate = false;
                Outcome outcome = txState.getOutcome();
                if (!(outcome instanceof Accepted)) break;
                if (!delivery.remotelySettled()) {
                    TransactionalState txAccepted = new TransactionalState();
                    txAccepted.setOutcome((Outcome)Accepted.getInstance());
                    txAccepted.setTxnId(txState.getTxnId());
                    delivery.disposition((DeliveryState)txAccepted);
                }
                try {
                    if (RefCountMessage.isRefTraceEnabled()) {
                        RefCountMessage.deferredDebug((Message)message, (String)"Adding ACK message to TX {}", (Object[])new Object[]{tx == null ? "no-tx" : Long.valueOf(tx.getID())});
                    }
                    this.sessionSPI.ack((Transaction)tx, this.brokerConsumer, message);
                    tx.addDelivery(delivery, this);
                    break;
                }
                catch (Exception e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorAcknowledgingMessage(message.toString(), e.getMessage());
                }
            }
            case Released: {
                try {
                    this.sessionSPI.cancel(this.brokerConsumer, message, false);
                    break;
                }
                catch (Exception e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCancellingMessage(message.toString(), e.getMessage());
                }
            }
            case Rejected: {
                try {
                    if (this.amqpTreatRejectAsUnmodifiedDeliveryFailed) {
                        this.sessionSPI.cancel(this.brokerConsumer, message, true);
                        break;
                    }
                    this.sessionSPI.reject(this.brokerConsumer, message);
                    break;
                }
                catch (Exception e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCancellingMessage(message.toString(), e.getMessage());
                }
            }
            case Modified: {
                try {
                    Modified modification = (Modified)remoteState;
                    if (Boolean.TRUE.equals(modification.getUndeliverableHere())) {
                        message.rejectConsumer(this.brokerConsumer.sequentialID());
                    }
                    if (Boolean.TRUE.equals(modification.getDeliveryFailed())) {
                        this.sessionSPI.cancel(this.brokerConsumer, message, true);
                        break;
                    }
                    this.sessionSPI.cancel(this.brokerConsumer, message, false);
                    break;
                }
                catch (Exception e) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCancellingMessage(message.toString(), e.getMessage());
                }
            }
            default: {
                logger.debug("Received null or unknown disposition for delivery update: {}", (Object)remoteState);
                handled = false;
            }
        }
        if (settleImmediate) {
            delivery.settle();
        }
        return handled;
    }

    public void settle(Delivery delivery) {
        this.connection.requireInHandler();
        delivery.settle();
    }

    public synchronized void checkState() {
        this.sessionSPI.resumeDelivery(this.brokerConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deliverMessage(MessageReference messageReference, ServerConsumer consumer) throws Exception {
        MessageWriter messageWriter;
        if (this.closed) {
            return 0;
        }
        if (this.beforeDelivery != null) {
            this.beforeDelivery.accept((MessageReference)messageReference);
        }
        Object object = this.creditsLock;
        synchronized (object) {
            if (this.sender.getLocalState() == EndpointState.CLOSED) {
                return 0;
            }
            this.pending.incrementAndGet();
            --this.credits;
        }
        this.messageWriter = messageWriter = this.controller.selectOutgoingMessageWriter(this, messageReference).open(messageReference);
        if (messageReference instanceof Runnable && consumer.allowReferenceCallback()) {
            messageReference.onDelivery((Consumer)messageWriter);
            this.connection.runNow((Runnable)messageReference);
        } else {
            this.connection.runNow(() -> messageWriter.accept(messageReference));
        }
        return 1;
    }

    Delivery createDelivery(MessageReference messageReference, int messageFormat) {
        Delivery delivery = this.sender.delivery(this.preSettle ? EMPTY_DELIVERY_TAG : this.protonSession.getTag());
        delivery.setContext((Object)messageReference);
        delivery.setMessageFormat(messageFormat);
        return delivery;
    }

    void reportDeliveryError(MessageWriter deliveryWriter, MessageReference messageReference, Exception e) {
        if (e instanceof ConversionException && this.brokerConsumer.getBinding() instanceof LocalQueueBinding) {
            ActiveMQAMQPProtocolLogger.LOGGER.messageConversionFailed(e);
            LocalQueueBinding queueBinding = (LocalQueueBinding)this.brokerConsumer.getBinding();
            try {
                queueBinding.getQueue().sendToDeadLetterAddress(null, messageReference);
            }
            catch (Exception e1) {
                ActiveMQAMQPProtocolLogger.LOGGER.unableToSendMessageToDLA(messageReference, e1);
            }
            return;
        }
        logger.warn(e.getMessage(), (Throwable)e);
        this.brokerConsumer.errorProcessing((Throwable)e, messageReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportDeliveryComplete(MessageWriter deliveryWriter, MessageReference messageReference, Delivery delivery, boolean promptDelivery) {
        Runnable localRunnable = this.afterDelivery;
        this.afterDelivery = null;
        Object object = this.creditsLock;
        synchronized (object) {
            this.pending.decrementAndGet();
        }
        if (this.preSettle) {
            try {
                this.sessionSPI.ack(null, this.brokerConsumer, messageReference.getMessage());
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            delivery.settle();
        } else {
            this.sender.advance();
        }
        deliveryWriter.close();
        if (!this.closed) {
            if (localRunnable != null) {
                localRunnable.run();
            }
            if (promptDelivery) {
                this.brokerConsumer.promptDelivery();
                this.connection.instantFlush();
            } else {
                this.connection.flush();
            }
        }
    }

    private final class ConnectionFlushIOCallback
    implements IOCallback {
        private ConnectionFlushIOCallback() {
        }

        public void done() {
            ProtonServerSenderContext.this.connection.flush();
        }

        public void onError(int errorCode, String errorMessage) {
            ProtonServerSenderContext.this.connection.flush();
        }
    }
}

