/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.BitSet;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AbstractCollectionEvent;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.ClearEvent;
import org.hibernate.event.spi.ClearEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEvent;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerContextProvider;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerTypeContext;
import org.hibernate.search.mapper.orm.event.impl.KeepIfSameClassDuplicationStrategy;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoTypeIndexingPlan;
import org.hibernate.search.util.common.annotation.impl.SuppressForbiddenApis;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.service.ServiceRegistry;

public final class HibernateSearchEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener,
FlushEventListener,
AutoFlushEventListener,
ClearEventListener {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmListenerContextProvider contextProvider;
    private final boolean dirtyCheckingEnabled;

    public HibernateSearchEventListener(HibernateOrmListenerContextProvider contextProvider, boolean dirtyCheckingEnabled) {
        this.contextProvider = contextProvider;
        this.dirtyCheckingEnabled = dirtyCheckingEnabled;
        log.debug("Hibernate Search dirty checks " + (dirtyCheckingEnabled ? "enabled" : "disabled"));
    }

    public void registerTo(SessionFactoryImplementor sessionFactory) {
        EventListenerRegistry listenerRegistry = HibernateOrmUtils.getServiceOrFail((ServiceRegistry)sessionFactory.getServiceRegistry(), EventListenerRegistry.class);
        listenerRegistry.addDuplicationStrategy((DuplicationStrategy)new KeepIfSameClassDuplicationStrategy(HibernateSearchEventListener.class));
        listenerRegistry.appendListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{this});
        listenerRegistry.appendListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{this});
        listenerRegistry.appendListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{this});
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_RECREATE, (Object[])new PostCollectionRecreateEventListener[]{this});
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_REMOVE, (Object[])new PostCollectionRemoveEventListener[]{this});
        listenerRegistry.appendListeners(EventType.POST_COLLECTION_UPDATE, (Object[])new PostCollectionUpdateEventListener[]{this});
        listenerRegistry.appendListeners(EventType.FLUSH, (Object[])new FlushEventListener[]{this});
        listenerRegistry.appendListeners(EventType.AUTO_FLUSH, (Object[])new AutoFlushEventListener[]{this});
        listenerRegistry.appendListeners(EventType.CLEAR, (Object[])new ClearEventListener[]{this});
    }

    public void onPostDelete(PostDeleteEvent event) {
        if (!this.contextProvider.listenerEnabled()) {
            return;
        }
        Object entity = event.getEntity();
        HibernateOrmListenerTypeContext typeContext = this.getTypeContextOrNull((EntityMappingType)event.getPersister());
        if (typeContext == null) {
            return;
        }
        PojoTypeIndexingPlan plan = this.getCurrentIndexingPlanIfTypeIncluded((SessionImplementor)event.getSession(), typeContext);
        if (plan == null) {
            return;
        }
        Object providedId = typeContext.toIndexingPlanProvidedId(event.getId());
        plan.delete(providedId, null, entity);
        BitSet dirtyAssociationPaths = typeContext.dirtyContainingAssociationFilter().all();
        if (dirtyAssociationPaths != null) {
            plan.updateAssociationInverseSide(dirtyAssociationPaths, null, event.getDeletedState());
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        if (!this.contextProvider.listenerEnabled()) {
            return;
        }
        Object entity = event.getEntity();
        HibernateOrmListenerTypeContext typeContext = this.getTypeContextOrNull((EntityMappingType)event.getPersister());
        if (typeContext == null) {
            return;
        }
        PojoTypeIndexingPlan plan = this.getCurrentIndexingPlanIfTypeIncluded((SessionImplementor)event.getSession(), typeContext);
        if (plan == null) {
            return;
        }
        Object providedId = typeContext.toIndexingPlanProvidedId(event.getId());
        plan.add(providedId, null, entity);
        BitSet dirtyAssociationPaths = typeContext.dirtyContainingAssociationFilter().all();
        if (dirtyAssociationPaths != null) {
            plan.updateAssociationInverseSide(dirtyAssociationPaths, null, event.getState());
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        BitSet dirtyDirectAssociationPaths;
        BitSet dirtyPaths;
        boolean considerAllDirty;
        if (!this.contextProvider.listenerEnabled()) {
            return;
        }
        Object entity = event.getEntity();
        HibernateOrmListenerTypeContext typeContext = this.getTypeContextOrNull((EntityMappingType)event.getPersister());
        if (typeContext == null) {
            return;
        }
        PojoTypeIndexingPlan plan = this.getCurrentIndexingPlanIfTypeIncluded((SessionImplementor)event.getSession(), typeContext);
        if (plan == null) {
            return;
        }
        if (this.dirtyCheckingEnabled) {
            int[] dirtyProperties = event.getDirtyProperties();
            if (dirtyProperties == null || dirtyProperties.length == 0) {
                considerAllDirty = true;
                dirtyPaths = null;
                dirtyDirectAssociationPaths = typeContext.dirtyContainingAssociationFilter().all();
            } else {
                considerAllDirty = false;
                dirtyPaths = typeContext.dirtyFilter().filter(dirtyProperties);
                dirtyDirectAssociationPaths = typeContext.dirtyContainingAssociationFilter().filter(dirtyProperties);
            }
        } else {
            considerAllDirty = true;
            dirtyPaths = null;
            dirtyDirectAssociationPaths = typeContext.dirtyContainingAssociationFilter().all();
        }
        Object providedId = typeContext.toIndexingPlanProvidedId(event.getId());
        if (considerAllDirty) {
            plan.addOrUpdate(providedId, null, entity, true, true, null);
        } else if (dirtyPaths != null) {
            plan.addOrUpdate(providedId, null, entity, false, false, dirtyPaths);
        }
        if (dirtyDirectAssociationPaths != null) {
            plan.updateAssociationInverseSide(dirtyDirectAssociationPaths, event.getOldState(), event.getState());
        }
    }

    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        this.processCollectionEvent((AbstractCollectionEvent)event);
    }

    public void onFlush(FlushEvent event) {
        if (!this.contextProvider.listenerEnabled()) {
            return;
        }
        EventSource session = event.getSession();
        PojoIndexingPlan plan = this.getCurrentIndexingPlanIfExisting((SessionImplementor)session);
        if (plan == null) {
            return;
        }
        plan.process();
        if (!session.isTransactionInProgress()) {
            this.contextProvider.currentAutomaticIndexingSynchronizationStrategy((SessionImplementor)session).executeAndSynchronize(plan);
        }
    }

    public void onAutoFlush(AutoFlushEvent event) throws HibernateException {
        if (!this.contextProvider.listenerEnabled()) {
            return;
        }
        if (!event.isFlushRequired()) {
            return;
        }
        PojoIndexingPlan plan = this.getCurrentIndexingPlanIfExisting((SessionImplementor)event.getSession());
        if (plan != null) {
            plan.process();
        }
    }

    public void onClear(ClearEvent event) {
        if (!this.contextProvider.listenerEnabled()) {
            return;
        }
        EventSource session = event.getSession();
        PojoIndexingPlan plan = this.getCurrentIndexingPlanIfExisting((SessionImplementor)session);
        if (plan != null) {
            plan.discardNotProcessed();
        }
    }

    private PojoTypeIndexingPlan getCurrentIndexingPlanIfTypeIncluded(SessionImplementor sessionImplementor, HibernateOrmListenerTypeContext typeContext) {
        return this.contextProvider.currentIndexingPlanIfTypeIncluded(sessionImplementor, typeContext.typeIdentifier());
    }

    private PojoIndexingPlan getCurrentIndexingPlanIfExisting(SessionImplementor sessionImplementor) {
        return this.contextProvider.currentIndexingPlanIfExisting(sessionImplementor);
    }

    private HibernateOrmListenerTypeContext getTypeContextOrNull(EntityMappingType entityMappingType) {
        String entityName = entityMappingType.getEntityName();
        return (HibernateOrmListenerTypeContext)this.contextProvider.typeContextProvider().byHibernateOrmEntityName().getOrNull((Object)entityName);
    }

    private void processCollectionEvent(AbstractCollectionEvent event) {
        BitSet dirtyPaths;
        if (!this.contextProvider.listenerEnabled()) {
            return;
        }
        Object ownerEntity = event.getAffectedOwnerOrNull();
        if (ownerEntity == null) {
            return;
        }
        HibernateOrmListenerTypeContext typeContext = (HibernateOrmListenerTypeContext)this.contextProvider.typeContextProvider().byHibernateOrmEntityName().getOrNull((Object)event.getAffectedOwnerEntityName());
        if (typeContext == null) {
            return;
        }
        PojoTypeIndexingPlan plan = this.getCurrentIndexingPlanIfTypeIncluded((SessionImplementor)event.getSession(), typeContext);
        if (plan == null) {
            return;
        }
        if (this.dirtyCheckingEnabled) {
            PersistentCollection persistentCollection = event.getCollection();
            String collectionRole = null;
            if (persistentCollection != null) {
                collectionRole = persistentCollection.getRole();
            }
            if (collectionRole != null) {
                dirtyPaths = typeContext.dirtyFilter().filter(collectionRole);
                if (dirtyPaths == null) {
                    return;
                }
            } else {
                dirtyPaths = null;
            }
        } else {
            dirtyPaths = null;
        }
        Object providedId = typeContext.toIndexingPlanProvidedId(event.getAffectedOwnerIdOrNull());
        if (dirtyPaths != null) {
            plan.addOrUpdate(providedId, null, ownerEntity, false, false, dirtyPaths);
        } else {
            plan.addOrUpdate(providedId, null, ownerEntity, true, true, null);
        }
    }

    @SuppressForbiddenApis(reason="We are forced to implement this method and it requires accepting an EntityPersister")
    public boolean requiresPostCommitHandling(EntityPersister persister) {
        return false;
    }
}

