/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.marshalling;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.util.AggregatedClassLoader;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.remote.client.impl.MarshallerRegistration;
import org.jboss.as.clustering.infinispan.marshalling.MarshallerFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.cache.infinispan.marshalling.MediaTypes;
import org.wildfly.clustering.cache.infinispan.marshalling.UserMarshaller;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.MarshallerConfigurationBuilder;
import org.wildfly.clustering.marshalling.jboss.JBossByteBufferMarshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationBuilder;
import org.wildfly.clustering.marshalling.protostream.ClassLoaderMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContextBuilder;
import org.wildfly.clustering.marshalling.protostream.WrappedMessageByteBufferMarshaller;
import org.wildfly.clustering.marshalling.protostream.modules.ModuleClassLoaderMarshaller;

public enum UserMarshallerFactory implements MarshallerFactory
{
    DEFAULT((Supplier)MediaTypes.INFINISPAN_PROTOSTREAM){
        private final Supplier<SerializationContextBuilder<SerializationContextInitializer>> builderFactory = () -> (SerializationContextBuilder)SerializationContextBuilder.newInstance().register((Object)MarshallerRegistration.INSTANCE);

        @Override
        public ByteBufferMarshaller createByteBufferMarshaller(ModuleLoader moduleLoader, List<ClassLoader> loaders) {
            ImmutableSerializationContext context = (ImmutableSerializationContext)this.build(this.builderFactory, loaders);
            return new WrappedMessageByteBufferMarshaller(context);
        }

        @Override
        public Marshaller createUserMarshaller(ModuleLoader moduleLoader, List<ClassLoader> loaders) {
            ImmutableSerializationContext context = (ImmutableSerializationContext)this.build(this.builderFactory, loaders);
            WrappedMessageByteBufferMarshaller marshaller = new WrappedMessageByteBufferMarshaller(context);
            BufferSizePredictor predictor = new BufferSizePredictor(){
                final /* synthetic */ ByteBufferMarshaller val$marshaller;
                {
                    this.val$marshaller = byteBufferMarshaller;
                }

                public int nextSize(Object object) {
                    return this.val$marshaller.size(object).orElse(1);
                }

                public void recordSize(int previousSize) {
                }
            };
            return new ProtoStreamMarshaller((SerializationContext)context, (ByteBufferMarshaller)marshaller, predictor){
                final /* synthetic */ ByteBufferMarshaller val$marshaller;
                final /* synthetic */ BufferSizePredictor val$predictor;
                {
                    this.val$marshaller = byteBufferMarshaller;
                    this.val$predictor = bufferSizePredictor;
                    super(serializationContext);
                }

                public Object objectFromByteBuffer(byte[] buffer, int offset, int length) throws IOException, ClassNotFoundException {
                    return this.val$marshaller.read(java.nio.ByteBuffer.wrap(buffer, offset, length));
                }

                public ByteBuffer objectToBuffer(Object object) throws IOException {
                    return ByteBufferImpl.create((java.nio.ByteBuffer)this.val$marshaller.write(object));
                }

                protected ByteBuffer objectToBuffer(Object object, int estimatedSize) throws IOException {
                    return this.objectToBuffer(object);
                }

                public byte[] objectToByteBuffer(Object object) throws IOException {
                    return this.objectToBuffer(object).trim();
                }

                public byte[] objectToByteBuffer(Object object, int estimatedSize) throws IOException {
                    return this.objectToByteBuffer(object);
                }

                public Object objectFromInputStream(InputStream input) throws IOException {
                    return this.val$marshaller.readFrom(input);
                }

                public BufferSizePredictor getBufferSizePredictor(Object object) {
                    return this.val$predictor;
                }
            };
        }
    }
    ,
    JBOSS((Supplier)MediaTypes.JBOSS_MARSHALLING){

        @Override
        public ByteBufferMarshaller createByteBufferMarshaller(ModuleLoader moduleLoader, List<ClassLoader> loaders) {
            MarshallingConfigurationBuilder builder = MarshallingConfigurationBuilder.newInstance((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)moduleLoader));
            loaders.forEach(arg_0 -> ((MarshallingConfigurationBuilder)builder).load(arg_0));
            Object classLoader = loaders.size() > 1 ? new AggregatedClassLoader(loaders) : loaders.get(0);
            return new JBossByteBufferMarshaller((MarshallingConfiguration)builder.build(), (ClassLoader)classLoader);
        }
    }
    ,
    PROTOSTREAM((Supplier)MediaTypes.WILDFLY_PROTOSTREAM){

        @Override
        public ByteBufferMarshaller createByteBufferMarshaller(ModuleLoader moduleLoader, List<ClassLoader> loaders) {
            SerializationContextBuilder builder = SerializationContextBuilder.newInstance((ClassLoaderMarshaller)new ModuleClassLoaderMarshaller(moduleLoader));
            loaders.forEach(arg_0 -> ((SerializationContextBuilder)builder).load(arg_0));
            return new ProtoStreamByteBufferMarshaller((ImmutableSerializationContext)builder.build());
        }
    };

    private final MediaType type;

    private UserMarshallerFactory(Supplier<MediaType> type) {
        this.type = type.get();
    }

    @Override
    public Marshaller createUserMarshaller(ModuleLoader moduleLoader, List<ClassLoader> loaders) {
        return new UserMarshaller(this.type, this.createByteBufferMarshaller(moduleLoader, loaders));
    }

    <C, E, B extends MarshallerConfigurationBuilder<C, E, B>> C build(Supplier<B> builderFactory, List<ClassLoader> loaders) {
        MarshallerConfigurationBuilder builder = (MarshallerConfigurationBuilder)builderFactory.get();
        loaders.forEach(arg_0 -> ((MarshallerConfigurationBuilder)builder).load(arg_0));
        return (C)builder.build();
    }

    public static MarshallerFactory forMediaType(MediaType type) {
        for (UserMarshallerFactory factory : EnumSet.allOf(UserMarshallerFactory.class)) {
            if (!factory.type.equals((Object)type)) continue;
            return factory;
        }
        throw new IllegalArgumentException(type.toString());
    }
}

