/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.BindingsFactory;
import org.apache.activemq.artemis.core.postoffice.impl.AddressMap;
import org.apache.activemq.artemis.core.postoffice.impl.AddressMapVisitor;
import org.apache.activemq.artemis.core.postoffice.impl.SimpleAddressManager;
import org.apache.activemq.artemis.core.server.metrics.MetricsManager;
import org.apache.activemq.artemis.core.transaction.Transaction;

public class WildcardAddressManager
extends SimpleAddressManager {
    private final AddressMap<Bindings> addressMap;

    public WildcardAddressManager(BindingsFactory bindingsFactory, WildcardConfiguration wildcardConfiguration, StorageManager storageManager, MetricsManager metricsManager) {
        super(bindingsFactory, wildcardConfiguration, storageManager, metricsManager);
        this.addressMap = new AddressMap(this.wildcardConfiguration.getAnyWordsString(), this.wildcardConfiguration.getSingleWordString(), this.wildcardConfiguration.getDelimiter());
    }

    public WildcardAddressManager(BindingsFactory bindingsFactory, StorageManager storageManager, MetricsManager metricsManager) {
        super(bindingsFactory, storageManager, metricsManager);
        this.addressMap = new AddressMap(this.wildcardConfiguration.getAnyWordsString(), this.wildcardConfiguration.getSingleWordString(), this.wildcardConfiguration.getDelimiter());
    }

    @Override
    public Bindings getBindingsForRoutingAddress(final SimpleString address) throws Exception {
        assert (!this.isAWildcardAddress(address));
        Bindings bindings = super.getBindingsForRoutingAddress(address);
        if (bindings == null) {
            final Bindings[] lazyCreateResult = new Bindings[1];
            this.addressMap.visitMatchingWildcards(address, new AddressMapVisitor<Bindings>(){
                Bindings newBindings = null;

                @Override
                public void visit(Bindings matchingBindings) throws Exception {
                    if (this.newBindings == null) {
                        lazyCreateResult[0] = this.newBindings = WildcardAddressManager.this.addMappingsInternal(address, matchingBindings.getBindings());
                    } else {
                        for (Binding binding : matchingBindings.getBindings()) {
                            this.newBindings.addBinding(binding);
                        }
                    }
                }
            });
            bindings = lazyCreateResult[0];
            if (bindings != null) {
                this.addressMap.put(address, bindings);
            }
        }
        return bindings;
    }

    @Override
    public boolean addBinding(Binding binding) throws Exception {
        boolean bindingsForANewAddress = super.addBinding(binding);
        SimpleString address = binding.getAddress();
        Bindings bindingsForRoutingAddress = (Bindings)this.mappings.get(binding.getAddress());
        if (this.isAWildcardAddress(address)) {
            this.addressMap.visitMatching(address, bindings -> bindings.addBinding(binding));
        } else if (bindingsForANewAddress) {
            this.addressMap.visitMatchingWildcards(address, bindings -> {
                for (Binding toAdd : bindings.getBindings()) {
                    bindingsForRoutingAddress.addBinding(toAdd);
                }
            });
        }
        if (bindingsForANewAddress) {
            this.addressMap.put(address, bindingsForRoutingAddress);
        }
        return bindingsForANewAddress;
    }

    @Override
    public Binding removeBinding(SimpleString uniqueName, Transaction tx) throws Exception {
        SimpleString address;
        Binding binding = super.removeBinding(uniqueName, tx);
        if (binding != null && this.isAWildcardAddress(address = binding.getAddress())) {
            this.addressMap.visitMatching(address, bindings -> this.removeBindingInternal(bindings.getName(), uniqueName));
        }
        return binding;
    }

    private boolean isAWildcardAddress(SimpleString address) {
        return address.containsEitherOf(this.wildcardConfiguration.getAnyWords(), this.wildcardConfiguration.getSingleWord());
    }

    @Override
    protected void bindingsEmpty(SimpleString realAddress, Bindings bindings) {
        this.addressMap.remove(realAddress, bindings);
    }

    @Override
    public void clear() {
        super.clear();
        this.addressMap.reset();
    }

    public AddressMap<Bindings> getAddressMap() {
        return this.addressMap;
    }
}

