/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.event.logger.EventFormatter;
import org.wildfly.event.logger.EventLogger;
import org.wildfly.event.logger.EventWriter;
import org.wildfly.event.logger.JsonEventFormatter;
import org.wildfly.event.logger.StdoutEventWriter;
import org.wildfly.extension.undertow.AccessLogAttribute;
import org.wildfly.extension.undertow.EventLoggerHttpHandler;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.xnio.XnioWorker;

class EventLoggerService
implements Service {
    private final Set<AccessLogAttribute> attributes;
    private final boolean includeHostName;
    private final Map<String, Object> metadata;
    private final Predicate predicate;
    private final Supplier<Host> host;
    private final Supplier<XnioWorker> worker;

    EventLoggerService(Collection<AccessLogAttribute> attributes, Predicate predicate, Map<String, Object> metadata, boolean includeHostName, Supplier<Host> host, Supplier<XnioWorker> worker) {
        this.attributes = new CopyOnWriteArraySet<AccessLogAttribute>(attributes);
        this.predicate = predicate == null ? Predicates.truePredicate() : predicate;
        this.metadata = metadata;
        this.includeHostName = includeHostName;
        this.host = host;
        this.worker = worker;
    }

    public void start(StartContext context) throws StartException {
        Host host = this.host.get();
        JsonEventFormatter.Builder formatterBuilder = JsonEventFormatter.builder().setIncludeTimestamp(false);
        if (this.includeHostName) {
            formatterBuilder.addMetaData("hostName", (Object)host.getName());
        }
        if (this.metadata != null && !this.metadata.isEmpty()) {
            formatterBuilder.addMetaData(this.metadata);
        }
        JsonEventFormatter formatter = formatterBuilder.build();
        final EventLogger eventLogger = EventLogger.createAsyncLogger((String)"web-access", (EventWriter)StdoutEventWriter.of((EventFormatter)formatter), (Executor)((Executor)this.worker.get()));
        UndertowLogger.ROOT_LOGGER.debugf("Adding console-access-log for host %s", host.getName());
        host.setAccessLogHandler(new Function<HttpHandler, HttpHandler>(){

            @Override
            public HttpHandler apply(HttpHandler httpHandler) {
                return new EventLoggerHttpHandler(httpHandler, EventLoggerService.this.predicate, EventLoggerService.this.attributes, eventLogger);
            }
        });
    }

    public void stop(StopContext context) {
        Host host = this.host.get();
        UndertowLogger.ROOT_LOGGER.debugf("Removing console-access-log for host %s", host.getName());
        host.setAccessLogHandler(null);
    }
}

