/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.remote;

import jakarta.transaction.TransactionManager;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.infinispan.BasicCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheContainerConfiguration;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheProperties;

public interface RemoteCacheConfiguration
extends RemoteCacheContainerConfiguration,
BasicCacheConfiguration {
    public <CK, CV> RemoteCache<CK, CV> getCache();

    @Override
    default public RemoteCacheContainer getCacheContainer() {
        return this.getCache().getRemoteCacheContainer();
    }

    default public Executor getExecutor() {
        final ExecutorService executor = this.getCache().getRemoteCacheManager().getAsyncExecutorService();
        return new Executor(){
            final /* synthetic */ RemoteCacheConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void execute(Runnable command) {
                try {
                    executor.execute(command);
                }
                catch (IllegalLifecycleStateException e) {
                    throw new RejectedExecutionException(e);
                }
            }
        };
    }

    default public TransactionManager getTransactionManager() {
        return this.getCache().getTransactionManager();
    }

    default public Flag[] getIgnoreReturnFlags() {
        Flag[] flagArray;
        if (this.getNearCacheMode().enabled()) {
            flagArray = new Flag[]{};
        } else {
            Flag[] flagArray2 = new Flag[1];
            flagArray = flagArray2;
            flagArray2[0] = Flag.SKIP_LISTENER_NOTIFICATION;
        }
        return flagArray;
    }

    default public Flag[] getForceReturnFlags() {
        Flag[] flagArray;
        if (this.getNearCacheMode().enabled()) {
            Flag[] flagArray2 = new Flag[1];
            flagArray = flagArray2;
            flagArray2[0] = Flag.FORCE_RETURN_VALUE;
        } else {
            Flag[] flagArray3 = new Flag[2];
            flagArray3[0] = Flag.FORCE_RETURN_VALUE;
            flagArray = flagArray3;
            flagArray3[1] = Flag.SKIP_LISTENER_NOTIFICATION;
        }
        return flagArray;
    }

    default public NearCacheMode getNearCacheMode() {
        RemoteCache cache = this.getCache();
        return ((org.infinispan.client.hotrod.configuration.RemoteCacheConfiguration)cache.getRemoteCacheContainer().getConfiguration().remoteCaches().get(cache.getName())).nearCacheMode();
    }

    default public CacheProperties getCacheProperties() {
        return new RemoteCacheProperties(this.getCache());
    }
}

