/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionMetaData;
import org.wildfly.clustering.session.cache.AbstractImmutableSession;
import org.wildfly.clustering.session.cache.attributes.DetachedSessionAttributes;
import org.wildfly.clustering.session.cache.metadata.DetachedSessionMetaData;

public class DetachedSession<C>
extends AbstractImmutableSession
implements Session<C> {
    private final SessionManager<C> manager;
    private final C context;
    private final SessionMetaData metaData;
    private final Map<String, Object> attributes;

    public DetachedSession(SessionManager<C> manager, String id, C context) {
        super(id);
        this.manager = manager;
        this.context = context;
        Supplier<Batch> batchFactory = this::getBatch;
        Supplier sessionFactory = this::getSession;
        this.metaData = new DetachedSessionMetaData(batchFactory, sessionFactory);
        this.attributes = new DetachedSessionAttributes(batchFactory, sessionFactory);
    }

    public SessionMetaData getMetaData() {
        return this.metaData;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public C getContext() {
        return this.context;
    }

    public boolean isValid() {
        try (Batch batch = this.getBatch();){
            boolean bl = this.manager.findImmutableSession(this.getId()) != null;
            return bl;
        }
    }

    public void invalidate() {
        try (Batch batch = this.getBatch();
             Session<C> session = this.getSession();){
            session.invalidate();
        }
    }

    public void close() {
    }

    private Session<C> getSession() {
        return Optional.ofNullable(this.manager.findSession(this.getId())).orElseThrow(IllegalStateException::new);
    }

    private Batch getBatch() {
        return (Batch)this.manager.getBatchFactory().get();
    }
}

