/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.parsing;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.parsing.WriteUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class DeploymentOverlaysXml {
    DeploymentOverlaysXml() {
    }

    void parseDeploymentOverlays(XMLExtendedStreamReader reader, String namespace, ModelNode baseAddress, List<ModelNode> list, boolean allowContent, boolean allowDeployment) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (String)namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case DEPLOYMENT_OVERLAY: {
                    this.parseDeploymentOverlay(reader, baseAddress, list, allowContent, allowDeployment);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseDeploymentOverlay(XMLExtendedStreamReader reader, ModelNode baseAddress, List<ModelNode> list, boolean allowContent, boolean allowDeployment) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        String name = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode addr = baseAddress.clone();
        addr.add("deployment-overlay", name);
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").set(addr);
        list.add(op);
        while (reader.nextTag() != 2) {
            Element element = Element.forName((String)reader.getLocalName());
            if (element == Element.CONTENT && allowContent) {
                this.parseContentOverride(name, reader, baseAddress, list);
                continue;
            }
            if (element == Element.DEPLOYMENT && allowDeployment) {
                this.parseDeploymentOverlayDeployment(name, reader, baseAddress, list);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseContentOverride(String name, XMLExtendedStreamReader reader, ModelNode baseAddress, List<ModelNode> list) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH, Attribute.CONTENT);
        String path = null;
        byte[] content = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case PATH: {
                    path = value;
                    continue block4;
                }
                case CONTENT: {
                    content = HashUtil.hexStringToByteArray((String)value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode address = baseAddress.clone();
        address.add("deployment-overlay", name);
        address.add("content", path);
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").set(address);
        op.get("content").get("hash").set(content);
        list.add(op);
    }

    private void parseDeploymentOverlayDeployment(String name, XMLExtendedStreamReader reader, ModelNode baseAddress, List<ModelNode> list) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        String depName = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    depName = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode address = baseAddress.clone();
        address.add("deployment-overlay", name);
        address.add("deployment", depName);
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").set(address);
        list.add(op);
    }

    void writeDeploymentOverlays(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        Set names = modelNode.keys();
        if (!names.isEmpty()) {
            writer.writeStartElement(Element.DEPLOYMENT_OVERLAYS.getLocalName());
            for (String uniqueName : names) {
                ModelNode deployments;
                Set deploymentNames;
                ModelNode contentItem = modelNode.get(uniqueName);
                writer.writeStartElement(Element.DEPLOYMENT_OVERLAY.getLocalName());
                WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)uniqueName);
                if (contentItem.hasDefined("content")) {
                    ModelNode overridesNode = contentItem.get("content");
                    Set overrides = overridesNode.keys();
                    for (String override : overrides) {
                        ModelNode overrideNode = overridesNode.get(override);
                        String content = HashUtil.bytesToHexString((byte[])overrideNode.require("content").asBytes());
                        writer.writeStartElement(Element.CONTENT.getLocalName());
                        WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.PATH, (String)override);
                        WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.CONTENT, (String)content);
                        writer.writeEndElement();
                    }
                }
                if (contentItem.hasDefined("deployment") && !(deploymentNames = (deployments = contentItem.get("deployment")).keys()).isEmpty()) {
                    for (String deploymentName : deploymentNames) {
                        ModelNode depNode = deployments.get(deploymentName);
                        writer.writeStartElement(Element.DEPLOYMENT.getLocalName());
                        WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)deploymentName);
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            WriteUtils.writeNewLine((XMLExtendedStreamWriter)writer);
        }
    }
}

