/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool.help;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.wildfly.security.tool.help.CommandsSection;
import org.wildfly.security.tool.help.DescriptionSection;
import org.wildfly.security.tool.help.HelpSection;
import org.wildfly.security.tool.help.OptionsSection;
import org.wildfly.security.tool.help.UsageSection;

public class HelpCommand {
    private final List<HelpSection> helpSections;
    private static TerminalConnection terminalConnection;

    private HelpCommand(HelpCommandBuilder helpCommandBuilder) {
        this.helpSections = helpCommandBuilder.helpSections;
    }

    public void printHelp() {
        if (terminalConnection == null) {
            try {
                terminalConnection = new TerminalConnection(Charset.defaultCharset(), System.in, (OutputStream)System.out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        terminalConnection.write(System.lineSeparator());
        for (HelpSection helpSection : this.helpSections) {
            helpSection.printHelp();
        }
        terminalConnection.close();
    }

    public static TerminalConnection getTerminal() {
        return terminalConnection;
    }

    public static class HelpCommandBuilder {
        private UsageSection usageSection;
        private DescriptionSection descriptionSection;
        private CommandsSection commandsSection;
        private OptionsSection optionsSection;
        private final List<HelpSection> helpSections = new ArrayList<HelpSection>();

        private HelpCommandBuilder() {
        }

        public static HelpCommandBuilder builder() {
            return new HelpCommandBuilder();
        }

        public HelpCommandBuilder usage(UsageSection usageSection) {
            this.usageSection = usageSection;
            return this;
        }

        public HelpCommandBuilder description(DescriptionSection descriptionSection) {
            this.descriptionSection = descriptionSection;
            return this;
        }

        public HelpCommandBuilder commands(CommandsSection commandsSection) {
            this.commandsSection = commandsSection;
            return this;
        }

        public HelpCommandBuilder options(OptionsSection optionsSection) {
            this.optionsSection = optionsSection;
            return this;
        }

        public HelpCommand build() {
            if (this.descriptionSection != null) {
                this.helpSections.add(this.descriptionSection);
            }
            if (this.usageSection != null) {
                this.helpSections.add(this.usageSection);
            }
            if (this.commandsSection != null) {
                this.helpSections.add(this.commandsSection);
            }
            if (this.optionsSection != null) {
                this.helpSections.add(this.optionsSection);
            }
            return new HelpCommand(this);
        }
    }
}

