/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.gson.impl;

import com.google.gson.JsonElement;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementType;
import org.hibernate.search.util.common.AssertionFailure;

public class UnexpectedJsonElementTypeException
extends AssertionFailure {
    public UnexpectedJsonElementTypeException(JsonAccessor<?> accessor, JsonElementType<?> expectedType, JsonElement actualElement) {
        this(String.valueOf(accessor), expectedType, actualElement);
    }

    public UnexpectedJsonElementTypeException(JsonAccessor<?> accessor, List<? extends JsonElementType<?>> expectedTypes, JsonElement actualElement) {
        this(String.valueOf(accessor), expectedTypes, actualElement);
    }

    public UnexpectedJsonElementTypeException(String path, JsonElementType<?> expectedType, JsonElement actualElement) {
        this(path, Collections.singletonList(expectedType), actualElement);
    }

    public UnexpectedJsonElementTypeException(String path, List<? extends JsonElementType<?>> expectedTypes, JsonElement actualElement) {
        super("Unexpected type at '" + path + "'. Expected one of " + String.valueOf(expectedTypes) + ", got '" + String.valueOf(actualElement) + "'");
    }
}

