/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.dynamic.ssl;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.wildfly.security.dynamic.ssl.DynamicSSLContext;
import org.wildfly.security.dynamic.ssl.DynamicSSLContextException;
import org.wildfly.security.dynamic.ssl.DynamicSSLContextSPI;
import org.wildfly.security.dynamic.ssl.DynamicSSLSocketFactory;
import org.wildfly.security.dynamic.ssl.ElytronMessages;

final class DynamicSSLContextSpiImpl
extends SSLContextSpi {
    private final DynamicSSLContextSPI dynamicSSLContextImpl;
    private volatile SSLSocketFactory sslSocketFactory;

    DynamicSSLContextSpiImpl() {
        this(null);
    }

    DynamicSSLContextSpiImpl(DynamicSSLContextSPI dynamicSSLContextSPIImpl) {
        Iterator<DynamicSSLContextSPI> dynamicSSLContextSPIIterator;
        this.dynamicSSLContextImpl = dynamicSSLContextSPIImpl != null ? dynamicSSLContextSPIImpl : ((dynamicSSLContextSPIIterator = ServiceLoader.load(DynamicSSLContextSPI.class).iterator()).hasNext() ? dynamicSSLContextSPIIterator.next() : null);
    }

    private SSLContext getConfiguredDefaultSSLContext() {
        try {
            SSLContext configuredDefault;
            if (this.dynamicSSLContextImpl != null && (configuredDefault = this.dynamicSSLContextImpl.getConfiguredDefault()) != null) {
                return configuredDefault;
            }
            return SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException | DynamicSSLContextException e) {
            throw ElytronMessages.log.cannotObtainConfiguredDefaultSSLContext();
        }
    }

    @Override
    protected void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        if (this.dynamicSSLContextImpl == null) {
            return this.getConfiguredDefaultSSLContext().getSocketFactory();
        }
        if (this.sslSocketFactory == null) {
            DynamicSSLContextSpiImpl dynamicSSLContextSpiImpl = this;
            synchronized (dynamicSSLContextSpiImpl) {
                if (this.sslSocketFactory == null) {
                    this.sslSocketFactory = new DynamicSSLSocketFactory(this.getConfiguredDefaultSSLContext().getSocketFactory(), this.dynamicSSLContextImpl);
                }
            }
        }
        return this.sslSocketFactory;
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return this.getConfiguredDefaultSSLContext().getServerSocketFactory();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        return this.getConfiguredDefaultSSLContext().createSSLEngine();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String host, int port) throws IllegalStateException {
        try {
            if (this.dynamicSSLContextImpl == null) {
                return this.getConfiguredDefaultSSLContext().createSSLEngine(host, port);
            }
            SSLContext sslContext = this.dynamicSSLContextImpl.getSSLContext(new URI(null, null, host, port, null, null, null));
            if (sslContext == null) {
                throw ElytronMessages.log.receivedSSLContextFromDynamicSSLContextProviderWasNull();
            }
            if (sslContext instanceof DynamicSSLContext && sslContext.getSocketFactory().equals(this.engineGetSocketFactory())) {
                throw ElytronMessages.log.dynamicSSLContextCreatesLoop();
            }
            return sslContext.createSSLEngine(host, port);
        }
        catch (URISyntaxException e) {
            throw ElytronMessages.log.couldNotCreateURI();
        }
        catch (DynamicSSLContextException e) {
            throw ElytronMessages.log.couldNotCreateDynamicSSLContextEngine();
        }
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        throw new UnsupportedOperationException(ElytronMessages.log.dynamicSSLContextDoesNotSupportSessions());
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        throw new UnsupportedOperationException(ElytronMessages.log.dynamicSSLContextDoesNotSupportSessions());
    }

    @Override
    protected SSLParameters engineGetSupportedSSLParameters() {
        return this.getConfiguredDefaultSSLContext().getSupportedSSLParameters();
    }
}

