/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.analysis.CharFilterFactory;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalysisComponentParametersStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalysisOptionalComponentsStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalysisComponentBuilder;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractLuceneAnalysisComponentParametersStep<T>
implements LuceneAnalysisComponentParametersStep,
LuceneAnalysisComponentBuilder<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneAnalysisOptionalComponentsStep parentStep;
    final Map<String, String> params = new LinkedHashMap<String, String>();

    AbstractLuceneAnalysisComponentParametersStep(LuceneAnalysisOptionalComponentsStep parentStep) {
        this.parentStep = parentStep;
    }

    @Override
    public LuceneAnalysisComponentParametersStep param(String name, String value) {
        String previous = this.params.putIfAbsent(name, value);
        if (previous != null) {
            throw log.analysisComponentParameterConflict(name, previous, value);
        }
        return this;
    }

    @Override
    public LuceneAnalysisComponentParametersStep charFilter(String factoryName) {
        return this.parentStep.charFilter(factoryName);
    }

    @Override
    public LuceneAnalysisComponentParametersStep charFilter(Class<? extends CharFilterFactory> factoryType) {
        return this.parentStep.charFilter(factoryType);
    }

    @Override
    public LuceneAnalysisComponentParametersStep tokenFilter(String factoryName) {
        return this.parentStep.tokenFilter(factoryName);
    }

    @Override
    public LuceneAnalysisComponentParametersStep tokenFilter(Class<? extends TokenFilterFactory> factoryType) {
        return this.parentStep.tokenFilter(factoryType);
    }
}

