/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.TransactionAttributeType;
import jakarta.ejb.TransactionManagementType;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.NamespaceConfigurator;
import org.jboss.as.ee.component.NamespaceViewConfigurator;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.ViewInstanceFactory;
import org.jboss.as.ee.component.ViewService;
import org.jboss.as.ee.component.interceptors.ComponentDispatcherInterceptor;
import org.jboss.as.ee.naming.ContextInjectionSource;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.EJBComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.EJBValidationConfigurator;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.Ejb2xViewType;
import org.jboss.as.ejb3.component.EjbHomeViewDescription;
import org.jboss.as.ejb3.component.RemoteHomeViewInstanceFactory;
import org.jboss.as.ejb3.component.interceptors.AdditionalSetupInterceptor;
import org.jboss.as.ejb3.component.interceptors.CurrentInvocationContextInterceptor;
import org.jboss.as.ejb3.component.interceptors.EjbExceptionTransformingInterceptorFactories;
import org.jboss.as.ejb3.component.interceptors.LoggingInterceptor;
import org.jboss.as.ejb3.component.interceptors.ShutDownInterceptorFactory;
import org.jboss.as.ejb3.component.invocationmetrics.ExecutionTimeInterceptor;
import org.jboss.as.ejb3.component.invocationmetrics.WaitTimeInterceptor;
import org.jboss.as.ejb3.deployment.ApplicableMethodInformation;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.ejb3.interceptor.server.ServerInterceptorCache;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.security.EJBMethodSecurityAttribute;
import org.jboss.as.ejb3.security.EJBSecurityViewConfigurator;
import org.jboss.as.ejb3.security.IdentityOutflowInterceptorFactory;
import org.jboss.as.ejb3.security.PolicyContextIdInterceptor;
import org.jboss.as.ejb3.security.RoleAddingInterceptor;
import org.jboss.as.ejb3.security.RunAsPrincipalInterceptor;
import org.jboss.as.ejb3.security.SecurityDomainInterceptorFactory;
import org.jboss.as.ejb3.security.SecurityRolesAddingInterceptor;
import org.jboss.as.ejb3.suspend.EJBSuspendHandlerService;
import org.jboss.as.ejb3.timerservice.spi.AutoTimer;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.invocation.AccessCheckingInterceptor;
import org.jboss.invocation.ContextClassLoaderInterceptor;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;

public abstract class EJBComponentDescription
extends ComponentDescription {
    private static final String REMOTE_TRANSACTION_SERVICE_CAPABILITY_NAME = "org.wildfly.transactions.remote-transaction-service";
    private static final String TRANSACTION_GLOBAL_DEFAULT_LOCAL_PROVIDER_CAPABILITY_NAME = "org.wildfly.transactions.global-default-local-provider";
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY_CAPABILITY_NAME = "org.wildfly.transactions.transaction-synchronization-registry";
    private TransactionManagementType transactionManagementType = TransactionManagementType.CONTAINER;
    private EnterpriseBeanMetaData descriptorData;
    private String defaultSecurityDomain;
    private final Set<String> declaredRoles = new HashSet<String>();
    private String runAsRole;
    private String runAsPrincipal;
    private SecurityRolesMetaData securityRoles;
    private final Map<String, Collection<String>> securityRoleLinks = new HashMap<String, Collection<String>>();
    private final ApplicableMethodInformation<EJBMethodSecurityAttribute> descriptorMethodPermissions;
    private final ApplicableMethodInformation<EJBMethodSecurityAttribute> annotationMethodPermissions;
    private final Map<Method, List<AutoTimer>> scheduleMethods = new IdentityHashMap<Method, List<AutoTimer>>();
    private Method timeoutMethod;
    private EJBViewDescription ejbLocalView;
    private EjbHomeViewDescription ejbLocalHomeView;
    private EJBViewDescription ejbRemoteView;
    private EjbHomeViewDescription ejbHomeView;
    private Resource timerServiceResource;
    private boolean exposedViaIiop = false;
    private final ApplicableMethodInformation<TransactionAttributeType> transactionAttributes;
    private final ApplicableMethodInformation<Integer> transactionTimeouts;
    private List<InterceptorDescription> defaultContainerInterceptors = new ArrayList<InterceptorDescription>();
    private boolean excludeDefaultContainerInterceptors;
    private List<InterceptorDescription> classLevelContainerInterceptors = new ArrayList<InterceptorDescription>();
    private Map<MethodIdentifier, List<InterceptorDescription>> methodLevelContainerInterceptors = new HashMap<MethodIdentifier, List<InterceptorDescription>>();
    private Map<MethodIdentifier, Boolean> excludeDefaultContainerInterceptorsForMethod = new HashMap<MethodIdentifier, Boolean>();
    private Map<MethodIdentifier, Boolean> excludeClassLevelContainerInterceptorsForMethod = new HashMap<MethodIdentifier, Boolean>();
    private Set<InterceptorDescription> allContainerInterceptors;
    private ServerInterceptorCache serverInterceptorCache = null;
    private Boolean missingMethodPermissionsDenyAccess = null;
    private final ShutDownInterceptorFactory shutDownInterceptorFactory = new ShutDownInterceptorFactory();
    private BooleanSupplier outflowSecurityDomainsConfigured;
    private boolean securityRequired;
    private ServiceName securityDomainServiceName;
    private String definedSecurityDomain;
    private boolean requiresJacc;
    private boolean legacyCompliantPrincipalPropagation;

    public EJBComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, DeploymentUnit deploymentUnit, EnterpriseBeanMetaData descriptorData) {
        super(componentName, componentClassName, ejbJarDescription.getEEModuleDescription(), deploymentUnit.getServiceName());
        this.descriptorData = descriptorData;
        if (ejbJarDescription.isWar()) {
            this.setNamingMode(ComponentNamingMode.USE_MODULE);
        } else {
            this.setNamingMode(ComponentNamingMode.CREATE);
        }
        this.getConfigurators().addFirst(new NamespaceConfigurator());
        this.getConfigurators().add(new EjbJarConfigurationConfigurator());
        this.getConfigurators().add(new SecurityDomainDependencyConfigurator(this));
        this.addCurrentInvocationContextFactory();
        this.addRemoteTransactionsDependency();
        this.transactionAttributes = new ApplicableMethodInformation<TransactionAttributeType>(componentName, TransactionAttributeType.REQUIRED);
        this.transactionTimeouts = new ApplicableMethodInformation<Object>(componentName, null);
        this.descriptorMethodPermissions = new ApplicableMethodInformation<Object>(componentName, null);
        this.annotationMethodPermissions = new ApplicableMethodInformation<Object>(componentName, null);
        this.addDependency(deploymentUnit.getServiceName().append(ModuleDeployment.SERVICE_NAME));
        this.getConfigurators().addFirst(EJBValidationConfigurator.INSTANCE);
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                DeploymentUnit deploymentUnit = context.getDeploymentUnit();
                Object contextID = deploymentUnit.getName();
                if (deploymentUnit.getParent() != null) {
                    contextID = deploymentUnit.getParent().getName() + "!" + (String)contextID;
                }
                if (description.getNamingMode() == ComponentNamingMode.CREATE) {
                    description.getBindingConfigurations().add(new BindingConfiguration("java:comp/env", (InjectionSource)new ContextInjectionSource("env", "java:comp/env")));
                }
                final List ejbSetupActions = deploymentUnit.getAttachmentList(org.jboss.as.ee.component.Attachments.OTHER_EE_SETUP_ACTIONS);
                if (description.isTimerServiceRequired()) {
                    if (!ejbSetupActions.isEmpty()) {
                        configuration.addTimeoutViewInterceptor(AdditionalSetupInterceptor.factory(ejbSetupActions), 1296);
                    }
                    configuration.addTimeoutViewInterceptor((InterceptorFactory)EJBComponentDescription.this.shutDownInterceptorFactory, 544);
                    ClassLoader classLoader = configuration.getModuleClassLoader();
                    configuration.addTimeoutViewInterceptor(AccessCheckingInterceptor.getFactory(), 1);
                    configuration.addTimeoutViewInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new ContextClassLoaderInterceptor(classLoader)), 3);
                    configuration.addTimeoutViewInterceptor(configuration.getNamespaceContextInterceptorFactory(), 80);
                    configuration.addTimeoutViewInterceptor(CurrentInvocationContextInterceptor.FACTORY, 1024);
                    EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)description;
                    boolean securityRequired = EJBComponentDescription.this.hasBeanLevelSecurityMetadata();
                    ejbComponentDescription.setSecurityRequired(securityRequired);
                    if (ejbComponentDescription.getSecurityDomainServiceName() != null) {
                        HashMap<Integer, InterceptorFactory> elytronInterceptorFactories = EJBComponentDescription.this.getElytronInterceptorFactories((String)contextID, ejbComponentDescription.requiresJacc(), true);
                        elytronInterceptorFactories.forEach((priority, elytronInterceptorFactory) -> configuration.addTimeoutViewInterceptor(elytronInterceptorFactory, priority.intValue()));
                    }
                    Set classMethods = configuration.getClassIndex().getClassMethods();
                    for (Method method : classMethods) {
                        configuration.addTimeoutViewInterceptor(method, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new ComponentDispatcherInterceptor(method)), 2560);
                    }
                    if (EJBComponentDescription.this.serverInterceptorCache != null) {
                        configuration.addTimeoutViewInterceptor(EJBComponentDescription.weaved(EJBComponentDescription.this.serverInterceptorCache.getServerInterceptorsAroundTimeout()), 585);
                    }
                }
                if (!ejbSetupActions.isEmpty()) {
                    configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

                        public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                            for (SetupAction setupAction : ejbSetupActions) {
                                for (ServiceName setupActionDependency : setupAction.dependencies()) {
                                    serviceBuilder.requires(setupActionDependency);
                                }
                            }
                        }
                    });
                }
                configuration.addComponentInterceptor(ExecutionTimeInterceptor.FACTORY, 2128, true);
                configuration.getCreateDependencies().add(new DependencyConfigurator<EJBComponentCreateService>(){

                    public void configureDependency(ServiceBuilder<?> serviceBuilder, EJBComponentCreateService service) throws DeploymentUnitProcessingException {
                        serviceBuilder.addDependency(LoggingInterceptor.LOGGING_ENABLED_SERVICE_NAME, AtomicBoolean.class, service.getExceptionLoggingEnabledInjector());
                    }
                });
            }
        });
        this.addTransactionManagerDependencies();
        this.addEJBSuspendHandlerDependency();
    }

    private static InterceptorFactory weaved(final Collection<InterceptorFactory> interceptorFactories) {
        return new InterceptorFactory(){

            public Interceptor create(InterceptorFactoryContext context) {
                Interceptor[] interceptors = new Interceptor[interceptorFactories.size()];
                Iterator factories = interceptorFactories.iterator();
                for (int i = 0; i < interceptors.length; ++i) {
                    interceptors[i] = ((InterceptorFactory)factories.next()).create(context);
                }
                return Interceptors.getWeavedInterceptor((Interceptor[])interceptors);
            }
        };
    }

    public void addLocalHome(String localHome) {
        EjbHomeViewDescription view = new EjbHomeViewDescription(this, localHome, MethodInterfaceType.LocalHome);
        view.getConfigurators().add(new Ejb2ViewTypeConfigurator(Ejb2xViewType.LOCAL_HOME));
        this.getViews().add(view);
        this.setupViewInterceptors(view);
        this.setupClientViewInterceptors(view);
        this.ejbLocalHomeView = view;
    }

    public void addRemoteHome(String remoteHome) {
        EjbHomeViewDescription view = new EjbHomeViewDescription(this, remoteHome, MethodInterfaceType.Home);
        view.getConfigurators().add(new Ejb2ViewTypeConfigurator(Ejb2xViewType.HOME));
        this.getViews().add(view);
        this.setupViewInterceptors(view);
        this.setupClientViewInterceptors(view);
        this.ejbHomeView = view;
    }

    public void addEjbLocalObjectView(String viewClassName) {
        EJBViewDescription view = this.registerView(viewClassName, MethodInterfaceType.Local, true);
        view.getConfigurators().add(new Ejb2ViewTypeConfigurator(Ejb2xViewType.LOCAL));
        this.ejbLocalView = view;
    }

    public void addEjbObjectView(String viewClassName) {
        EJBViewDescription view = this.registerView(viewClassName, MethodInterfaceType.Remote, true);
        view.getConfigurators().add(new Ejb2ViewTypeConfigurator(Ejb2xViewType.REMOTE));
        this.ejbRemoteView = view;
    }

    public TransactionManagementType getTransactionManagementType() {
        return this.transactionManagementType;
    }

    public void setTransactionManagementType(TransactionManagementType transactionManagementType) {
        this.transactionManagementType = transactionManagementType;
    }

    public String getEJBName() {
        return this.getComponentName();
    }

    public String getEJBClassName() {
        return this.getComponentClassName();
    }

    protected void setupViewInterceptors(final EJBViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration viewConfiguration) throws DeploymentUnitProcessingException {
                viewConfiguration.addViewInterceptor(LoggingInterceptor.FACTORY, 528);
                ClassLoader classLoader = componentConfiguration.getModuleClassLoader();
                viewConfiguration.addViewInterceptor(AccessCheckingInterceptor.getFactory(), 1);
                viewConfiguration.addViewInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new ContextClassLoaderInterceptor(classLoader)), 3);
                if (view.getMethodIntf() == MethodInterfaceType.Local && EJBLocalObject.class.isAssignableFrom(viewConfiguration.getViewClass())) {
                    viewConfiguration.addViewInterceptor(EjbExceptionTransformingInterceptorFactories.LOCAL_INSTANCE, 512);
                } else if (view.getMethodIntf() == MethodInterfaceType.LocalHome) {
                    viewConfiguration.addViewInterceptor(EjbExceptionTransformingInterceptorFactories.LOCAL_INSTANCE, 512);
                }
                List ejbSetupActions = context.getDeploymentUnit().getAttachmentList(org.jboss.as.ee.component.Attachments.OTHER_EE_SETUP_ACTIONS);
                if (!ejbSetupActions.isEmpty()) {
                    viewConfiguration.addViewInterceptor(AdditionalSetupInterceptor.factory(ejbSetupActions), 1296);
                }
                viewConfiguration.addViewInterceptor(WaitTimeInterceptor.FACTORY, 848);
                viewConfiguration.addViewInterceptor((InterceptorFactory)EJBComponentDescription.this.shutDownInterceptorFactory, 544);
            }
        });
        this.addCurrentInvocationContextFactory(view);
        this.setupSecurityInterceptors(view);
        this.setupRemoteViewInterceptors(view);
        view.getConfigurators().addFirst(new NamespaceViewConfigurator());
    }

    private void setupRemoteViewInterceptors(EJBViewDescription view) {
        if (view.getMethodIntf() == MethodInterfaceType.Remote || view.getMethodIntf() == MethodInterfaceType.Home) {
            view.getConfigurators().add(new ViewConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                    if (Remote.class.isAssignableFrom(configuration.getViewClass())) {
                        configuration.addViewInterceptor(EjbExceptionTransformingInterceptorFactories.REMOTE_INSTANCE, 512);
                    }
                }
            });
            if (view.getMethodIntf() == MethodInterfaceType.Home) {
                view.getConfigurators().add(new ViewConfigurator(){

                    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                        if (Remote.class.isAssignableFrom(configuration.getViewClass())) {
                            String earApplicationName = componentConfiguration.getComponentDescription().getModuleDescription().getEarApplicationName();
                            configuration.setViewInstanceFactory((ViewInstanceFactory)new RemoteHomeViewInstanceFactory(earApplicationName, componentConfiguration.getModuleName(), componentConfiguration.getComponentDescription().getModuleDescription().getDistinctName(), componentConfiguration.getComponentName()));
                        }
                    }
                });
            }
        }
    }

    protected void setupClientViewInterceptors(ViewDescription view) {
        this.addToStringMethodInterceptor(view);
    }

    protected abstract void addCurrentInvocationContextFactory();

    protected abstract void addCurrentInvocationContextFactory(ViewDescription var1);

    protected void addRemoteTransactionsDependency() {
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(final DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration componentConfiguration) throws DeploymentUnitProcessingException {
                if (this.hasRemoteView((EJBComponentDescription)description)) {
                    componentConfiguration.getCreateDependencies().add(new DependencyConfigurator<EJBComponentCreateService>(){

                        public void configureDependency(ServiceBuilder<?> serviceBuilder, EJBComponentCreateService ejbComponentCreateService) throws DeploymentUnitProcessingException {
                            CapabilityServiceSupport support = (CapabilityServiceSupport)context.getDeploymentUnit().getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
                            serviceBuilder.requires(support.getCapabilityServiceName(EJBComponentDescription.REMOTE_TRANSACTION_SERVICE_CAPABILITY_NAME));
                        }
                    });
                }
            }

            private boolean hasRemoteView(EJBComponentDescription ejbComponentDescription) {
                Set views = ejbComponentDescription.getViews();
                for (ViewDescription view : views) {
                    MethodInterfaceType viewType;
                    if (!(view instanceof EJBViewDescription) || (viewType = ((EJBViewDescription)view).getMethodIntf()) != MethodInterfaceType.Remote && viewType != MethodInterfaceType.Home) continue;
                    return true;
                }
                return false;
            }
        });
    }

    protected void addTransactionManagerDependencies() {
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(final DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration componentConfiguration) throws DeploymentUnitProcessingException {
                componentConfiguration.getCreateDependencies().add(new DependencyConfigurator<EJBComponentCreateService>(){

                    public void configureDependency(ServiceBuilder<?> serviceBuilder, EJBComponentCreateService ejbComponentCreateService) throws DeploymentUnitProcessingException {
                        CapabilityServiceSupport support = (CapabilityServiceSupport)context.getDeploymentUnit().getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
                        serviceBuilder.requires(support.getCapabilityServiceName(EJBComponentDescription.TRANSACTION_GLOBAL_DEFAULT_LOCAL_PROVIDER_CAPABILITY_NAME));
                        serviceBuilder.addDependency(support.getCapabilityServiceName(EJBComponentDescription.TRANSACTION_SYNCHRONIZATION_REGISTRY_CAPABILITY_NAME), TransactionSynchronizationRegistry.class, ejbComponentCreateService.getTransactionSynchronizationRegistryInjector());
                    }
                });
            }
        });
    }

    protected void addEJBSuspendHandlerDependency() {
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration componentConfiguration) throws DeploymentUnitProcessingException {
                componentConfiguration.getCreateDependencies().add(new DependencyConfigurator<EJBComponentCreateService>(){

                    public void configureDependency(ServiceBuilder<?> serviceBuilder, EJBComponentCreateService ejbComponentCreateService) throws DeploymentUnitProcessingException {
                        serviceBuilder.addDependency(EJBSuspendHandlerService.SERVICE_NAME, EJBSuspendHandlerService.class, ejbComponentCreateService.getEJBSuspendHandlerInjector());
                    }
                });
            }
        });
    }

    protected void setupSecurityInterceptors(ViewDescription view) {
        view.getConfigurators().add(new EJBSecurityViewConfigurator());
    }

    private void addToStringMethodInterceptor(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                Method TO_STRING_METHOD;
                try {
                    TO_STRING_METHOD = Object.class.getMethod("toString", new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    throw new DeploymentUnitProcessingException((Throwable)nsme);
                }
                List methods = configuration.getProxyFactory().getCachedMethods();
                for (Method method : methods) {
                    if (!TO_STRING_METHOD.equals(method)) continue;
                    configuration.addClientInterceptor(method, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new ToStringMethodInterceptor(EJBComponentDescription.this.getComponentName())), 256);
                    return;
                }
            }
        });
    }

    public boolean isEntity() {
        return false;
    }

    public boolean isMessageDriven() {
        return false;
    }

    public boolean isSession() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isStateful() {
        return false;
    }

    public boolean isStateless() {
        return false;
    }

    public void addDeclaredRoles(String ... roles) {
        this.declaredRoles.addAll(Arrays.asList(roles));
    }

    public void setDeclaredRoles(Collection<String> roles) {
        if (roles == null) {
            throw EjbLogger.ROOT_LOGGER.SecurityRolesIsNull();
        }
        this.declaredRoles.clear();
        this.declaredRoles.addAll(roles);
    }

    public Set<String> getDeclaredRoles() {
        return Collections.unmodifiableSet(this.declaredRoles);
    }

    public void setRunAs(String role) {
        this.runAsRole = role;
    }

    public String getRunAs() {
        return this.runAsRole;
    }

    public void setRunAsPrincipal(String principal) {
        this.runAsPrincipal = principal;
    }

    public String getRunAsPrincipal() {
        return this.runAsPrincipal;
    }

    public void setDefaultSecurityDomain(String defaultSecurityDomain) {
        this.defaultSecurityDomain = defaultSecurityDomain;
    }

    public void setOutflowSecurityDomainsConfigured(BooleanSupplier outflowSecurityDomainsConfigured) {
        this.outflowSecurityDomainsConfigured = outflowSecurityDomainsConfigured;
    }

    public boolean isOutflowSecurityDomainsConfigured() {
        return this.outflowSecurityDomainsConfigured.getAsBoolean();
    }

    public String getResolvedSecurityDomain() {
        if (this.definedSecurityDomain == null) {
            return this.defaultSecurityDomain;
        }
        return this.definedSecurityDomain;
    }

    public void setMissingMethodPermissionsDenyAccess(Boolean missingMethodPermissionsDenyAccess) {
        this.missingMethodPermissionsDenyAccess = missingMethodPermissionsDenyAccess;
    }

    public Boolean isMissingMethodPermissionsDeniedAccess() {
        return this.missingMethodPermissionsDenyAccess;
    }

    public SecurityRolesMetaData getSecurityRoles() {
        return this.securityRoles;
    }

    public void setSecurityRoles(SecurityRolesMetaData securityRoles) {
        this.securityRoles = securityRoles;
    }

    public void setSecurityDomainServiceName(ServiceName securityDomainServiceName) {
        this.securityDomainServiceName = securityDomainServiceName;
    }

    public ServiceName getSecurityDomainServiceName() {
        return this.securityDomainServiceName;
    }

    public void setDefinedSecurityDomain(String definedSecurityDomain) {
        this.definedSecurityDomain = definedSecurityDomain;
    }

    public String getDefinedSecurityDomain() {
        return this.definedSecurityDomain;
    }

    public boolean requiresJacc() {
        return this.requiresJacc;
    }

    public void setRequiresJacc(boolean requiresJacc) {
        this.requiresJacc = requiresJacc;
    }

    public void setLegacyCompliantPrincipalPropagation(boolean legacyCompliantPrincipalPropagation) {
        this.legacyCompliantPrincipalPropagation = legacyCompliantPrincipalPropagation;
    }

    public boolean requiresLegacyCompliantPrincipalPropagation() {
        return this.legacyCompliantPrincipalPropagation;
    }

    public void linkSecurityRoles(String fromRole, String toRole) {
        if (fromRole == null || fromRole.trim().isEmpty()) {
            throw EjbLogger.ROOT_LOGGER.failToLinkFromEmptySecurityRole(fromRole);
        }
        if (toRole == null || toRole.trim().isEmpty()) {
            throw EjbLogger.ROOT_LOGGER.failToLinkToEmptySecurityRole(toRole);
        }
        Collection<String> roleLinks = this.securityRoleLinks.get(fromRole);
        if (roleLinks == null) {
            roleLinks = new HashSet<String>();
            this.securityRoleLinks.put(fromRole, roleLinks);
        }
        roleLinks.add(toRole);
    }

    protected EJBViewDescription registerView(String viewClassName, MethodInterfaceType viewType) {
        return this.registerView(viewClassName, viewType, false);
    }

    protected EJBViewDescription registerView(String viewClassName, MethodInterfaceType viewType, boolean ejb2xView) {
        EJBViewDescription viewDescription = new EJBViewDescription(this, viewClassName, viewType, ejb2xView);
        this.getViews().add(viewDescription);
        this.setupViewInterceptors(viewDescription);
        this.setupClientViewInterceptors(viewDescription);
        if (viewType == MethodInterfaceType.Remote || viewType == MethodInterfaceType.Home) {
            this.setupRemoteView(viewDescription);
        }
        return viewDescription;
    }

    protected void setupRemoteView(EJBViewDescription viewDescription) {
        viewDescription.getConfigurators().add(new ViewConfigurator(){

            public void configure(final DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.getDependencies().add(new DependencyConfigurator<ViewService>(){

                    public void configureDependency(ServiceBuilder<?> serviceBuilder, ViewService service) throws DeploymentUnitProcessingException {
                        CapabilityServiceSupport support = (CapabilityServiceSupport)context.getDeploymentUnit().getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
                        serviceBuilder.requires(support.getCapabilityServiceName("org.wildfly.ejb.remote"));
                    }
                });
            }
        });
    }

    public Map<String, Collection<String>> getSecurityRoleLinks() {
        return Collections.unmodifiableMap(this.securityRoleLinks);
    }

    public boolean hasBeanLevelSecurityMetadata() {
        if (this.definedSecurityDomain != null) {
            return true;
        }
        if (this.runAsRole != null) {
            return true;
        }
        if (this.runAsPrincipal != null) {
            return true;
        }
        if (this.securityRoles != null && !this.securityRoles.isEmpty()) {
            return true;
        }
        if (this.securityRoleLinks != null && !this.securityRoleLinks.isEmpty()) {
            return true;
        }
        return this.declaredRoles != null && !this.declaredRoles.isEmpty();
    }

    public Resource getTimerServiceResource() {
        return this.timerServiceResource;
    }

    public void setTimerServiceResource(Resource timerServiceResource) {
        this.timerServiceResource = timerServiceResource;
    }

    public EnterpriseBeanMetaData getDescriptorData() {
        return this.descriptorData;
    }

    public Method getTimeoutMethod() {
        return this.timeoutMethod;
    }

    public void setTimeoutMethod(Method timeoutMethod) {
        this.timeoutMethod = timeoutMethod;
    }

    public Map<Method, List<AutoTimer>> getScheduleMethods() {
        return Collections.unmodifiableMap(this.scheduleMethods);
    }

    public void addScheduleMethod(Method method, AutoTimer timer) {
        List<AutoTimer> schedules = this.scheduleMethods.get(method);
        if (schedules == null) {
            schedules = new ArrayList<AutoTimer>(1);
            this.scheduleMethods.put(method, schedules);
        }
        schedules.add(timer);
    }

    public EJBViewDescription getEjbLocalView() {
        return this.ejbLocalView;
    }

    public EjbHomeViewDescription getEjbLocalHomeView() {
        return this.ejbLocalHomeView;
    }

    public EjbHomeViewDescription getEjbHomeView() {
        return this.ejbHomeView;
    }

    public EJBViewDescription getEjbRemoteView() {
        return this.ejbRemoteView;
    }

    public boolean isExposedViaIiop() {
        return this.exposedViaIiop;
    }

    public void setExposedViaIiop(boolean exposedViaIiop) {
        this.exposedViaIiop = exposedViaIiop;
    }

    public ApplicableMethodInformation<TransactionAttributeType> getTransactionAttributes() {
        return this.transactionAttributes;
    }

    public ApplicableMethodInformation<Integer> getTransactionTimeouts() {
        return this.transactionTimeouts;
    }

    public ApplicableMethodInformation<EJBMethodSecurityAttribute> getDescriptorMethodPermissions() {
        return this.descriptorMethodPermissions;
    }

    public ApplicableMethodInformation<EJBMethodSecurityAttribute> getAnnotationMethodPermissions() {
        return this.annotationMethodPermissions;
    }

    public void setDefaultContainerInterceptors(List<InterceptorDescription> defaultInterceptors) {
        this.defaultContainerInterceptors = defaultInterceptors;
    }

    public List<InterceptorDescription> getDefaultContainerInterceptors() {
        return this.defaultContainerInterceptors;
    }

    public void setClassLevelContainerInterceptors(List<InterceptorDescription> containerInterceptors) {
        this.classLevelContainerInterceptors = containerInterceptors;
    }

    public List<InterceptorDescription> getClassLevelContainerInterceptors() {
        return this.classLevelContainerInterceptors;
    }

    public void setExcludeDefaultContainerInterceptors(boolean excludeDefaultContainerInterceptors) {
        this.excludeDefaultContainerInterceptors = excludeDefaultContainerInterceptors;
    }

    public boolean isExcludeDefaultContainerInterceptors() {
        return this.excludeDefaultContainerInterceptors;
    }

    public void excludeDefaultContainerInterceptors(MethodIdentifier methodIdentifier) {
        this.excludeDefaultContainerInterceptorsForMethod.put(methodIdentifier, true);
    }

    public boolean isExcludeDefaultContainerInterceptors(MethodIdentifier methodIdentifier) {
        return this.excludeDefaultContainerInterceptorsForMethod.get(methodIdentifier) != null;
    }

    public void excludeClassLevelContainerInterceptors(MethodIdentifier methodIdentifier) {
        this.excludeClassLevelContainerInterceptorsForMethod.put(methodIdentifier, true);
    }

    public boolean isExcludeClassLevelContainerInterceptors(MethodIdentifier methodIdentifier) {
        return this.excludeClassLevelContainerInterceptorsForMethod.get(methodIdentifier) != null;
    }

    public Map<MethodIdentifier, List<InterceptorDescription>> getMethodLevelContainerInterceptors() {
        return this.methodLevelContainerInterceptors;
    }

    public void setMethodContainerInterceptors(MethodIdentifier methodIdentifier, List<InterceptorDescription> containerInterceptors) {
        this.methodLevelContainerInterceptors.put(methodIdentifier, containerInterceptors);
    }

    public Set<MethodIdentifier> getTimerMethods() {
        HashSet<MethodIdentifier> methods = new HashSet<MethodIdentifier>();
        if (this.timeoutMethod != null) {
            methods.add(MethodIdentifier.getIdentifierForMethod((Method)this.timeoutMethod));
        }
        for (Method method : this.scheduleMethods.keySet()) {
            methods.add(MethodIdentifier.getIdentifierForMethod((Method)method));
        }
        return methods;
    }

    public Set<InterceptorDescription> getAllContainerInterceptors() {
        if (this.allContainerInterceptors == null) {
            this.allContainerInterceptors = new HashSet<InterceptorDescription>();
            this.allContainerInterceptors.addAll(this.classLevelContainerInterceptors);
            if (!this.excludeDefaultContainerInterceptors) {
                this.allContainerInterceptors.addAll(this.defaultContainerInterceptors);
            }
            for (List<InterceptorDescription> interceptors : this.methodLevelContainerInterceptors.values()) {
                this.allContainerInterceptors.addAll(interceptors);
            }
        }
        return this.allContainerInterceptors;
    }

    public ServerInterceptorCache getServerInterceptorCache() {
        return this.serverInterceptorCache;
    }

    public void setServerInterceptorCache(ServerInterceptorCache serverInterceptorCache) {
        this.serverInterceptorCache = serverInterceptorCache;
    }

    public ShutDownInterceptorFactory getShutDownInterceptorFactory() {
        return this.shutDownInterceptorFactory;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "{serviceName=" + this.getServiceName() + "}@" + Integer.toHexString(((Object)((Object)this)).hashCode());
    }

    public HashMap<Integer, InterceptorFactory> getElytronInterceptorFactories(String policyContextID, boolean enableJacc, boolean propagateSecurity) {
        Map principalVsRolesMap;
        HashMap<Integer, InterceptorFactory> interceptorFactories = new HashMap<Integer, InterceptorFactory>(2);
        HashSet<String> roles = new HashSet<String>();
        interceptorFactories.put(592, SecurityDomainInterceptorFactory.INSTANCE);
        if (enableJacc) {
            interceptorFactories.put(608, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new PolicyContextIdInterceptor(policyContextID)));
        }
        if (this.securityRoles != null && !(principalVsRolesMap = this.securityRoles.getPrincipalVersusRolesMap()).isEmpty()) {
            interceptorFactories.put(624, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new SecurityRolesAddingInterceptor("ejb", principalVsRolesMap)));
        }
        if (this.runAsPrincipal != null) {
            Set extraRoles;
            interceptorFactories.put(784, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new RunAsPrincipalInterceptor(this.runAsPrincipal)));
            if (this.securityRoles != null && !(extraRoles = this.securityRoles.getSecurityRoleNamesByPrincipal(this.runAsPrincipal)).isEmpty()) {
                interceptorFactories.put(800, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new RoleAddingInterceptor("ejb", RoleMapper.constant((Roles)Roles.fromSet((Set)extraRoles)))));
                roles.addAll(extraRoles);
            }
        } else if (!propagateSecurity) {
            interceptorFactories.put(784, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new RunAsPrincipalInterceptor("anonymous")));
        }
        if (this.runAsRole != null) {
            interceptorFactories.put(816, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new RoleAddingInterceptor("ejb", RoleMapper.constant((Roles)Roles.fromSet(Collections.singleton(this.runAsRole))))));
            roles.add(this.runAsRole);
        }
        if (!roles.isEmpty()) {
            interceptorFactories.put(832, (InterceptorFactory)new IdentityOutflowInterceptorFactory("ejb", RoleMapper.constant((Roles)Roles.fromSet(roles))));
        } else {
            interceptorFactories.put(832, IdentityOutflowInterceptorFactory.INSTANCE);
        }
        RoleMapper.constant((Roles)Roles.fromSet(this.getDeclaredRoles()));
        return interceptorFactories;
    }

    public void setSecurityRequired(boolean securityRequired) {
        this.securityRequired = securityRequired;
    }

    public boolean isSecurityRequired() {
        return this.securityRequired;
    }

    private static final class EjbJarConfigurationConfigurator
    implements ComponentConfigurator {
        private EjbJarConfigurationConfigurator() {
        }

        public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
            DeploymentUnit deploymentUnit = context.getDeploymentUnit();
            ApplicationExceptions appExceptions = (ApplicationExceptions)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.APPLICATION_EXCEPTION_DETAILS);
            if (appExceptions == null) {
                throw EjbLogger.ROOT_LOGGER.ejbJarConfigNotFound(deploymentUnit);
            }
            EJBComponentCreateServiceFactory ejbComponentCreateServiceFactory = (EJBComponentCreateServiceFactory)configuration.getComponentCreateServiceFactory();
            ejbComponentCreateServiceFactory.setEjbJarConfiguration(appExceptions);
        }
    }

    private static final class SecurityDomainDependencyConfigurator
    implements ComponentConfigurator {
        private final EJBComponentDescription ejbComponentDescription;

        SecurityDomainDependencyConfigurator(EJBComponentDescription ejbComponentDescription) {
            this.ejbComponentDescription = ejbComponentDescription;
        }

        public void configure(final DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
            configuration.getCreateDependencies().add(new DependencyConfigurator<Service<Component>>(){

                public void configureDependency(ServiceBuilder<?> serviceBuilder, Service<Component> service) throws DeploymentUnitProcessingException {
                    EJBComponentCreateService ejbComponentCreateService = (EJBComponentCreateService)service;
                    if (ejbComponentDescription.getSecurityDomainServiceName() != null) {
                        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
                        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
                        serviceBuilder.addDependency(ejbComponentDescription.getSecurityDomainServiceName(), SecurityDomain.class, ejbComponentCreateService.getSecurityDomainInjector());
                        if (ejbComponentDescription.isOutflowSecurityDomainsConfigured()) {
                            serviceBuilder.addDependency(support.getCapabilityServiceName("org.wildfly.ejb3.identity"), Function.class, ejbComponentCreateService.getIdentityOutflowFunctionInjector());
                        }
                    } else {
                        String securityDomainName = ejbComponentDescription.getResolvedSecurityDomain();
                        if (securityDomainName != null && !securityDomainName.isEmpty()) {
                            throw EjbLogger.ROOT_LOGGER.legacySecurityUnsupported(securityDomainName);
                        }
                    }
                }
            });
        }
    }

    private static class Ejb2ViewTypeConfigurator
    implements ViewConfigurator {
        private final Ejb2xViewType local;

        public Ejb2ViewTypeConfigurator(Ejb2xViewType local) {
            this.local = local;
        }

        public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
            configuration.putPrivateData(Ejb2xViewType.class, (Object)this.local);
        }
    }

    private static class ToStringMethodInterceptor
    implements Interceptor {
        private final String name;

        public ToStringMethodInterceptor(String name) {
            this.name = name;
        }

        public Object processInvocation(InterceptorContext context) throws Exception {
            ComponentView componentView = (ComponentView)context.getPrivateData(ComponentView.class);
            if (componentView == null) {
                throw EjbLogger.ROOT_LOGGER.componentViewNotAvailableInContext(context);
            }
            return "Proxy for view class: " + componentView.getViewClass().getName() + " of EJB: " + this.name;
        }
    }
}

