/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.PropertiesAttributeDefinition;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.controller.validation.ModuleIdentifierValidatorBuilder;
import org.jboss.as.clustering.jgroups.ProtocolDefaults;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.common.function.Functions;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public abstract class AbstractProtocolResourceDefinition<P extends Protocol, C extends ProtocolConfiguration<P>>
extends ChildResourceDefinition<ManagementResourceRegistration>
implements ResourceServiceConfigurator,
ResourceModelResolver<Map.Entry<Function<ProtocolConfiguration<P>, C>, Consumer<RequirementServiceBuilder<?>>>> {
    private final RuntimeCapability<Void> capability;
    private final UnaryOperator<ResourceDescriptor> resourceConfigurator;
    private final ResourceServiceConfigurator parentServiceConfigurator;

    AbstractProtocolResourceDefinition(SimpleResourceDefinition.Parameters parameters, RuntimeCapability<Void> capability, UnaryOperator<ResourceDescriptor> resourceConfigurator, ResourceServiceConfigurator parentServiceConfigurator) {
        super(parameters);
        this.capability = capability;
        this.resourceConfigurator = resourceConfigurator;
        this.parentServiceConfigurator = parentServiceConfigurator;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = ((ResourceDescriptor)this.resourceConfigurator.apply(new ResourceDescriptor(this.getResourceDescriptionResolver()))).addCapabilities(List.of(this.capability)).addAttributes(Attribute.class);
        ArrayList<ResourceOperationRuntimeHandler> handlers = new ArrayList<ResourceOperationRuntimeHandler>(2);
        handlers.add(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this));
        if (this.parentServiceConfigurator != null) {
            handlers.add(ResourceOperationRuntimeHandler.restartParent((ResourceOperationRuntimeHandler)ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this.parentServiceConfigurator)));
        }
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of(handlers)).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String name = context.getCurrentAddressValue();
        Boolean statisticsEnabled = Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBooleanOrNull();
        final String moduleName = Attribute.MODULE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        boolean nativeProtocol = moduleName.equals(Attribute.MODULE.getDefinition().getDefaultValue().asString()) && !name.startsWith("org.jgroups.protocols.");
        Object className = nativeProtocol ? "org.jgroups.protocols." + name : name;
        TreeMap<String, String> properties = new TreeMap<String, String>();
        for (Property property : Attribute.PROPERTIES.resolveModelAttribute((ExpressionResolver)context, model).asPropertyListOrEmpty()) {
            properties.put(property.getName(), property.getValue().asString());
        }
        final ServiceDependency loader = ServiceDependency.on((ServiceName)Services.JBOSS_SERVICE_MODULE_LOADER);
        ServiceDependency defaults = ServiceDependency.on((ServiceName)ProtocolDefaults.SERVICE_NAME);
        ProtocolConfiguration configuration = new ProtocolConfiguration<P>((String)className, defaults, properties, statisticsEnabled){
            final /* synthetic */ String val$className;
            final /* synthetic */ ServiceDependency val$defaults;
            final /* synthetic */ Map val$properties;
            final /* synthetic */ Boolean val$statisticsEnabled;
            {
                this.val$className = string3;
                this.val$defaults = serviceDependency2;
                this.val$properties = map;
                this.val$statisticsEnabled = bl;
            }

            public String getName() {
                return name;
            }

            public P createProtocol(ProtocolStackConfiguration stackConfiguration) {
                try {
                    Module module = ((ModuleLoader)loader.get()).loadModule(moduleName);
                    final Class<Protocol> protocolClass = module.getClassLoader().loadClass(this.val$className).asSubclass(Protocol.class);
                    final HashMap<String, String> protocolProperties = new HashMap<String, String>(((ProtocolDefaults)this.val$defaults.get()).getProperties(protocolClass));
                    protocolProperties.putAll(this.val$properties);
                    PrivilegedExceptionAction<Protocol> action = new PrivilegedExceptionAction<Protocol>(){

                        @Override
                        public Protocol run() throws Exception {
                            try {
                                Protocol protocol = (Protocol)protocolClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                                HashMap copy = new HashMap(protocolProperties);
                                StackType type = Util.getIpStackType();
                                Configurator.resolveAndAssignFields((Object)protocol, copy, (StackType)type);
                                Configurator.resolveAndInvokePropertyMethods((Object)protocol, copy, (StackType)type);
                                List objects = protocol.getComponents();
                                if (objects != null) {
                                    for (Object object : objects) {
                                        Configurator.resolveAndAssignFields(object, copy, (StackType)type);
                                        Configurator.resolveAndInvokePropertyMethods(object, copy, (StackType)type);
                                    }
                                }
                                if (!copy.isEmpty()) {
                                    for (String property : copy.keySet()) {
                                        JGroupsLogger.ROOT_LOGGER.unrecognizedProtocolProperty(name, property);
                                    }
                                }
                                return protocol;
                            }
                            catch (IllegalAccessException | InstantiationException e) {
                                throw new IllegalStateException(e);
                            }
                        }
                    };
                    Protocol protocol = (Protocol)WildFlySecurityManager.doUnchecked((PrivilegedExceptionAction)action);
                    protocol.enableStats(this.val$statisticsEnabled != null ? this.val$statisticsEnabled.booleanValue() : stackConfiguration.isStatisticsEnabled());
                    return protocol;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        Map.Entry entry = (Map.Entry)this.resolve(context, model);
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(this.capability, (Function)((Function)entry.getKey()), (Supplier)Functions.constantSupplier((Object)configuration)).blocking()).requires(List.of(loader, defaults, (Consumer)entry.getValue()))).build();
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        MODULE("module", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setDefaultValue(new ModelNode("org.jgroups"))).setValidator(new ModuleIdentifierValidatorBuilder().configure((AbstractAttributeDefinitionBuilder)builder).build());
            }
        }
        ,
        PROPERTIES("properties"),
        STATISTICS_ENABLED("statistics-enabled", ModelType.BOOLEAN);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        private Attribute(String name) {
            this.definition = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder(name).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }

    static class ProtocolConfigurationDecorator<P extends Protocol>
    implements ProtocolConfiguration<P> {
        private final ProtocolConfiguration<P> configuration;

        ProtocolConfigurationDecorator(ProtocolConfiguration<P> configuration) {
            this.configuration = configuration;
        }

        public String getName() {
            return this.configuration.getName();
        }

        public P createProtocol(ProtocolStackConfiguration stackConfiguration) {
            return (P)this.configuration.createProtocol(stackConfiguration);
        }

        public Map<String, SocketBinding> getSocketBindings() {
            return this.configuration.getSocketBindings();
        }

        void setValue(P protocol, String propertyName, Object propertyValue) {
            PrivilegedAction action = new PrivilegedAction<P>((Protocol)protocol, propertyName, propertyValue){
                final /* synthetic */ Protocol val$protocol;
                final /* synthetic */ String val$propertyName;
                final /* synthetic */ Object val$propertyValue;
                {
                    this.val$protocol = protocol;
                    this.val$propertyName = string;
                    this.val$propertyValue = object;
                }

                @Override
                public P run() {
                    return this.val$protocol.setValue(this.val$propertyName, this.val$propertyValue);
                }
            };
            WildFlySecurityManager.doUnchecked((PrivilegedAction)action);
        }
    }
}

