/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.extensions.db2;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.jca.adapters.jdbc.spi.ExceptionSorter;
import org.jboss.logging.Logger;

public class DB2ExceptionSorter
implements ExceptionSorter,
Serializable {
    private static Logger logger = Logger.getLogger(DB2ExceptionSorter.class);
    private static final long serialVersionUID = -4724550353693159378L;
    private boolean consider99999Fatal = false;
    private Set<String> fatalSet = new HashSet<String>();

    public DB2ExceptionSorter() {
        this.fatalSet.add("CONNECTION IS CLOSED");
    }

    public void setConsider99999Fatal(String value) {
        this.consider99999Fatal = Boolean.parseBoolean(value);
    }

    public void setFatal99999Messages(String messages) {
        StringTokenizer st = new StringTokenizer(messages, ",");
        while (st.hasMoreTokens()) {
            this.fatalSet.add(st.nextToken().trim().toUpperCase());
        }
    }

    @Override
    public boolean isExceptionFatal(SQLException e) {
        int code = Math.abs(e.getErrorCode());
        boolean isFatal = false;
        if (code == 4470) {
            isFatal = true;
        } else if (code == 4499) {
            isFatal = true;
        } else if (code == 99999 && this.consider99999Fatal) {
            isFatal = true;
        } else if (code == 99999 && !this.consider99999Fatal && !this.fatalSet.isEmpty()) {
            String errorText = e.getMessage().trim().toUpperCase();
            for (String message : this.fatalSet) {
                if (!errorText.contains(message)) continue;
                isFatal = true;
            }
        }
        logger.tracev("Evaluated SQL error code %d isException returned %b", (Object)code, (Object)isFatal);
        return isFatal;
    }
}

