/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.jts;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
import com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.internal.jta.resources.jts.CleanupSynchronization;
import com.arjuna.ats.internal.jta.resources.jts.LocalCleanupSynchronization;
import com.arjuna.ats.internal.jta.resources.jts.orbspecific.LastResourceRecord;
import com.arjuna.ats.internal.jta.resources.jts.orbspecific.ManagedSynchronizationImple;
import com.arjuna.ats.internal.jta.resources.jts.orbspecific.SynchronizationImple;
import com.arjuna.ats.internal.jta.resources.jts.orbspecific.XAResourceRecord;
import com.arjuna.ats.internal.jta.transaction.jts.AtomicTransaction;
import com.arjuna.ats.internal.jta.utils.XAUtils;
import com.arjuna.ats.internal.jta.utils.jtaxLogger;
import com.arjuna.ats.internal.jta.utils.jts.StatusConverter;
import com.arjuna.ats.internal.jta.xa.TxInfo;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.exceptions.InactiveTransactionException;
import com.arjuna.ats.jta.exceptions.InvalidTerminationStateException;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.resources.LastResourceCommitOptimisation;
import com.arjuna.ats.jta.transaction.Transaction;
import com.arjuna.ats.jta.utils.JTAHelper;
import com.arjuna.ats.jta.utils.XAHelper;
import com.arjuna.ats.jta.xa.XAModifier;
import com.arjuna.ats.jta.xa.XidImple;
import com.arjuna.ats.jts.extensions.Arjuna;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.WrongTransaction;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.SynchronizationUnavailable;

public class TransactionImple
implements jakarta.transaction.Transaction,
Transaction {
    protected AtomicTransaction _theTransaction;
    private Hashtable _resources;
    private Hashtable _duplicateResources;
    private int _suspendCount;
    private final boolean _xaTransactionTimeoutEnabled;
    private Map _txLocalResources;
    private Throwable _rollbackOnlyCallerStacktrace;
    private static final boolean XA_TRANSACTION_TIMEOUT_ENABLED = jtaPropertyManager.getJTAEnvironmentBean().isXaTransactionTimeoutEnabled();
    private static final Class LAST_RESOURCE_OPTIMISATION_INTERFACE = jtaPropertyManager.getJTAEnvironmentBean().getLastResourceOptimisationInterface();
    private static ConcurrentHashMap _transactions;
    private static final boolean STRICTJTA12DUPLICATEXAENDPROTOERR;

    public TransactionImple() throws SubtransactionsUnavailable {
        block5: {
            this(new AtomicTransaction());
            this._theTransaction.begin();
            try {
                TwoPhaseCoordinator theTx = null;
                try {
                    theTx = (TwoPhaseCoordinator)BasicAction.Current();
                    if (theTx != null) {
                        theTx.addSynchronization(new LocalCleanupSynchronization(this));
                        break block5;
                    }
                    this.registerSynchronization(new CleanupSynchronization(this));
                }
                catch (ClassCastException ex) {
                    this.registerSynchronization(new CleanupSynchronization(this));
                }
            }
            catch (Exception ex) {
                jtaxLogger.i18NLogger.warn_jtax_transaction_jts_syncproblem(ex);
            }
        }
    }

    public boolean equals(Object obj) {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"TransactionImple.equals");
        }
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof TransactionImple && this._theTransaction != null) {
            return this._theTransaction.equals(((TransactionImple)obj)._theTransaction);
        }
        return false;
    }

    public int hashCode() {
        if (this._theTransaction != null) {
            return this._theTransaction.hashCode();
        }
        return -1;
    }

    public ControlWrapper getControlWrapper() {
        if (this._theTransaction != null) {
            return this._theTransaction.getControlWrapper();
        }
        return null;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException, IllegalStateException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"TransactionImple.commit");
        }
        if (this._theTransaction != null) {
            try {
                if (this.getStatus() != 0 && this.getStatus() != 1) {
                    throw new NoTransaction();
                }
                if (!this.endSuspendedRMs()) {
                    this._theTransaction.rollbackOnly();
                }
                this._theTransaction.end(true);
            }
            catch (WrongTransaction wt) {
                jtaxLogger.i18NLogger.warn_get_jtax_transaction_jts_wrongstatetx(this._theTransaction, (Exception)((Object)wt));
                InactiveTransactionException inactiveTransactionException = new InactiveTransactionException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_wrongstatetx());
                inactiveTransactionException.initCause(wt);
                throw inactiveTransactionException;
            }
            catch (NoTransaction e1) {
                IllegalStateException illegalStateException = new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_notx());
                illegalStateException.initCause((Throwable)((Object)e1));
                throw illegalStateException;
            }
            catch (HeuristicMixed e2) {
                HeuristicMixedException heuristicMixedException = new HeuristicMixedException();
                heuristicMixedException.initCause((Throwable)((Object)e2));
                throw heuristicMixedException;
            }
            catch (HeuristicHazard e3) {
                HeuristicMixedException heuristicMixedException = new HeuristicMixedException();
                heuristicMixedException.initCause((Throwable)((Object)e3));
                throw heuristicMixedException;
            }
            catch (TRANSACTION_ROLLEDBACK e4) {
                RollbackException rollbackException = new RollbackException(e4.toString());
                rollbackException.initCause((Throwable)e4);
                throw rollbackException;
            }
            catch (NO_PERMISSION e5) {
                throw new SecurityException(e5);
            }
            catch (INVALID_TRANSACTION e6) {
                InactiveTransactionException inactiveTransactionException = new InactiveTransactionException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_invalidtx2());
                inactiveTransactionException.initCause(e6);
                throw inactiveTransactionException;
            }
            catch (org.omg.CORBA.SystemException e7) {
                SystemException systemException = new SystemException(e7.toString());
                systemException.initCause((Throwable)e7);
                throw systemException;
            }
            finally {
                TransactionImple.removeTransaction(this);
            }
        } else {
            throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_inactivetx());
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"TransactionImple.rollback");
        }
        boolean endSuspendedFailed = false;
        if (this._theTransaction != null) {
            try {
                if (this.getStatus() != 0 && this.getStatus() != 1) {
                    throw new NoTransaction();
                }
                boolean bl = endSuspendedFailed = !this.endSuspendedRMs();
                if (endSuspendedFailed) {
                    jtaxLogger.i18NLogger.warn_jtax_transaction_jts_endsuspendfailed1();
                }
                this._theTransaction.abort();
            }
            catch (WrongTransaction e1) {
                InactiveTransactionException inactiveTransactionException = new InactiveTransactionException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_wrongstatetx());
                inactiveTransactionException.initCause(e1);
                throw inactiveTransactionException;
            }
            catch (NO_PERMISSION e2) {
                throw new SecurityException(e2);
            }
            catch (INVALID_TRANSACTION e3) {
                InactiveTransactionException inactiveTransactionException = new InactiveTransactionException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_invalidtx2());
                inactiveTransactionException.initCause(e3);
                throw inactiveTransactionException;
            }
            catch (NoTransaction e4) {
                throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_notx(), (Throwable)((Object)e4));
            }
            catch (org.omg.CORBA.SystemException e5) {
                SystemException systemException = new SystemException(e5.toString());
                systemException.initCause((Throwable)e5);
                throw systemException;
            }
            finally {
                TransactionImple.removeTransaction(this);
            }
            if (endSuspendedFailed) {
                throw new InvalidTerminationStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_endsuspendfailed2());
            }
        } else {
            throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_inactivetx());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"TransactionImple.setRollbackOnly");
        }
        if (this._theTransaction == null) throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_inactivetx());
        try {
            this._theTransaction.rollbackOnly();
            if (this._rollbackOnlyCallerStacktrace != null) return;
            this._rollbackOnlyCallerStacktrace = new Throwable(jtaxLogger.i18NLogger.get_jtax_transaction_jts_notx());
            return;
        }
        catch (NoTransaction e3) {
            throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_notx(), (Throwable)((Object)e3));
        }
        catch (INVALID_TRANSACTION ex) {
            switch (this.getStatus()) {
                case 4: 
                case 9: {
                    return;
                }
                case 2: 
                case 7: {
                    throw new InvalidTerminationStateException(jtaLogger.i18NLogger.get_transaction_arjunacore_invalidstate());
                }
                default: {
                    throw new InactiveTransactionException(jtaLogger.i18NLogger.get_transaction_arjunacore_inactive());
                }
            }
        }
        catch (org.omg.CORBA.SystemException e4) {
            SystemException systemException = new SystemException(e4.toString());
            systemException.initCause((Throwable)e4);
            throw systemException;
        }
    }

    public int getStatus() throws SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"TransactionImple.getStatus");
        }
        int status = 6;
        if (this._theTransaction != null) {
            try {
                status = StatusConverter.convert(this._theTransaction.get_status());
            }
            catch (org.omg.CORBA.SystemException e2) {
                SystemException systemException = new SystemException(e2.toString());
                systemException.initCause((Throwable)e2);
                throw systemException;
            }
        }
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("TransactionImple.getStatus: " + JTAHelper.stringForm(status)));
        }
        return status;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (sync == null) {
            throw new SystemException("TransactionImple.registerSynchronization - " + jtaxLogger.i18NLogger.get_jtax_transaction_jts_nullparam());
        }
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)("TransactionImple.registerSynchronization - Class: " + String.valueOf(sync.getClass()) + " HashCode: " + sync.hashCode() + " toString: " + String.valueOf(sync)));
        }
        this.registerSynchronizationImple(new ManagedSynchronizationImple(sync));
    }

    void registerSynchronizationImple(SynchronizationImple synchronizationImple) throws RollbackException, IllegalStateException, SystemException {
        if (this._theTransaction != null) {
            try {
                this._theTransaction.registerSynchronization(synchronizationImple.getSynchronization());
            }
            catch (TRANSACTION_ROLLEDBACK e2) {
                RollbackException rollbackException = new RollbackException(e2.toString());
                rollbackException.initCause((Throwable)e2);
                throw rollbackException;
            }
            catch (Inactive e3) {
                throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_inactivetx(), (Throwable)((Object)e3));
            }
            catch (SynchronizationUnavailable e4) {
                throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_syncerror(), (Throwable)((Object)e4));
            }
            catch (INVALID_TRANSACTION e5) {
                throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_invalidtx2(), e5);
            }
            catch (org.omg.CORBA.SystemException e6) {
                SystemException systemException = new SystemException(e6.toString());
                systemException.initCause((Throwable)e6);
                throw systemException;
            }
        } else {
            throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_inactivetx());
        }
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        return this.enlistResource(xaRes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enlistResource(XAResource xaRes, Object[] params) throws RollbackException, IllegalStateException, SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)("TransactionImple.enlistResource ( " + String.valueOf(xaRes) + " )"));
        }
        if (xaRes == null) {
            throw new SystemException("TransactionImple.enlistResource - " + jtaxLogger.i18NLogger.get_jtax_transaction_jts_nullparam());
        }
        int status = this.getStatus();
        switch (status) {
            case 1: {
                throw new RollbackException("TransactionImple.enlistResource - " + jtaxLogger.i18NLogger.get_jtax_transaction_jts_markedrollback());
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_inactivetx());
            }
        }
        XAModifier theModifier = null;
        if (params != null && params.length > 1 && params[1] instanceof XAModifier) {
            theModifier = (XAModifier)params[1];
        }
        try {
            block49: {
                TxInfo info = null;
                try {
                    TransactionImple transactionImple = this;
                    synchronized (transactionImple) {
                        info = (TxInfo)this._resources.get(xaRes);
                        if (info == null) {
                            info = (TxInfo)this._duplicateResources.get(xaRes);
                        }
                    }
                    if (info == null) break block49;
                    switch (info.getState()) {
                        case 2: {
                            xaRes.start(info.xid(), 0x8000000);
                            info.setState(0);
                            transactionImple = this;
                            synchronized (transactionImple) {
                                --this._suspendCount;
                            }
                            return true;
                        }
                        case 0: {
                            return true;
                        }
                        case 1: {
                            xaRes.start(info.xid(), 0x200000);
                            info.setState(0);
                            return true;
                        }
                    }
                    throw new IllegalStateException("TransactionImple.enlistResource - " + jtaxLogger.i18NLogger.get_jtax_transaction_jts_illegalstate() + info.getState());
                }
                catch (IllegalStateException ex) {
                    throw ex;
                }
                catch (XAException exp) {
                    if (info != null) {
                        info.setState(3);
                    }
                    jtaxLogger.i18NLogger.warn_jtax_transaction_jts_xaerror("TransactionImple.enlistResource", XAHelper.printXAErrorCode(exp), exp);
                    return false;
                }
            }
            Xid xid = null;
            TxInfo existingRM = this.isNewRM(xaRes);
            if (existingRM == null) {
                boolean branchRequired = true;
                TransactionImple transactionImple = this;
                synchronized (transactionImple) {
                    if (this._resources.isEmpty()) {
                        branchRequired = true;
                    }
                }
                xid = this.createXid(branchRequired, theModifier);
                boolean associatedWork = false;
                int retry = 20;
                while (!associatedWork) {
                    try {
                        XAResourceRecord xaResourceRecord;
                        int timeout;
                        if (this._xaTransactionTimeoutEnabled && (timeout = this._theTransaction.getTimeout()) > 0) {
                            try {
                                xaRes.setTransactionTimeout(timeout);
                            }
                            catch (XAException te) {
                                jtaxLogger.i18NLogger.warn_jtax_transaction_jts_timeouterror("TransactionImple.enlistResource", XAHelper.printXAErrorCode(te), XAHelper.xidToString(xid), te);
                            }
                        }
                        if ((xaResourceRecord = this.createRecord(xaRes, params, xid)) != null) {
                            xaRes.start(xid, 0);
                            try {
                                RecoveryCoordinator recCoord = this._theTransaction.registerResource(xaResourceRecord.getResource());
                                xaResourceRecord.setRecoveryCoordinator(recCoord);
                                if (jtaxLogger.logger.isTraceEnabled()) {
                                    jtaxLogger.logger.tracef("TransactionImple.enlistResource: resource_trace: txn uid=%s XAReource=%s resource uid=%s\n", (Object)this.get_uid(), (Object)xaRes, (Object)xaResourceRecord.get_uid());
                                }
                            }
                            catch (Exception e) {
                                xaResourceRecord.rollback();
                                this.markRollbackOnly();
                                jtaxLogger.logger.debug((Object)("Can't set recovery coordinator for xa resource record: " + String.valueOf(xaResourceRecord) + ", " + e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
                                return false;
                            }
                            this._resources.put(xaRes, new TxInfo(xid));
                            return true;
                        }
                        this.markRollbackOnly();
                        return false;
                    }
                    catch (XAException e) {
                        if (e.errorCode == -3) {
                            if (retry > 0) {
                                xid = this.createXid(true, theModifier);
                            }
                            --retry;
                        } else if (e.errorCode == -8) {
                            if (retry > 0) {
                                xid = this.createXid(true, theModifier);
                            }
                            --retry;
                        } else {
                            jtaxLogger.i18NLogger.warn_jtax_transaction_jts_starterror("TransactionImple.enlistResource - XAResource.start", XAHelper.printXAErrorCode(e), XAHelper.xidToString(xid), e);
                            this.markRollbackOnly();
                            throw e;
                        }
                        if (retry >= 0) continue;
                        jtaxLogger.i18NLogger.warn_jtax_transaction_jts_starterror("TransactionImple.enlistResource - XAResource.start", XAHelper.printXAErrorCode(e), XAHelper.xidToString(xid), e);
                        this.markRollbackOnly();
                        throw new UNKNOWN();
                    }
                }
            } else {
                xid = existingRM.xid();
                try {
                    xaRes.start(xid, 0x200000);
                }
                catch (XAException ex) {
                    jtaxLogger.i18NLogger.warn_jtax_transaction_jts_xaerror("TransactionImple.enlistResource - xa_start: ", XAHelper.printXAErrorCode(ex), ex);
                    this.markRollbackOnly();
                    throw ex;
                }
                this._duplicateResources.put(xaRes, new TxInfo(xid));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            jtaxLogger.i18NLogger.warn_could_not_enlist_xar(xaRes, params, e);
            this.markRollbackOnly();
            return false;
        }
    }

    private XAResourceRecord createRecord(XAResource xaRes, Object[] params, Xid xid) {
        XAResourceRecord record = xaRes instanceof LastResourceCommitOptimisation || LAST_RESOURCE_OPTIMISATION_INTERFACE != null && LAST_RESOURCE_OPTIMISATION_INTERFACE.isInstance(xaRes) ? new LastResourceRecord(this, xaRes, xid, params) : new XAResourceRecord(this, xaRes, xid, params);
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delistResource(XAResource xaRes, int flags) throws IllegalStateException, SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)("TransactionImple.delistResource ( " + String.valueOf(xaRes) + ", " + flags + " )"));
        }
        if (xaRes == null) {
            throw new SystemException("TransactionImple.delistResource - " + jtaxLogger.i18NLogger.get_jtax_transaction_jts_nullparam());
        }
        int status = this.getStatus();
        switch (status) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_inactivetx());
            }
        }
        TxInfo info = null;
        try {
            TransactionImple transactionImple = this;
            synchronized (transactionImple) {
                info = (TxInfo)this._resources.get(xaRes);
                if (info == null) {
                    info = (TxInfo)this._duplicateResources.get(xaRes);
                }
            }
            if (info == null) {
                jtaxLogger.i18NLogger.warn_jtax_transaction_jts_unknownres("TransactionImple.delistResource");
                return false;
            }
            boolean optimizedRollback = false;
            try {
                if (status == 1 && XAUtils.canOptimizeDelist(xaRes)) {
                    xaRes.end(info.xid(), 0x20000000);
                    xaRes.rollback(info.xid());
                    info.setState(4);
                    optimizedRollback = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (info.getState()) {
                case 0: {
                    if ((flags & 0x4000000) != 0) {
                        xaRes.end(info.xid(), 0x4000000);
                        info.setState(1);
                        break;
                    }
                    if ((flags & 0x2000000) != 0) {
                        xaRes.end(info.xid(), 0x2000000);
                        info.setState(2);
                        TransactionImple transactionImple2 = this;
                        synchronized (transactionImple2) {
                            ++this._suspendCount;
                            break;
                        }
                    }
                    xaRes.end(info.xid(), 0x20000000);
                    info.setState(3);
                    break;
                }
                case 2: {
                    if ((flags & 0x4000000) != 0) {
                        if (XAUtils.mustEndSuspendedRMs(xaRes)) {
                            xaRes.start(info.xid(), 0x8000000);
                        }
                        xaRes.end(info.xid(), 0x4000000);
                        info.setState(1);
                        TransactionImple transactionImple3 = this;
                        synchronized (transactionImple3) {
                            --this._suspendCount;
                            break;
                        }
                    }
                    if ((flags & 0x2000000) != 0) {
                        throw new IllegalStateException("TransactionImple.delistResource - " + jtaxLogger.i18NLogger.get_jtax_transaction_jts_ressusp());
                    }
                    xaRes.end(info.xid(), 0x20000000);
                    info.setState(3);
                    TransactionImple transactionImple4 = this;
                    synchronized (transactionImple4) {
                        --this._suspendCount;
                        break;
                    }
                }
                default: {
                    if (optimizedRollback) break;
                    throw new IllegalStateException("TransactionImple.delistResource - " + jtaxLogger.i18NLogger.get_jtax_transaction_jts_illegalstate() + info.getState());
                }
            }
            info = null;
            return true;
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (XAException exp) {
            if (info != null) {
                info.setState(3);
            }
            this.markRollbackOnly();
            jtaxLogger.i18NLogger.warn_jtax_transaction_jts_xaerror("TransactionImple.delistResource", XAHelper.printXAErrorCode(exp), exp);
            return false;
        }
        catch (Exception e) {
            jtaxLogger.i18NLogger.warn_jtax_transaction_jts_delistfailed(e);
            this.markRollbackOnly();
            return false;
        }
    }

    @Override
    public final Uid get_uid() {
        return this._theTransaction.get_uid();
    }

    @Override
    public final Xid getTxId() {
        Xid res = this.baseXid();
        if (res == null) {
            return this._theTransaction.get_xid(false);
        }
        return res;
    }

    public String toString() {
        if (this._theTransaction == null) {
            return "TransactionImple < jts, NoTransaction >";
        }
        return "TransactionImple < jts, " + String.valueOf(this._theTransaction.get_uid()) + " >";
    }

    public void endAssociation(Xid _tranID, XAResource _theXAResource, int xaState, int txInfoState) throws XAException {
        int txInfo = this.getXAResourceState(_theXAResource);
        XAException toThrow = null;
        if (txInfo != 1 && txInfo != 3) {
            try {
                this.doEnd(_tranID, _theXAResource, xaState, txInfoState);
            }
            catch (XAException e) {
                toThrow = e;
            }
        }
        for (Object resource : this._duplicateResources.keySet()) {
            XAResource dupXar = (XAResource)resource;
            if (!_theXAResource.isSameRM(dupXar)) continue;
            try {
                this.doEnd(_tranID, dupXar, xaState, txInfoState);
            }
            catch (XAException e) {
                if (e.errorCode == -6 && !STRICTJTA12DUPLICATEXAENDPROTOERR || toThrow != null) continue;
                toThrow = e;
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    private void doEnd(Xid _tranID, XAResource xar, int xaState, int txInfoState) throws XAException {
        try {
            xar.end(_tranID, xaState);
            this.setXAResourceState(xar, txInfoState);
        }
        catch (XAException e1) {
            switch (e1.errorCode) {
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this.setXAResourceState(xar, txInfoState);
                }
            }
            jtaxLogger.i18NLogger.warn_could_not_end_xar(xar, e1);
            throw e1;
        }
    }

    @Override
    public int getXAResourceState(XAResource xaRes) {
        int state = 5;
        if (xaRes != null) {
            TxInfo info = (TxInfo)this._resources.get(xaRes);
            if (info == null) {
                info = (TxInfo)this._duplicateResources.get(xaRes);
            }
            if (info != null) {
                state = info.getState();
            }
        }
        return state;
    }

    public void setXAResourceState(XAResource xaRes, int state) {
        if (xaRes != null) {
            TxInfo info = (TxInfo)this._resources.get(xaRes);
            if (info == null) {
                info = (TxInfo)this._duplicateResources.get(xaRes);
            }
            if (info != null) {
                info.setState(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final TransactionImple getTransaction() {
        TransactionImple tx2 = null;
        ControlWrapper otx = OTSImpleManager.current().getControlWrapper();
        if (otx != null) {
            ConcurrentHashMap concurrentHashMap = _transactions;
            synchronized (concurrentHashMap) {
                block9: {
                    try {
                        tx2 = (TransactionImple)_transactions.get(otx.get_uid());
                        if (tx2 != null) break block9;
                        tx2 = new TransactionImple(new AtomicTransaction(otx));
                        try {
                            if (tx2.getStatus() == 0) {
                                TransactionImple.putTransaction(tx2);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    catch (ClassCastException ex) {
                        jtaxLogger.i18NLogger.warn_jtax_transaction_jts_nottximple();
                    }
                }
            }
        }
        return tx2;
    }

    public static final TransactionImple getTransaction(Uid id) {
        try {
            if (id != null) {
                return (TransactionImple)_transactions.get(id);
            }
            return null;
        }
        catch (Exception e) {
            return new TransactionImple(null);
        }
    }

    public final void shutdown() {
        TransactionImple.removeTransaction(this);
    }

    @Override
    public Object getTxLocalResource(Object key) {
        return this._txLocalResources.get(key);
    }

    @Override
    public void putTxLocalResource(Object key, Object value) {
        this._txLocalResources.put(key, value);
    }

    @Override
    public boolean isAlive() {
        try {
            if (this._theTransaction != null) {
                return _transactions.containsKey(this.get_uid());
            }
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    protected TransactionImple(AtomicTransaction tx2) {
        block7: {
            this._theTransaction = tx2;
            if (tx2 != null) {
                this._resources = new Hashtable();
                this._duplicateResources = new Hashtable();
                this._txLocalResources = Collections.synchronizedMap(new HashMap());
            } else {
                this._resources = null;
                this._duplicateResources = null;
            }
            this._suspendCount = 0;
            try {
                if (this.getStatus() != 0) break block7;
                TwoPhaseCoordinator theTx = null;
                try {
                    theTx = (TwoPhaseCoordinator)BasicAction.Current();
                    if (theTx != null) {
                        theTx.addSynchronization(new LocalCleanupSynchronization(this));
                        break block7;
                    }
                    this.registerSynchronization(new CleanupSynchronization(this));
                }
                catch (ClassCastException ex) {
                    this.registerSynchronization(new CleanupSynchronization(this));
                }
            }
            catch (Exception ex) {
                jtaxLogger.i18NLogger.warn_jtax_transaction_jts_syncproblem(ex);
            }
        }
        this._xaTransactionTimeoutEnabled = TransactionImple.getXATransactionTimeoutEnabled();
    }

    protected void commitAndDisassociate() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException, IllegalStateException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"TransactionImple.commitAndDisassociate");
        }
        if (this._theTransaction != null) {
            try {
                this._theTransaction.commit(true);
            }
            catch (WrongTransaction wt) {
                throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_wrongstatetx(), wt);
            }
            catch (NoTransaction e1) {
                throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_notx(), (Throwable)((Object)e1));
            }
            catch (HeuristicMixed e2) {
                HeuristicMixedException heuristicMixedException = new HeuristicMixedException();
                heuristicMixedException.initCause((Throwable)((Object)e2));
                throw heuristicMixedException;
            }
            catch (HeuristicHazard e3) {
                HeuristicMixedException heuristicMixedException = new HeuristicMixedException();
                heuristicMixedException.initCause((Throwable)((Object)e3));
                throw heuristicMixedException;
            }
            catch (TRANSACTION_ROLLEDBACK e4) {
                jtaxLogger.i18NLogger.warn_jtax_transaction_jts_ex((Exception)((Object)e4));
                RollbackException rollbackException = new RollbackException(e4.toString());
                if (this._rollbackOnlyCallerStacktrace != null) {
                    rollbackException.initCause(this._rollbackOnlyCallerStacktrace);
                }
                throw rollbackException;
            }
            catch (NO_PERMISSION e5) {
                throw new SecurityException(e5);
            }
            catch (INVALID_TRANSACTION e6) {
                throw new IllegalStateException();
            }
            catch (org.omg.CORBA.SystemException e7) {
                InvalidTerminationStateException invalidTerminationStateException = new InvalidTerminationStateException();
                invalidTerminationStateException.initCause(e7);
                throw invalidTerminationStateException;
            }
            finally {
                TransactionImple.removeTransaction(this);
            }
        } else {
            throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_inactivetx());
        }
    }

    protected void rollbackAndDisassociate() throws IllegalStateException, SecurityException, SystemException {
        if (jtaxLogger.logger.isTraceEnabled()) {
            jtaxLogger.logger.trace((Object)"TransactionImple.rollbackAndDisassociate");
        }
        if (this._theTransaction != null) {
            try {
                this._theTransaction.rollback();
            }
            catch (WrongTransaction e1) {
                throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_wrongstatetx(), e1);
            }
            catch (NO_PERMISSION e2) {
                throw new SecurityException(e2);
            }
            catch (INVALID_TRANSACTION e3) {
                throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_invalidtx2(), e3);
            }
            catch (NoTransaction e4) {
                throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_notx(), (Throwable)((Object)e4));
            }
            catch (org.omg.CORBA.SystemException e5) {
                SystemException systemException = new SystemException(e5.toString());
                systemException.initCause((Throwable)e5);
                throw systemException;
            }
            finally {
                TransactionImple.removeTransaction(this);
            }
        } else {
            throw new IllegalStateException(jtaxLogger.i18NLogger.get_jtax_transaction_jts_inactivetx());
        }
    }

    protected Xid baseXid() {
        return null;
    }

    protected static final void putTransaction(TransactionImple tx2) {
        _transactions.put(tx2.get_uid(), tx2);
    }

    public static final void removeTransaction(TransactionImple tx2) {
        _transactions.remove(tx2.get_uid());
    }

    protected boolean endSuspendedRMs() {
        boolean result = true;
        if (this._suspendCount > 0) {
            TxInfo info;
            XAResource xaRes;
            Enumeration el = this._resources.keys();
            if (el != null) {
                try {
                    while (el.hasMoreElements()) {
                        xaRes = (XAResource)el.nextElement();
                        info = (TxInfo)this._resources.get(xaRes);
                        if (info.getState() != 2) continue;
                        if (XAUtils.mustEndSuspendedRMs(xaRes)) {
                            xaRes.start(info.xid(), 0x8000000);
                        }
                        xaRes.end(info.xid(), 0x4000000);
                        info.setState(1);
                    }
                }
                catch (XAException ex) {
                    jtaxLogger.i18NLogger.warn_jtax_transaction_jts_xaenderror();
                    result = false;
                }
            }
            if ((el = this._duplicateResources.keys()) != null) {
                try {
                    while (el.hasMoreElements()) {
                        xaRes = (XAResource)el.nextElement();
                        info = (TxInfo)this._duplicateResources.get(xaRes);
                        if (info.getState() != 2) continue;
                        if (XAUtils.mustEndSuspendedRMs(xaRes)) {
                            xaRes.start(info.xid(), 0x8000000);
                        }
                        xaRes.end(info.xid(), 0x4000000);
                        info.setState(1);
                    }
                }
                catch (XAException ex) {
                    jtaxLogger.i18NLogger.warn_jtax_transaction_jts_xaenderror();
                    result = false;
                }
            }
            this._suspendCount = 0;
        }
        return result;
    }

    private final boolean threadIsActive(XAResource xaRes) {
        Thread t = Thread.currentThread();
        try {
            TxInfo info;
            XAResource x;
            Enumeration el = this._resources.keys();
            if (el != null) {
                while (el.hasMoreElements()) {
                    x = (XAResource)el.nextElement();
                    if (!x.isSameRM(xaRes) || (info = (TxInfo)this._resources.get(x)).thread() != t) continue;
                    return true;
                }
            }
            if ((el = this._duplicateResources.keys()) != null) {
                while (el.hasMoreElements()) {
                    x = (XAResource)el.nextElement();
                    if (!x.isSameRM(xaRes) || (info = (TxInfo)this._resources.get(x)).thread() != t) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            jtaxLogger.i18NLogger.warn_jtax_transaction_jts_threaderror(e);
            throw new FatalError(e.toString(), e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TxInfo isNewRM(XAResource xaRes) {
        try {
            TransactionImple transactionImple = this;
            synchronized (transactionImple) {
                XAResource x;
                Enumeration el = this._resources.keys();
                if (el != null) {
                    while (el.hasMoreElements()) {
                        x = (XAResource)el.nextElement();
                        if (!x.isSameRM(xaRes)) continue;
                        return (TxInfo)this._resources.get(x);
                    }
                }
                if ((el = this._duplicateResources.keys()) != null) {
                    while (el.hasMoreElements()) {
                        x = (XAResource)el.nextElement();
                        if (!x.isSameRM(xaRes)) continue;
                        return (TxInfo)this._duplicateResources.get(x);
                    }
                }
            }
        }
        catch (XAException ex) {
            jtaxLogger.i18NLogger.warn_jtax_transaction_jts_xaerror("TransactionImple.isNewRM", XAHelper.printXAErrorCode(ex), ex);
            throw new FatalError(ex.toString(), ex);
        }
        catch (Exception e) {
            jtaxLogger.i18NLogger.warn_jtax_transaction_jts_rmerror(e);
            throw new FatalError(e.toString(), e);
        }
        return null;
    }

    private final Xid createXid(boolean branch, XAModifier theModifier) {
        Xid jtaXid = this.baseXid();
        if (jtaXid != null && jtaXid.getFormatId() != Arjuna.XID()) {
            return jtaXid;
        }
        try {
            jtaXid = jtaXid != null ? new XidImple(jtaXid, branch, XAUtils.getEisName(jtaXid)) : this._theTransaction.get_xid(branch);
            if (theModifier != null) {
                try {
                    jtaXid = theModifier.createXid(jtaXid);
                }
                catch (Exception e) {
                    jtaxLogger.i18NLogger.warn_jtax_transaction_jts_ex(e);
                }
            }
            return jtaXid;
        }
        catch (Exception e) {
            jtaxLogger.i18NLogger.warn_jtax_transaction_jts_ex(e);
            return null;
        }
    }

    private final void markRollbackOnly() {
        block5: {
            try {
                if (this._theTransaction == null) break block5;
                try {
                    this._theTransaction.rollbackOnly();
                }
                catch (NoTransaction noTransaction) {
                }
                catch (org.omg.CORBA.SystemException e3) {
                    SystemException systemException = new SystemException(e3.toString());
                    systemException.initCause((Throwable)e3);
                    throw systemException;
                }
            }
            catch (Exception ex) {
                jtaxLogger.i18NLogger.warn_jtax_transaction_jts_rollbackerror("TransactionImple.markRollbackOnly -", ex);
            }
        }
    }

    private static boolean getXATransactionTimeoutEnabled() {
        return XA_TRANSACTION_TIMEOUT_ENABLED;
    }

    public static Map<Uid, jakarta.transaction.Transaction> getTransactions() {
        return Collections.unmodifiableMap(_transactions);
    }

    @Override
    public Map<XAResource, TxInfo> getResources() {
        return Collections.unmodifiableMap(this._resources);
    }

    @Override
    public int getTimeout() {
        return this._theTransaction.getTimeout();
    }

    @Override
    public long getRemainingTimeoutMills() {
        return TransactionReaper.transactionReaper().getRemainingTimeoutMills(this._theTransaction.getControlWrapper());
    }

    @Override
    public Map<Uid, String> getSynchronizations() {
        if (this._theTransaction != null) {
            return this._theTransaction.getControlWrapper().getSynchronizations();
        }
        return Collections.EMPTY_MAP;
    }

    static {
        if (LAST_RESOURCE_OPTIMISATION_INTERFACE == null) {
            jtaLogger.i18NLogger.warn_transaction_arjunacore_lastResourceOptimisationInterface(jtaPropertyManager.getJTAEnvironmentBean().getLastResourceOptimisationInterfaceClassName());
            jtaxLogger.i18NLogger.warn_jtax_transaction_jts_lastResourceOptimisationInterface(jtaPropertyManager.getJTAEnvironmentBean().getLastResourceOptimisationInterfaceClassName());
        }
        _transactions = new ConcurrentHashMap();
        STRICTJTA12DUPLICATEXAENDPROTOERR = jtaPropertyManager.getJTAEnvironmentBean().isStrictJTA12DuplicateXAENDPROTOErr();
    }
}

