/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.DefaultClientHeadersFactoryImpl;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderProvider;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderProviders;
import org.jboss.resteasy.microprofile.client.utils.ClientRequestContextUtils;
import org.jboss.resteasy.microprofile.client.utils.ListCastUtils;

@Priority(value=-2147483648)
public class ClientHeadersRequestFilter
implements ClientRequestFilter {
    private static final MultivaluedMap<String, String> EMPTY_MAP = new MultivaluedHashMap();
    private final MultivaluedMap<String, Object> defaultHeaders = new Headers();

    public ClientHeadersRequestFilter() {
    }

    public ClientHeadersRequestFilter(MultivaluedMap<String, Object> defaultHeaders) {
        this.defaultHeaders.putAll(defaultHeaders);
    }

    public void filter(ClientRequestContext requestContext) {
        Method method = ClientRequestContextUtils.getMethod(requestContext);
        MultivaluedHashMap headers = new MultivaluedHashMap();
        Optional<ClientHeaderProvider> handler = ClientHeaderProviders.getProvider(method);
        handler.ifPresent(arg_0 -> ClientHeadersRequestFilter.lambda$filter$0((MultivaluedMap)headers, arg_0));
        Optional<ClientHeadersFactory> factory = ClientHeaderProviders.getFactory(ClientRequestContextUtils.getDeclaringClass(requestContext));
        requestContext.getHeaders().forEach((arg_0, arg_1) -> ClientHeadersRequestFilter.lambda$filter$1((MultivaluedMap)headers, arg_0, arg_1));
        MultivaluedMap<String, String> containerHeaders = (MultivaluedMap<String, String>)requestContext.getProperty("MP_CLIENT_CONTAINER_HEADERS");
        if (containerHeaders == null) {
            containerHeaders = EMPTY_MAP;
        }
        MultivaluedMap<String, String> incomingHeaders = containerHeaders;
        if (!factory.isPresent() || factory.get() instanceof DefaultClientHeadersFactoryImpl) {
            headers.forEach((key, values) -> requestContext.getHeaders().put(key, ClientHeadersRequestFilter.castToListOfObjects(values)));
        }
        factory.ifPresent(arg_0 -> ClientHeadersRequestFilter.lambda$filter$4(incomingHeaders, (MultivaluedMap)headers, requestContext, arg_0));
        this.defaultHeaders.forEach((name, values) -> requestContext.getHeaders().addAll(name, values));
    }

    private static List<Object> castToListOfObjects(List<String> values) {
        return new ArrayList<Object>(values);
    }

    private static /* synthetic */ void lambda$filter$4(MultivaluedMap incomingHeaders, MultivaluedMap headers, ClientRequestContext requestContext, ClientHeadersFactory f) {
        f.update(incomingHeaders, headers).forEach((key, values) -> requestContext.getHeaders().put(key, ClientHeadersRequestFilter.castToListOfObjects(values)));
    }

    private static /* synthetic */ void lambda$filter$1(MultivaluedMap headers, String key, List values) {
        headers.put((Object)key, ListCastUtils.castToListOfStrings(values));
    }

    private static /* synthetic */ void lambda$filter$0(MultivaluedMap headers, ClientHeaderProvider h) {
        h.addHeaders((MultivaluedMap<String, String>)headers);
    }
}

