/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.jbossallxml;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLElementReader;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParserDescription;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParseContext;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLMapper;
import org.jboss.vfs.VirtualFile;

public class JBossAllXMLParsingProcessor
implements DeploymentUnitProcessor {
    public static final String[] DEPLOYMENT_STRUCTURE_DESCRIPTOR_LOCATIONS = new String[]{"WEB-INF/jboss-all.xml", "META-INF/jboss-all.xml"};
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();
    public static final String JBOSS = "jboss";

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot root = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile descriptor = null;
        for (String loc : DEPLOYMENT_STRUCTURE_DESCRIPTOR_LOCATIONS) {
            VirtualFile file = root.getRoot().getChild(loc);
            if (!file.exists()) continue;
            descriptor = file;
            break;
        }
        if (descriptor == null) {
            return;
        }
        XMLMapper mapper = XMLMapper.Factory.create();
        HashMap namespaceAttachments = new HashMap();
        for (JBossAllXMLParserDescription<?> parser : deploymentUnit.getAttachmentList(JBossAllXMLParserDescription.ATTACHMENT_KEY)) {
            namespaceAttachments.put(parser.getRootElement(), parser.getAttachmentKey());
            mapper.registerRootElement(parser.getRootElement(), (XMLElementReader)new JBossAllXMLElementReader(parser));
        }
        mapper.registerRootElement(new QName(Namespace.JBOSS_1_0.getUriString(), JBOSS), (XMLElementReader)Parser.INSTANCE);
        mapper.registerRootElement(new QName(Namespace.NONE.getUriString(), JBOSS), (XMLElementReader)Parser.INSTANCE);
        JBossAllXmlParseContext context = new JBossAllXmlParseContext(deploymentUnit);
        this.parse(descriptor, mapper, context);
        HashMap<AttachmentKey, QName> usedNamespaces = new HashMap<AttachmentKey, QName>();
        for (Map.Entry<QName, Object> entry : context.getParseResults().entrySet()) {
            AttachmentKey attachmentKey = (AttachmentKey)namespaceAttachments.get(entry.getKey());
            if (usedNamespaces.containsKey(attachmentKey)) {
                throw ServerLogger.ROOT_LOGGER.equivalentNamespacesInJBossXml(entry.getKey(), (QName)usedNamespaces.get(attachmentKey));
            }
            usedNamespaces.put(attachmentKey, entry.getKey());
            deploymentUnit.putAttachment(attachmentKey, entry.getValue());
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
        for (JBossAllXMLParserDescription<?> parser : context.getAttachmentList(JBossAllXMLParserDescription.ATTACHMENT_KEY)) {
            context.removeAttachment(parser.getAttachmentKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(VirtualFile file, XMLMapper mapper, JBossAllXmlParseContext context) throws DeploymentUnitProcessingException {
        FileInputStream fis;
        File realFile;
        try {
            realFile = file.getPhysicalFile();
            fis = new FileInputStream(realFile);
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException(e);
        }
        try {
            this.parse(fis, realFile, mapper, context);
        }
        finally {
            JBossAllXMLParsingProcessor.safeClose(fis);
        }
    }

    private void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream source, File file, XMLMapper mapper, JBossAllXmlParseContext context) throws DeploymentUnitProcessingException {
        try {
            XMLInputFactory inputFactory = INPUT_FACTORY;
            this.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
            this.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
            XMLStreamReader streamReader = inputFactory.createXMLStreamReader(source);
            try {
                mapper.parseDocument((Object)context, streamReader);
            }
            finally {
                JBossAllXMLParsingProcessor.safeClose(streamReader);
            }
        }
        catch (XMLStreamException e) {
            throw ServerLogger.ROOT_LOGGER.errorLoadingJBossXmlFile(file.getPath(), e);
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void safeClose(XMLStreamReader streamReader) {
        if (streamReader != null) {
            try {
                streamReader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }

    private static enum Namespace {
        UNKNOWN(null),
        NONE(null),
        XML_SCHEMA_INSTANCE("http://www.w3.org/2001/XMLSchema-instance"),
        JBOSS_1_0("urn:jboss:1.0");

        public static final Namespace CURRENT;
        private final String name;
        private static final Map<String, Namespace> MAP;

        private Namespace(String name) {
            this.name = name;
        }

        public String getUriString() {
            return this.name;
        }

        public static Namespace forUri(String uri) {
            if (uri == null || "".equals(uri)) {
                return NONE;
            }
            Namespace element = MAP.get(uri);
            return element == null ? UNKNOWN : element;
        }

        static {
            CURRENT = JBOSS_1_0;
            HashMap<String, Namespace> map = new HashMap<String, Namespace>();
            for (Namespace namespace : Namespace.values()) {
                String name = namespace.getUriString();
                if (name == null) continue;
                map.put(name, namespace);
            }
            MAP = map;
        }
    }

    private static enum Element {
        JBOSS("jboss"),
        UNKNOWN("unknown");

        private final String name;
        private static final Map<String, Element> MAP;

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Element forName(String localName) {
            Element element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Element> map = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    private static class Parser
    implements XMLElementReader<JBossAllXmlParseContext> {
        public static final Parser INSTANCE = new Parser();

        private Parser() {
        }

        public void readElement(XMLExtendedStreamReader reader, JBossAllXmlParseContext context) throws XMLStreamException {
            if (Element.forName(reader.getLocalName()) != Element.JBOSS) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            Namespace readerNS = Namespace.forUri(reader.getNamespaceURI());
            switch (readerNS) {
                case NONE: 
                case JBOSS_1_0: {
                    this.parseJBossElement(reader, context);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }

        private void parseJBossElement(XMLExtendedStreamReader reader, JBossAllXmlParseContext context) throws XMLStreamException {
            while (reader.hasNext() && reader.nextTag() != 2) {
                reader.handleAny((Object)context);
            }
        }
    }
}

