/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPLargeMessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPMessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPTunneledCoreLargeMessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPTunneledCoreMessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.SenderController;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;

public abstract class AMQPFederationBaseSenderController
implements SenderController {
    protected final AMQPSessionContext session;
    protected final AMQPSessionCallback sessionSPI;
    protected AMQPMessageWriter standardMessageWriter;
    protected AMQPLargeMessageWriter largeMessageWriter;
    protected AMQPTunneledCoreMessageWriter coreMessageWriter;
    protected AMQPTunneledCoreLargeMessageWriter coreLargeMessageWriter;
    protected boolean tunnelCoreMessages;
    protected Consumer<ErrorCondition> resourceDeletedAction;

    public AMQPFederationBaseSenderController(AMQPSessionContext session) throws ActiveMQAMQPException {
        this.session = session;
        this.sessionSPI = session.getSessionSPI();
    }

    public AMQPSessionContext getSessionContext() {
        return this.session;
    }

    public AMQPSessionCallback getSessionCallback() {
        return this.sessionSPI;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void close(ErrorCondition error) {
        if (error != null && AmqpError.RESOURCE_DELETED.equals(error.getCondition()) && this.resourceDeletedAction != null) {
            this.resourceDeletedAction.accept(error);
        }
    }

    @Override
    public MessageWriter selectOutgoingMessageWriter(ProtonServerSenderContext sender, MessageReference reference) {
        Message message = reference.getMessage();
        MessageWriter selected = message instanceof AMQPMessage ? (message.isLargeMessage() ? (this.largeMessageWriter != null ? this.largeMessageWriter : (this.largeMessageWriter = new AMQPLargeMessageWriter(sender))) : (this.standardMessageWriter != null ? this.standardMessageWriter : (this.standardMessageWriter = new AMQPMessageWriter(sender)))) : (this.tunnelCoreMessages ? (message.isLargeMessage() ? (this.coreLargeMessageWriter != null ? this.coreLargeMessageWriter : (this.coreLargeMessageWriter = new AMQPTunneledCoreLargeMessageWriter(sender))) : (this.coreMessageWriter != null ? this.coreMessageWriter : (this.coreMessageWriter = new AMQPTunneledCoreMessageWriter(sender)))) : (this.standardMessageWriter != null ? this.standardMessageWriter : (this.standardMessageWriter = new AMQPMessageWriter(sender))));
        return selected;
    }
}

