/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.protostream.FileDescriptorSource;

class Reflect {
    Reflect() {
    }

    static ClassLoader getClassLoader(final Class<?> targetClass) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return targetClass.getClassLoader();
            }
        });
    }

    static <T> List<T> loadAll(final Class<T> targetClass, final ClassLoader loader) {
        return (List)AccessController.doPrivileged(new PrivilegedAction<List<T>>(){

            @Override
            public List<T> run() {
                return ServiceLoader.load(targetClass, loader).stream().map(Supplier::get).collect(Collectors.toList());
            }
        });
    }

    static <T> Optional<T> loadFirst(final Class<T> targetClass, final ClassLoader loader) {
        return (Optional)AccessController.doPrivileged(new PrivilegedAction<Optional<T>>(){

            @Override
            public Optional<T> run() {
                return ServiceLoader.load(targetClass, loader).findFirst();
            }
        });
    }

    static FileDescriptorSource loadSchemas(final String resourceName, final ClassLoader loader) {
        return AccessController.doPrivileged(new PrivilegedAction<FileDescriptorSource>(){

            @Override
            public FileDescriptorSource run() {
                try {
                    return FileDescriptorSource.fromResources((ClassLoader)loader, (String[])new String[]{resourceName});
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
    }

    static Method findMethod(final Class<?> sourceClass, final String methodName) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    Method method = sourceClass.getDeclaredMethod(methodName, new Class[0]);
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    static Object invoke(Object source, Method method) {
        return Reflect.invoke(source, method, Object.class);
    }

    static <T> T invoke(final Object source, final Method method, final Class<T> returnClass) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    return returnClass.cast(method.invoke(source, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

