/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.util.AbstractMapMarshaller;

public class MapMarshaller<T extends Map<Object, Object>>
extends AbstractMapMarshaller<T> {
    private final Supplier<T> factory;

    public MapMarshaller(Supplier<T> factory) {
        super(((Map)factory.get()).getClass());
        this.factory = factory;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        Map map = (Map)this.factory.get();
        LinkedList<Object> keys = new LinkedList<Object>();
        LinkedList<Object> values = new LinkedList<Object>();
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            switch (index) {
                case 1: {
                    keys.add(reader.readAny());
                    continue block4;
                }
                case 2: {
                    values.add(reader.readAny());
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        Iterator keyIterator = keys.iterator();
        Iterator valueIterator = values.iterator();
        while (keyIterator.hasNext() || valueIterator.hasNext()) {
            map.put(keyIterator.next(), valueIterator.next());
        }
        return (T)map;
    }
}

