/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import org.hibernate.envers.configuration.internal.metadata.EntityMappingData;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.mapper.CompositeMapperBuilder;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.type.BagType;
import org.hibernate.type.ListType;
import org.hibernate.type.MapType;
import org.hibernate.type.SetType;
import org.hibernate.type.Type;

public interface CollectionMetadataContext {
    public EntityMappingData getEntityMappingData();

    public Collection getCollection();

    public CompositeMapperBuilder getMapperBuilder();

    public String getReferencedEntityName();

    public String getReferencingEntityName();

    public EntityConfiguration getReferencingEntityConfiguration();

    public PropertyAuditingData getPropertyAuditingData();

    default public String getPropertyName() {
        return this.getPropertyAuditingData().getName();
    }

    default public boolean isOneToManyAttached() {
        Type type = this.getCollection().getType();
        return type instanceof BagType || type instanceof SetType || type instanceof MapType || type instanceof ListType;
    }

    default public boolean isInverseOneToMany() {
        return this.getCollection().getElement() instanceof OneToMany && this.getCollection().isInverse();
    }

    default public boolean isOwningManyToOneWithBidrectionalJoinTable() {
        return this.getCollection().getElement() instanceof ManyToOne && this.getPropertyAuditingData().hasRelationMappedBy();
    }

    default public boolean isFakeOneToManyBidirectional() {
        return this.getCollection().getElement() instanceof OneToMany && this.getPropertyAuditingData().hasAuditedMappedBy();
    }

    default public boolean isMiddleTableCollection() {
        return !this.isOneToManyAttached() || !this.isInverseOneToMany() && !this.isFakeOneToManyBidirectional() && !this.isOwningManyToOneWithBidrectionalJoinTable();
    }

    default public boolean isOneToManySingleTableSubclass() {
        if (this.getCollection().getElement() instanceof OneToMany) {
            return ((OneToMany)this.getCollection().getElement()).getAssociatedClass() instanceof SingleTableSubclass;
        }
        return false;
    }
}

