/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.wildfly.clustering.context.Context;
import org.wildfly.common.function.Functions;

public interface ContextReference<C>
extends Supplier<C>,
Consumer<C> {
    public static <C> ContextReference<C> fromThreadLocal(final ThreadLocal<C> threadLocal) {
        return new ContextReference<C>(){

            @Override
            public C get() {
                return threadLocal.get();
            }

            @Override
            public void accept(C value) {
                threadLocal.set(value);
            }
        };
    }

    default public Supplier<Context> provide(final C target) {
        return target != null ? new Supplier<Context>(this){
            final /* synthetic */ ContextReference this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Context get() {
                final Object existing = this.this$0.get();
                if (existing == target) {
                    return Context.EMPTY;
                }
                this.this$0.accept(target);
                return new Context(){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void close() {
                        this.this$1.this$0.accept(existing);
                    }
                };
            }
        } : Functions.constantSupplier((Object)Context.EMPTY);
    }
}

