/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.local.scheduler;

import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.wildfly.clustering.server.local.scheduler.ScheduledEntries;

class SortedScheduledEntries<K, V>
implements ScheduledEntries<K, V> {
    private final SortedSet<Map.Entry<K, V>> sorted;
    private final Map<K, V> entries = new ConcurrentHashMap();

    static <K, V extends Comparable<? super V>> Comparator<Map.Entry<K, V>> defaultComparator() {
        return new Comparator<Map.Entry<K, V>>(){
            private final List<ToIntFunction<K>> hashFunctions = List.of(Object::hashCode, System::identityHashCode);

            @Override
            public int compare(Map.Entry<K, V> entry1, Map.Entry<K, V> entry2) {
                Object key2;
                Object key1 = entry1.getKey();
                if (key1.equals(key2 = entry2.getKey())) {
                    return 0;
                }
                int result = ((Comparable)entry1.getValue()).compareTo(entry2.getValue());
                if (result != 0) {
                    return result;
                }
                for (ToIntFunction hashFunction : this.hashFunctions) {
                    result = Integer.compare(hashFunction.applyAsInt(key1), hashFunction.applyAsInt(key2));
                    if (result == 0) continue;
                    return result;
                }
                return 1;
            }
        };
    }

    SortedScheduledEntries(Comparator<Map.Entry<K, V>> comparator) {
        this.sorted = new ConcurrentSkipListSet<Map.Entry<K, V>>(comparator);
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public void add(K key, V value) {
        V oldValue = this.entries.put(key, value);
        if (oldValue != null) {
            this.sorted.remove(new Entry<K, V>(key, oldValue));
        }
        this.sorted.add(new Entry<K, V>(key, value));
    }

    @Override
    public void remove(K key) {
        V value = this.entries.remove(key);
        if (value != null) {
            this.sorted.remove(new Entry<K, V>(key, value));
        }
    }

    @Override
    public boolean contains(K key) {
        return this.entries.containsKey(key);
    }

    @Override
    public Map.Entry<K, V> peek() {
        try {
            return this.sorted.first();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public Stream<Map.Entry<K, V>> stream() {
        return this.sorted.stream();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        final Iterator iterator = this.sorted.iterator();
        final Map<K, V> entries = this.entries;
        return new Iterator<Map.Entry<K, V>>(this){
            private K current = null;
            final /* synthetic */ SortedScheduledEntries this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry next = (Map.Entry)iterator.next();
                this.current = next.getKey();
                return next;
            }

            @Override
            public void remove() {
                iterator.remove();
                entries.remove(this.current);
            }
        };
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<K, V>> action) {
        this.sorted.forEach(action);
    }

    @Override
    public Spliterator<Map.Entry<K, V>> spliterator() {
        return this.sorted.spliterator();
    }

    public String toString() {
        return this.sorted.toString();
    }

    private static class Entry<K, V>
    extends AbstractMap.SimpleImmutableEntry<K, V> {
        private static final long serialVersionUID = -1818780078437540182L;

        Entry(K key, V value) {
            super(key, value);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.getKey().equals(entry.getKey());
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode();
        }

        @Override
        public String toString() {
            return this.getKey().toString();
        }
    }
}

