/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.log4j;

import java.security.AccessController;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.log4j.LevelTranslator;

class JBossStatusListener
implements StatusListener {
    private static final String NAME = "org.jboss.logmanager.log4j.status";
    private static final Logger.AttachmentKey<StatusListener> STATUS_LISTENER_KEY = new Logger.AttachmentKey();
    private final Logger logger;
    private final LevelTranslator levelTranslator;

    private JBossStatusListener(Logger logger, LevelTranslator levelTranslator) {
        this.logger = logger;
        this.levelTranslator = levelTranslator;
    }

    static void registerIfAbsent(LogContext logContext) {
        StatusListener listener;
        LevelTranslator levelTranslator = LevelTranslator.getInstance();
        Logger logger = logContext.getLoggerIfExists(NAME);
        if (logger == null) {
            logger = logContext.getLogger(NAME);
            JBossStatusListener.setLogLevel((java.util.logging.Logger)logger, levelTranslator.translateLevel(StatusLogger.getLogger().getFallbackListener().getStatusLevel()));
        }
        if ((listener = (StatusListener)logger.getAttachment(STATUS_LISTENER_KEY)) == null && JBossStatusListener.attachIfAbsent(logger, listener = new JBossStatusListener(logger, levelTranslator)) == null) {
            StatusLogger.getLogger().registerListener(listener);
        }
    }

    static void remove(LogContext logContext) {
        Logger logger = logContext.getLoggerIfExists(NAME);
        if (logger != null) {
            JBossStatusListener.detach(logger);
        }
    }

    public void log(StatusData data) {
        if (this.getStatusLevel().isLessSpecificThan(data.getLevel())) {
            this.logger.log(this.levelTranslator.translateLevel(data.getLevel()), data.getMessage().getFormattedMessage(), data.getThrowable());
        }
    }

    public Level getStatusLevel() {
        return this.levelTranslator.translateLevel(this.logger.getLevel());
    }

    public void close() {
        JBossStatusListener.detach(this.logger);
    }

    private static StatusListener attachIfAbsent(Logger logger, StatusListener value) {
        if (System.getSecurityManager() == null) {
            return (StatusListener)logger.attachIfAbsent(STATUS_LISTENER_KEY, (Object)value);
        }
        return AccessController.doPrivileged(() -> (StatusListener)logger.attachIfAbsent(STATUS_LISTENER_KEY, (Object)value));
    }

    private static void detach(Logger logger) {
        StatusListener listener = System.getSecurityManager() == null ? (StatusListener)logger.detach(STATUS_LISTENER_KEY) : (StatusListener)AccessController.doPrivileged(() -> logger.detach(STATUS_LISTENER_KEY));
        if (listener != null) {
            StatusLogger.getLogger().removeListener(listener);
        }
    }

    private static void setLogLevel(java.util.logging.Logger logger, java.util.logging.Level level) {
        if (System.getSecurityManager() == null) {
            logger.setLevel(level);
        } else {
            AccessController.doPrivileged(() -> {
                logger.setLevel(level);
                return null;
            });
        }
    }
}

