/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.weld.exceptions.WeldException;

public class DelegatingInterceptorInvocationContext
implements InvocationContext {
    private InvocationContext delegateInvocationContext;
    private final List<Interceptor> invocationQueue;
    private final List<Object> interceptorInstances;
    private int position;
    private InterceptionType interceptionType;

    public DelegatingInterceptorInvocationContext(InvocationContext delegateInvocationContext, List<Interceptor<?>> interceptors, List<Object> instances, InterceptionType interceptionType) {
        this.delegateInvocationContext = delegateInvocationContext;
        this.interceptionType = interceptionType;
        this.invocationQueue = new ArrayList(interceptors);
        this.interceptorInstances = new ArrayList<Object>(instances);
        this.position = 0;
    }

    public Map<String, Object> getContextData() {
        return this.delegateInvocationContext.getContextData();
    }

    public Method getMethod() {
        return this.delegateInvocationContext.getMethod();
    }

    public Constructor<?> getConstructor() {
        return this.delegateInvocationContext.getConstructor();
    }

    public Object[] getParameters() {
        return this.delegateInvocationContext.getParameters();
    }

    public Object getTarget() {
        return this.delegateInvocationContext.getTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object proceed() throws Exception {
        int oldPosition = this.position;
        try {
            if (this.position < this.invocationQueue.size()) {
                Object interceptorInstance = this.interceptorInstances.get(this.position);
                try {
                    Object object = this.invocationQueue.get(this.position++).intercept(this.interceptionType, interceptorInstance, (InvocationContext)this);
                    return object;
                }
                catch (Exception e) {
                    if (e instanceof WeldException && e.getCause() instanceof Exception) {
                        throw (Exception)e.getCause();
                    }
                    throw e;
                }
            }
            Object object = this.delegateInvocationContext.proceed();
            return object;
        }
        finally {
            this.position = oldPosition;
        }
    }

    public void setParameters(Object[] params) {
        this.delegateInvocationContext.setParameters(params);
    }

    public Object getTimer() {
        return this.delegateInvocationContext.getTimer();
    }
}

