/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import jakarta.ejb.Timer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.util.MethodInfoHelper;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.SimpleInterceptorFactoryContext;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.modules.Module;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RunResult;

public class TimedObjectInvokerImpl
implements TimedObjectInvoker {
    private final String timedObjectId;
    private final EJBComponent component;
    private final Module module;
    private final Map<Method, Interceptor> interceptors = new HashMap<Method, Interceptor>();

    public TimedObjectInvokerImpl(Module module, String deploymentName, EJBComponent component) {
        this.module = module;
        this.timedObjectId = deploymentName + "." + component.getComponentName();
        this.component = component;
        SimpleInterceptorFactoryContext factoryContext = new SimpleInterceptorFactoryContext();
        factoryContext.getContextData().put(Component.class, component);
        for (Map.Entry<Method, InterceptorFactory> entry : component.getTimeoutInterceptors().entrySet()) {
            this.interceptors.put(entry.getKey(), entry.getValue().create((InterceptorFactoryContext)factoryContext));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callTimeout(Timer timer, Method method) throws Exception {
        ControlPoint controlPoint = this.component.getControlPoint();
        if (controlPoint != null) {
            if (controlPoint.beginRequest() == RunResult.REJECTED) {
                throw EjbLogger.EJB3_TIMER_LOGGER.containerSuspended();
            }
            try {
                this.invoke(timer, method);
            }
            finally {
                controlPoint.requestComplete();
            }
        } else {
            this.invoke(timer, method);
        }
    }

    private void invoke(Timer timer, Method method) throws Exception {
        Object[] objectArray;
        Interceptor interceptor = this.interceptors.get(method);
        if (interceptor == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.failToInvokeTimeout(method);
        }
        InterceptorContext context = new InterceptorContext();
        context.setContextData(new HashMap());
        context.setMethod(method);
        if (method.getParameterCount() == 0) {
            objectArray = MethodInfoHelper.EMPTY_STRING_ARRAY;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = timer;
        }
        context.setParameters(objectArray);
        context.setTimer((Object)timer);
        context.putPrivateData(Component.class, (Object)this.component);
        context.putPrivateData(MethodInterfaceType.class, (Object)MethodInterfaceType.Timer);
        context.putPrivateData(InvocationType.class, (Object)InvocationType.TIMER);
        interceptor.processInvocation(context);
    }

    @Override
    public EJBComponent getComponent() {
        return this.component;
    }

    @Override
    public String getTimedObjectId() {
        return this.timedObjectId;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.module.getClassLoader();
    }

    public int hashCode() {
        return this.timedObjectId.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TimedObjectInvoker)) {
            return false;
        }
        return this.timedObjectId.equals(((TimedObjectInvoker)object).getTimedObjectId());
    }

    public String toString() {
        return this.timedObjectId;
    }
}

