/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.impl;

import com.google.gson.JsonElement;
import java.lang.invoke.MethodHandles;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexCompositeNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexField;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexObjectField;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchEncodingContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexValueFieldType;
import org.hibernate.search.engine.backend.document.model.spi.AbstractIndexValueField;
import org.hibernate.search.engine.backend.document.model.spi.IndexCompositeNode;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.common.tree.spi.TreeNodeInclusion;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.common.spi.SearchIndexNodeContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexSchemaElementContextHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public final class ElasticsearchIndexValueField<F>
extends AbstractIndexValueField<ElasticsearchIndexValueField<F>, ElasticsearchSearchIndexScope<?>, ElasticsearchIndexValueFieldType<F>, ElasticsearchIndexCompositeNode, F>
implements ElasticsearchIndexField,
ElasticsearchSearchIndexValueFieldContext<F>,
ElasticsearchSearchEncodingContext<F> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public ElasticsearchIndexValueField(ElasticsearchIndexCompositeNode parent, String relativeFieldName, ElasticsearchIndexValueFieldType<F> type, TreeNodeInclusion inclusion, boolean multiValued) {
        super((IndexCompositeNode)parent, relativeFieldName, type, inclusion, multiValued);
    }

    protected ElasticsearchIndexValueField<F> self() {
        return this;
    }

    @Override
    public ElasticsearchIndexObjectField toObjectField() {
        return (ElasticsearchIndexObjectField)SearchIndexSchemaElementContextHelper.throwingToObjectField((SearchIndexNodeContext)this);
    }

    public <T> ElasticsearchIndexValueField<? super T> withValueType(Class<T> expectedSubType, EventContext eventContext) {
        if (!((ElasticsearchIndexValueFieldType)this.type).valueClass().isAssignableFrom(expectedSubType)) {
            throw log.invalidFieldValueType(((ElasticsearchIndexValueFieldType)this.type).valueClass(), expectedSubType, eventContext.append(EventContexts.fromIndexFieldAbsolutePath((String)this.absolutePath)));
        }
        return this;
    }

    @Override
    public <T> Function<T, JsonElement> encoder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field, Class<T> expectedType, ValueModel valueModel) {
        try {
            if (ValueModel.RAW.equals((Object)valueModel)) {
                DslConverter dslConverter = field.type().rawDslConverter().withInputType(expectedType, field);
                return v -> (JsonElement)dslConverter.toDocumentValue(v, scope.toDocumentValueConvertContext());
            }
            DslConverter toFieldValueConverter = field.type().dslConverter(valueModel).withInputType(expectedType, field);
            return v -> field.type().codec().encodeForAggregation(scope.searchSyntax(), toFieldValueConverter.toDocumentValue(v, scope.toDocumentValueConvertContext()));
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)field.absolutePath()));
        }
    }

    @Override
    public JsonElement convertAndEncode(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field, Object value, ValueModel valueModel, BiFunction<ElasticsearchFieldCodec<F>, F, JsonElement> encodeFunction) {
        if (ValueModel.RAW.equals((Object)valueModel)) {
            DslConverter dslConverter = field.type().rawDslConverter();
            try {
                return (JsonElement)dslConverter.unknownTypeToDocumentValue(value, scope.toDocumentValueConvertContext());
            }
            catch (RuntimeException e) {
                throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)field.absolutePath()));
            }
        }
        DslConverter toFieldValueConverter = field.type().dslConverter(valueModel);
        try {
            Object converted = toFieldValueConverter.unknownTypeToDocumentValue(value, scope.toDocumentValueConvertContext());
            return encodeFunction.apply(field.type().codec(), converted);
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)field.absolutePath()));
        }
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchSearchEncodingContext<?> other) {
        return other instanceof ElasticsearchIndexValueField ? ((ElasticsearchIndexValueFieldType)((ElasticsearchIndexValueField)other).type()).codec().isCompatibleWith(((ElasticsearchIndexValueFieldType)this.type).codec()) : false;
    }

    @Override
    public ElasticsearchSearchEncodingContext<F> encodingContext() {
        return this;
    }
}

