/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.exporters.metrics;

import io.opentelemetry.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregationUtil;
import io.smallrye.opentelemetry.implementation.exporters.AbstractVertxExporterProvider;
import io.smallrye.opentelemetry.implementation.exporters.metrics.VertxGrpcMetricExporter;
import io.smallrye.opentelemetry.implementation.exporters.metrics.VertxHttpMetricsExporter;
import java.net.URISyntaxException;

public class VertxMetricsExporterProvider
extends AbstractVertxExporterProvider<MetricsRequestMarshaler>
implements ConfigurableMetricExporterProvider {
    public VertxMetricsExporterProvider() {
        super("metric", "otlp");
    }

    public MetricExporter createExporter(ConfigProperties config) {
        try {
            String protocol = this.getProtocol(config);
            if ("grpc".equals(protocol)) {
                return new VertxGrpcMetricExporter(this.createGrpcExporter(config, "opentelemetry.proto.collector.metrics.v1.MetricsService"), this.aggregationTemporalityResolver(config), this.aggregationResolver(config));
            }
            if ("http/protobuf".equals(protocol)) {
                return new VertxHttpMetricsExporter(this.createHttpExporter(config, "/v1/metrics"), this.aggregationTemporalityResolver(config), this.aggregationResolver(config));
            }
            throw this.buildUnsupportedProtocolException(protocol);
        }
        catch (IllegalArgumentException | URISyntaxException iae) {
            throw new IllegalStateException("Unable to install OTLP Exporter", iae);
        }
    }

    private DefaultAggregationSelector aggregationResolver(ConfigProperties config) {
        DefaultAggregationSelector aggregationSelector;
        String defaultHistogramAggregation = this.getConfig(config, "explicit_bucket_histogram", "otel.exporter.otlp.metrics.default.histogram.aggregation");
        if (defaultHistogramAggregation.equals("explicit_bucket_histogram")) {
            aggregationSelector = DefaultAggregationSelector.getDefault();
        } else if (AggregationUtil.aggregationName((Aggregation)Aggregation.base2ExponentialBucketHistogram()).equalsIgnoreCase(defaultHistogramAggregation)) {
            aggregationSelector = DefaultAggregationSelector.getDefault().with(InstrumentType.HISTOGRAM, Aggregation.base2ExponentialBucketHistogram());
        } else {
            throw new ConfigurationException("Unrecognized default histogram aggregation: " + defaultHistogramAggregation);
        }
        return aggregationSelector;
    }

    private AggregationTemporalitySelector aggregationTemporalityResolver(ConfigProperties config) {
        String temporalityValue = this.getConfig(config, "cumulative", "otel.exporter.otlp.metrics.temporality.preference");
        if (temporalityValue.equals("cumulative")) {
            return AggregationTemporalitySelector.alwaysCumulative();
        }
        if (temporalityValue.equals("delta")) {
            return AggregationTemporalitySelector.deltaPreferred();
        }
        if (temporalityValue.equals("lowmemory")) {
            return AggregationTemporalitySelector.lowMemory();
        }
        throw new ConfigurationException("Unrecognized aggregation temporality: " + temporalityValue);
    }
}

