/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackObjectSizeIndex;
import org.eclipse.jgit.internal.storage.file.UInt24Array;
import org.eclipse.jgit.util.NB;

class PackObjectSizeIndexV1
implements PackObjectSizeIndex {
    private static final byte BITS_24 = 24;
    private static final byte BITS_32 = 32;
    private final int threshold;
    private final UInt24Array positions24;
    private final int[] positions32;
    private final int[] sizes32;
    private final long[] sizes64;

    static PackObjectSizeIndex parse(InputStream in) throws IOException {
        IndexInputStreamReader stream = new IndexInputStreamReader(in);
        int threshold = stream.readInt();
        int objCount = stream.readInt();
        if (objCount == 0) {
            return new EmptyPackObjectSizeIndex(threshold);
        }
        return new PackObjectSizeIndexV1(stream, threshold, objCount);
    }

    private PackObjectSizeIndexV1(IndexInputStreamReader stream, int threshold, int objCount) throws IOException {
        byte positionEncoding;
        this.threshold = threshold;
        UInt24Array pos24 = null;
        int[] pos32 = null;
        while ((positionEncoding = stream.readByte()) != 0) {
            int sz;
            if (Byte.compareUnsigned(positionEncoding, (byte)24) == 0) {
                sz = stream.readInt();
                pos24 = new UInt24Array(stream.readNBytes(sz * 3));
                continue;
            }
            if (Byte.compareUnsigned(positionEncoding, (byte)32) == 0) {
                sz = stream.readInt();
                pos32 = stream.readIntArray(sz);
                continue;
            }
            throw new UnsupportedEncodingException(String.format(JGitText.get().unknownPositionEncoding, Integer.toHexString(positionEncoding)));
        }
        this.positions24 = pos24 != null ? pos24 : UInt24Array.EMPTY;
        this.positions32 = pos32 != null ? pos32 : new int[]{};
        this.sizes32 = stream.readIntArray(objCount);
        int c64sizes = stream.readInt();
        if (c64sizes == 0) {
            this.sizes64 = new long[0];
            return;
        }
        this.sizes64 = stream.readLongArray(c64sizes);
        int c128sizes = stream.readInt();
        if (c128sizes != 0) {
            throw new IOException(JGitText.get().unsupportedSizesObjSizeIndex);
        }
    }

    @Override
    public long getSize(int idxOffset) {
        int pos32;
        int pos = -1;
        if (!this.positions24.isEmpty() && idxOffset <= this.positions24.getLastValue()) {
            pos = this.positions24.binarySearch(idxOffset);
        } else if (this.positions32.length > 0 && idxOffset >= this.positions32[0] && (pos32 = Arrays.binarySearch(this.positions32, idxOffset)) >= 0) {
            pos = pos32 + this.positions24.size();
        }
        if (pos < 0) {
            return -1L;
        }
        int objSize = this.sizes32[pos];
        if (objSize < 0) {
            int secondPos = Math.abs(objSize) - 1;
            return this.sizes64[secondPos];
        }
        return objSize;
    }

    @Override
    public long getObjectCount() {
        return (long)this.positions24.size() + (long)this.positions32.length;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    private static class EmptyPackObjectSizeIndex
    implements PackObjectSizeIndex {
        private final int threshold;

        EmptyPackObjectSizeIndex(int threshold) {
            this.threshold = threshold;
        }

        @Override
        public long getSize(int idxOffset) {
            return -1L;
        }

        @Override
        public long getObjectCount() {
            return 0L;
        }

        @Override
        public int getThreshold() {
            return this.threshold;
        }
    }

    private static class IndexInputStreamReader {
        private final byte[] buffer = new byte[8];
        private final InputStream in;

        IndexInputStreamReader(InputStream in) {
            this.in = in;
        }

        int readInt() throws IOException {
            int n = this.in.readNBytes(this.buffer, 0, 4);
            if (n < 4) {
                throw new IOException(JGitText.get().unableToReadFullInt);
            }
            return NB.decodeInt32(this.buffer, 0);
        }

        int[] readIntArray(int intsCount) throws IOException {
            if (intsCount == 0) {
                return new int[0];
            }
            int[] dest = new int[intsCount];
            int i = 0;
            while (i < intsCount) {
                dest[i] = this.readInt();
                ++i;
            }
            return dest;
        }

        long readLong() throws IOException {
            int n = this.in.readNBytes(this.buffer, 0, 8);
            if (n < 8) {
                throw new IOException(JGitText.get().unableToReadFullInt);
            }
            return NB.decodeInt64(this.buffer, 0);
        }

        long[] readLongArray(int longsCount) throws IOException {
            if (longsCount == 0) {
                return new long[0];
            }
            long[] dest = new long[longsCount];
            int i = 0;
            while (i < longsCount) {
                dest[i] = this.readLong();
                ++i;
            }
            return dest;
        }

        byte readByte() throws IOException {
            int n = this.in.readNBytes(this.buffer, 0, 1);
            if (n != 1) {
                throw new IOException(JGitText.get().cannotReadByte);
            }
            return this.buffer[0];
        }

        byte[] readNBytes(int sz) throws IOException {
            return this.in.readNBytes(sz);
        }
    }
}

