/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import com.sun.faces.util.Util;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.FacesWrapper;
import jakarta.faces.application.Resource;
import jakarta.faces.component.ComponentStateHelper;
import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.StateHelper;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.StateHolderSaver;
import jakarta.faces.component.TransientStateHelper;
import jakarta.faces.component.TransientStateHolder;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.FacesListener;
import jakarta.faces.event.PostRestoreStateEvent;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import jakarta.faces.event.SystemEventListenerHolder;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class UIComponent
implements PartialStateHolder,
TransientStateHolder,
SystemEventListenerHolder,
ComponentSystemEventListener {
    private static Logger LOGGER = Logger.getLogger("jakarta.faces.component", "jakarta.faces.LogStrings");
    public static final String BEANINFO_KEY = "jakarta.faces.component.BEANINFO_KEY";
    public static final String FACETS_KEY = "jakarta.faces.component.FACETS_KEY";
    public static final String VIEW_LOCATION_KEY = "jakarta.faces.component.VIEW_LOCATION_KEY";
    public static final String COMPOSITE_COMPONENT_TYPE_KEY = "jakarta.faces.component.COMPOSITE_COMPONENT_TYPE";
    public static final String COMPOSITE_FACET_NAME = "jakarta.faces.component.COMPOSITE_FACET_NAME";
    public static final String ATTRS_WITH_DECLARED_DEFAULT_VALUES = "jakarta.faces.component.ATTR_NAMES_WITH_DEFAULT_VALUES";
    private static final String _CURRENT_COMPONENT_STACK_KEY = "jakarta.faces.component.CURRENT_COMPONENT_STACK";
    private static final String _CURRENT_COMPOSITE_COMPONENT_STACK_KEY = "jakarta.faces.component.CURRENT_COMPOSITE_COMPONENT_STACK";
    List<String> attributesThatAreSet;
    ComponentStateHelper stateHelper;
    UIComponent compositeParent;
    private boolean isInView;
    private Map<String, String> resourceBundleMap;
    private transient Boolean isCompositeComponent;
    private int _isPushedAsCurrentRefCount = 0;
    boolean initialState;
    @Deprecated
    protected Map<String, ValueExpression> bindings = null;

    public abstract Map<String, Object> getAttributes();

    public Map<String, Object> getPassThroughAttributes() {
        return this.getPassThroughAttributes(true);
    }

    public Map<String, Object> getPassThroughAttributes(boolean create) {
        return Collections.emptyMap();
    }

    public ValueExpression getValueExpression(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        Map map = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.bindings));
        return map != null ? (ValueExpression)map.get(name) : null;
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (Util.isOneOf(name, "id", "parent")) {
            throw new IllegalArgumentException();
        }
        if (binding != null) {
            if (!binding.isLiteralText()) {
                List sProperties = (List)this.getStateHelper().get((Serializable)((Object)PropertyKeysPrivate.attributesThatAreSet));
                if (sProperties == null) {
                    this.getStateHelper().add((Serializable)((Object)PropertyKeysPrivate.attributesThatAreSet), name);
                } else if (!sProperties.contains(name)) {
                    this.getStateHelper().add((Serializable)((Object)PropertyKeysPrivate.attributesThatAreSet), name);
                }
                this.getStateHelper().put((Serializable)((Object)PropertyKeys.bindings), name, binding);
            } else {
                ELContext context = FacesContext.getCurrentInstance().getELContext();
                try {
                    this.getAttributes().put(name, binding.getValue(context));
                }
                catch (ELException ele) {
                    throw new FacesException(ele);
                }
            }
        } else {
            this.getStateHelper().remove((Serializable)((Object)PropertyKeysPrivate.attributesThatAreSet), name);
            this.getStateHelper().remove((Serializable)((Object)PropertyKeys.bindings), name);
        }
    }

    @Override
    public void markInitialState() {
        this.initialState = true;
    }

    @Override
    public boolean initialStateMarked() {
        return this.initialState;
    }

    @Override
    public void clearInitialState() {
        this.initialState = false;
    }

    protected StateHelper getStateHelper() {
        return this.getStateHelper(true);
    }

    protected StateHelper getStateHelper(boolean create) {
        if (create && this.stateHelper == null) {
            this.stateHelper = new ComponentStateHelper(this);
        }
        return this.stateHelper;
    }

    public TransientStateHelper getTransientStateHelper() {
        return this.getTransientStateHelper(true);
    }

    public TransientStateHelper getTransientStateHelper(boolean create) {
        if (create && this.stateHelper == null) {
            this.stateHelper = new ComponentStateHelper(this);
        }
        return this.stateHelper;
    }

    @Override
    public void restoreTransientState(FacesContext context, Object state) {
        boolean forceCreate = state != null;
        TransientStateHelper helper = this.getTransientStateHelper(forceCreate);
        if (helper != null) {
            helper.restoreTransientState(context, state);
        }
    }

    @Override
    public Object saveTransientState(FacesContext context) {
        TransientStateHelper helper = this.getTransientStateHelper(false);
        return helper == null ? null : helper.saveTransientState(context);
    }

    public boolean isInView() {
        return this.isInView;
    }

    public void setInView(boolean isInView) {
        this.isInView = isInView;
    }

    public String getClientId() {
        return this.getClientId(FacesContext.getCurrentInstance());
    }

    public abstract String getClientId(FacesContext var1);

    public String getContainerClientId(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        return this.getClientId(context);
    }

    public abstract String getFamily();

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract UIComponent getParent();

    public abstract void setParent(UIComponent var1);

    public abstract boolean isRendered();

    public abstract void setRendered(boolean var1);

    public abstract String getRendererType();

    public abstract void setRendererType(String var1);

    public abstract boolean getRendersChildren();

    public Map<String, String> getResourceBundleMap() {
        if (this.resourceBundleMap == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            ResourceBundle resourceBundle = this.findResourceBundleUnderFQCNofThis(context);
            if (resourceBundle == null) {
                resourceBundle = this.findResourceBundleAsResource(context);
            }
            if (resourceBundle != null) {
                this.resourceBundleMap = this.wrapBundleAsMap(resourceBundle);
            }
            if (this.resourceBundleMap == null) {
                this.resourceBundleMap = Collections.emptyMap();
            }
        }
        return this.resourceBundleMap;
    }

    public abstract List<UIComponent> getChildren();

    public abstract int getChildCount();

    public abstract UIComponent findComponent(String var1);

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (Util.isAnyNull(context, clientId, callback)) {
            throw new NullPointerException();
        }
        boolean found = false;
        if (clientId.equals(this.getClientId(context))) {
            try {
                this.pushComponentToEL(context, this);
                callback.invokeContextCallback(context, this);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw new FacesException(e);
            }
            finally {
                this.popComponentFromEL(context);
            }
        }
        Iterator<UIComponent> facetsAndChildrenIterator = this.getFacetsAndChildren();
        while (facetsAndChildrenIterator.hasNext() && !found) {
            found = facetsAndChildrenIterator.next().invokeOnComponent(context, clientId, callback);
        }
        return found;
    }

    public abstract Map<String, UIComponent> getFacets();

    public int getFacetCount() {
        return this.getFacets().size();
    }

    public abstract UIComponent getFacet(String var1);

    public abstract Iterator<UIComponent> getFacetsAndChildren();

    public abstract void broadcast(FacesEvent var1) throws AbortProcessingException;

    public abstract void decode(FacesContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext visitContext, VisitCallback callback) {
        block8: {
            if (!this.isVisitable(visitContext)) {
                return false;
            }
            FacesContext facesContext = visitContext.getFacesContext();
            this.pushComponentToEL(facesContext, null);
            try {
                VisitResult result = visitContext.invokeVisitCallback(this, callback);
                if (result == VisitResult.COMPLETE) {
                    boolean bl = true;
                    return bl;
                }
                if (result != VisitResult.ACCEPT) break block8;
                Iterator<UIComponent> kids = this.getFacetsAndChildren();
                while (kids.hasNext()) {
                    boolean done = kids.next().visitTree(visitContext, callback);
                    if (!done) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.popComponentFromEL(facesContext);
            }
        }
        return false;
    }

    protected boolean isVisitable(VisitContext context) {
        Set<VisitHint> hints = context.getHints();
        return (!hints.contains((Object)VisitHint.SKIP_UNRENDERED) || this.isRendered()) && (!hints.contains((Object)VisitHint.SKIP_TRANSIENT) || !this.isTransient());
    }

    public abstract void encodeBegin(FacesContext var1) throws IOException;

    public abstract void encodeChildren(FacesContext var1) throws IOException;

    public abstract void encodeEnd(FacesContext var1) throws IOException;

    public void encodeAll(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.encodeBegin(context);
        if (this.getRendersChildren()) {
            this.encodeChildren(context);
        } else if (this.getChildCount() > 0) {
            for (UIComponent kid : this.getChildren()) {
                kid.encodeAll(context);
            }
        }
        this.encodeEnd(context);
    }

    private static ArrayDeque<UIComponent> _getComponentELStack(String keyName, Map<Object, Object> contextAttributes) {
        return (ArrayDeque)contextAttributes.computeIfAbsent(keyName, e -> new ArrayDeque());
    }

    public void pushComponentToEL(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (component == null) {
            component = this;
        }
        Map<Object, Object> contextAttributes = context.getAttributes();
        ArrayDeque<UIComponent> componentELStack = UIComponent._getComponentELStack(_CURRENT_COMPONENT_STACK_KEY, contextAttributes);
        componentELStack.push(component);
        ++component._isPushedAsCurrentRefCount;
        if (UIComponent.isCompositeComponent(component)) {
            UIComponent._getComponentELStack(_CURRENT_COMPOSITE_COMPONENT_STACK_KEY, contextAttributes).push(component);
        }
    }

    public void popComponentFromEL(FacesContext context) {
        ArrayDeque<UIComponent> compositeELStack;
        if (context == null) {
            throw new NullPointerException();
        }
        Map<Object, Object> contextAttributes = context.getAttributes();
        ArrayDeque<UIComponent> componentELStack = UIComponent._getComponentELStack(_CURRENT_COMPONENT_STACK_KEY, contextAttributes);
        if (this._isPushedAsCurrentRefCount < 1) {
            if (componentELStack.peek() != this) {
                return;
            }
            LOGGER.log(Level.SEVERE, "the component(" + this + ") is the head component of the stack, but it's _isPushedAsCurrentRefCount < 1");
        }
        UIComponent topComponent = componentELStack.peek();
        while (topComponent != this) {
            topComponent.popComponentFromEL(context);
            topComponent = componentELStack.peek();
        }
        componentELStack.pop();
        --this._isPushedAsCurrentRefCount;
        if (UIComponent.isCompositeComponent(this) && !(compositeELStack = UIComponent._getComponentELStack(_CURRENT_COMPOSITE_COMPONENT_STACK_KEY, contextAttributes)).isEmpty()) {
            compositeELStack.pop();
        }
    }

    public static boolean isCompositeComponent(UIComponent component) {
        if (component == null) {
            throw new NullPointerException();
        }
        boolean result = false;
        if (null != component.isCompositeComponent) {
            result = component.isCompositeComponent;
        } else {
            component.isCompositeComponent = component.getAttributes().containsKey("jakarta.faces.application.Resource.ComponentResource");
            result = component.isCompositeComponent;
        }
        return result;
    }

    public static UIComponent getCompositeComponentParent(UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component.compositeParent != null) {
            return component.compositeParent;
        }
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!UIComponent.isCompositeComponent(parent)) continue;
            if (component.isInView()) {
                component.compositeParent = parent;
            }
            return parent;
        }
        return null;
    }

    public static UIComponent getCurrentComponent(FacesContext context) {
        Map<Object, Object> contextAttributes = context.getAttributes();
        ArrayDeque<UIComponent> componentELStack = UIComponent._getComponentELStack(_CURRENT_COMPONENT_STACK_KEY, contextAttributes);
        return componentELStack.peek();
    }

    public static UIComponent getCurrentCompositeComponent(FacesContext context) {
        return UIComponent._getComponentELStack(_CURRENT_COMPOSITE_COMPONENT_STACK_KEY, context.getAttributes()).peek();
    }

    protected abstract void addFacesListener(FacesListener var1);

    protected abstract FacesListener[] getFacesListeners(Class var1);

    protected abstract void removeFacesListener(FacesListener var1);

    public abstract void queueEvent(FacesEvent var1);

    public void subscribeToEvent(Class<? extends SystemEvent> eventClass, ComponentSystemEventListener componentListener) {
        throw new UnsupportedOperationException();
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> eventClass, ComponentSystemEventListener componentListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SystemEventListener> getListenersForEventClass(Class<? extends SystemEvent> eventClass) {
        throw new UnsupportedOperationException();
    }

    public UIComponent getNamingContainer() {
        for (UIComponent namingContainer = this; namingContainer != null; namingContainer = namingContainer.getParent()) {
            if (!(namingContainer instanceof NamingContainer)) continue;
            return namingContainer;
        }
        return null;
    }

    public abstract void processRestoreState(FacesContext var1, Object var2);

    public abstract void processDecodes(FacesContext var1);

    @Override
    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        if (event instanceof PostRestoreStateEvent) {
            ValueExpression valueExpression = this.getValueExpression("binding");
            if (valueExpression != null) {
                valueExpression.setValue(FacesContext.getCurrentInstance().getELContext(), (Object)this);
            }
            this.isCompositeComponent = null;
        }
    }

    public abstract void processValidators(FacesContext var1);

    public abstract void processUpdates(FacesContext var1);

    public abstract Object processSaveState(FacesContext var1);

    protected abstract FacesContext getFacesContext();

    protected abstract Renderer getRenderer(FacesContext var1);

    private Map<String, String> wrapBundleAsMap(final ResourceBundle bundle) {
        return new Map<String, String>(){

            public String toString() {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, String> cur : this.entrySet()) {
                    sb.append(cur.getKey()).append(": ").append(cur.getValue()).append('\n');
                }
                return sb.toString();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsKey(Object key) {
                if (key != null) {
                    return bundle.getString(key.toString()) != null;
                }
                return false;
            }

            @Override
            public boolean containsValue(Object value) {
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    if (!Objects.equals(value, bundle.getString(keys.nextElement()))) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                HashMap<String, String> mappings = new HashMap<String, String>();
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    String value = bundle.getString(key);
                    mappings.put(key, value);
                }
                return mappings.entrySet();
            }

            @Override
            public boolean equals(Object obj) {
                return obj != null && obj instanceof Map && this.entrySet().equals(((Map)obj).entrySet());
            }

            @Override
            public String get(Object key) {
                if (key == null) {
                    return null;
                }
                try {
                    return bundle.getString(key.toString());
                }
                catch (MissingResourceException e) {
                    return "???" + key + "???";
                }
            }

            @Override
            public int hashCode() {
                return bundle.hashCode();
            }

            @Override
            public boolean isEmpty() {
                return !bundle.getKeys().hasMoreElements();
            }

            @Override
            public Set<String> keySet() {
                HashSet<String> keySet = new HashSet<String>();
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    keySet.add(keys.nextElement());
                }
                return keySet;
            }

            @Override
            public String put(String k, String v) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends String, ? extends String> m) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String remove(Object k) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                int result = 0;
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    keys.nextElement();
                    ++result;
                }
                return result;
            }

            @Override
            public Collection<String> values() {
                ArrayList<String> result = new ArrayList<String>();
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    result.add(bundle.getString(keys.nextElement()));
                }
                return result;
            }
        };
    }

    private ResourceBundle findResourceBundleUnderFQCNofThis(FacesContext context) {
        String className = this.getClass().getName();
        Locale currentLocale = null;
        UIViewRoot root = null;
        ResourceBundle resourceBundle = null;
        if (context != null && (root = context.getViewRoot()) != null) {
            currentLocale = root.getLocale();
        }
        if (currentLocale == null) {
            currentLocale = Locale.getDefault();
        }
        try {
            resourceBundle = ResourceBundle.getBundle(className, currentLocale);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return resourceBundle;
    }

    private ResourceBundle findResourceBundleAsResource(FacesContext context) {
        Resource ccResource;
        if (this.getAttributes().containsKey("jakarta.faces.application.Resource.ComponentResource") && (ccResource = (Resource)this.getAttributes().get("jakarta.faces.application.Resource.ComponentResource")) != null && (ccResource = this.findComponentResourceBundleLocaleMatch(context, ccResource.getResourceName(), ccResource.getLibraryName())) != null) {
            PropertyResourceBundle propertyResourceBundle;
            block9: {
                InputStream propertiesInputStream = ccResource.getInputStream();
                try {
                    propertyResourceBundle = new PropertyResourceBundle(propertiesInputStream);
                    if (propertiesInputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (propertiesInputStream != null) {
                            try {
                                propertiesInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(UIComponent.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                propertiesInputStream.close();
            }
            return propertyResourceBundle;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource findComponentResourceBundleLocaleMatch(FacesContext context, String resourceName, String libraryName) {
        Resource result = null;
        PropertyResourceBundle resourceBundle = null;
        int i = ((String)resourceName).lastIndexOf(".");
        if (-1 != i) {
            resourceName = ((String)resourceName).substring(0, i) + ".properties";
            if (null != context) {
                result = context.getApplication().getResourceHandler().createResource((String)resourceName, libraryName);
                InputStream propertiesInputStream = null;
                try {
                    propertiesInputStream = result.getInputStream();
                    resourceBundle = new PropertyResourceBundle(propertiesInputStream);
                }
                catch (IOException ex) {
                    Logger.getLogger(UIComponent.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    block15: {
                        if (propertiesInputStream != null) {
                            try {
                                propertiesInputStream.close();
                            }
                            catch (IOException ioe) {
                                if (!LOGGER.isLoggable(Level.SEVERE)) break block15;
                                LOGGER.log(Level.SEVERE, null, ioe);
                            }
                        }
                    }
                }
            }
        }
        return resourceBundle != null ? result : null;
    }

    static enum PropertyKeys {
        rendered,
        attributes,
        bindings,
        rendererType,
        systemEventListeners,
        behaviors,
        passThroughAttributes;

    }

    static enum PropertyKeysPrivate {
        attributesThatAreSet;

    }

    static final class ComponentSystemEventListenerAdapter
    implements ComponentSystemEventListener,
    SystemEventListener,
    StateHolder,
    FacesWrapper<ComponentSystemEventListener> {
        ComponentSystemEventListener wrapped;
        Class<?> instanceClass;

        ComponentSystemEventListenerAdapter() {
        }

        ComponentSystemEventListenerAdapter(ComponentSystemEventListener wrapped, UIComponent component) {
            this.wrapped = wrapped;
            this.instanceClass = component.getClass();
        }

        @Override
        public void processEvent(SystemEvent event) throws AbortProcessingException {
            this.wrapped.processEvent((ComponentSystemEvent)event);
        }

        @Override
        public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
            this.wrapped.processEvent(event);
        }

        @Override
        public boolean isListenerForSource(Object component) {
            if (this.wrapped instanceof SystemEventListener) {
                return ((SystemEventListener)((Object)this.wrapped)).isListenerForSource(component);
            }
            return this.instanceClass.isAssignableFrom(component.getClass());
        }

        @Override
        public Object saveState(FacesContext context) {
            if (context == null) {
                throw new NullPointerException();
            }
            return new Object[]{this.wrapped instanceof UIComponent ? null : new StateHolderSaver(context, this.wrapped), this.instanceClass};
        }

        @Override
        public void restoreState(FacesContext context, Object state) {
            if (context == null) {
                throw new NullPointerException();
            }
            if (state == null) {
                return;
            }
            Object[] s = (Object[])state;
            Object listener = s[0];
            this.wrapped = (ComponentSystemEventListener)(listener == null ? UIComponent.getCurrentComponent(context) : ((StateHolderSaver)listener).restore(context));
            this.instanceClass = (Class)s[1];
        }

        @Override
        public boolean isTransient() {
            if (this.wrapped instanceof StateHolder) {
                return ((StateHolder)((Object)this.wrapped)).isTransient();
            }
            return false;
        }

        @Override
        public void setTransient(boolean newTransientValue) {
        }

        @Override
        public ComponentSystemEventListener getWrapped() {
            return this.wrapped;
        }

        public int hashCode() {
            return this.wrapped.hashCode() ^ this.instanceClass.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ComponentSystemEventListenerAdapter)) {
                return false;
            }
            ComponentSystemEventListenerAdapter in = (ComponentSystemEventListenerAdapter)obj;
            return this.wrapped.equals(in.wrapped) && this.instanceClass.equals(in.instanceClass);
        }
    }
}

